package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayGetResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunAccessGatewayGetRequest implements BaseRequest<RunAccessGatewayGetResponse> {

    private static final long serialVersionUID = 5448959524634959646L;

    /**
     * 接入设备标识 devAccessId
     * 或
     * 系统单位编号 orgNo && 接入设备分类编号 devAccessSortNo && 接入设备编号 devAccessNo
     * 或
     * 接入网关设备所属产品 productKey && 接入网关设备客户端标识 clientId
     * 或
     * 接入网关设备所属产品 productKey && 上行通讯规约 upcommProto && 上行通讯逻辑地址终端 upcommLogicAddr
     * 接入网关设备所属产品 productKey && 上行通讯规约 upcommProto && 上行通讯逻辑地址表计 devAccessId
     *
     * 以上三组必须选择一组参数
     *
     */
    private Long devAccessId;
    private String orgNo;
    private String devAccessSortNo;
    private String devAccessNo;
    private String productKey;
    private String clientId;
    private String upcommProto;
    private String upcommLogicAddr;

    @Override
    public Class<RunAccessGatewayGetResponse> getResponseClass() {
        return RunAccessGatewayGetResponse.class;
    }

}
