package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayOpsInfoUpdateResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunAccessGatewayOpsInfoUpdateRequest implements BaseRequest<RunAccessGatewayOpsInfoUpdateResponse> {

    private static final long serialVersionUID = -8520599937001916014L;

    /**
     * 接入设备标识 devAccessId
     * 或
     * 系统单位编号 orgNo && 接入设备分类编号 devAccessSortNo && 接入设备编号 devAccessNo
     * 或
     * 接入网关设备所属产品 productKey && 接入网关设备客户端标识 clientId
     * 或
     * 接入网关设备所属产品 productKey && 上行通讯规约 upcommProto && 上行通讯规约 upcommLogicAddr
     *
     * 以上三组必须选择一组参数
     *
     */
    private Long devAccessId;
    private String orgNo;
    private String devAccessSortNo;
    private String devAccessNo;
    private String productKey;
    private String clientId;
    private String upcommProto;
    private String upcommLogicAddr;

    /**
     * 运行参数
     */
    private String runParam;

    /**
     * 运行客户端IP
     */
    private String runClientIp;

    /**
     * 运行客户端端口
     */
    private Integer runClientPort;

    /**
     * 运行服务端IP
     */
    private String runServerIp;

    /**
     * 运行服务端端口
     */
    private Integer runServerPort;

    /**
     * 运行服务端APN
     */
    private String runServerApn;

    /**
     * 软件版本
     */
    private String softwareVer;

    /**
     * 硬件版本
     */
    private String hardwareVer;

    /**
     * 最近一次在线时间
     */
    private Long gmtConnectedAt;

    /**
     * 最近一次心跳通讯时间
     */
    private Long gmtHeartbeatUp;

    /**
     * 最近一次报文上行时间
     */
    private Long gmtMessageUp;

    /**
     * 最近一次量测数据上行时间
     */
    private Long gmtMeasdataUp;

    /**
     * 最近一次告警上行时间
     */
    private Long gmtAlarmUp;

    @Override
    public Class<RunAccessGatewayOpsInfoUpdateResponse> getResponseClass() {
        return RunAccessGatewayOpsInfoUpdateResponse.class;
    }

}
