package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.RunMeasPointOpsInfoBatchUpdateResponse;
import com.easesource.iot.datacenter.openservice.response.RunMeasPointOpsInfoUpdateResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2020-04-18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunMeasPointOpsInfoBatchUpdateRequest implements BaseRequest<RunMeasPointOpsInfoBatchUpdateResponse> {

    private static final long serialVersionUID = -5443806331078346259L;

    /**
     * 量测点标识
     */
    private List<Long> measPointIdList;

    /**
     * 最近一次报文上行时间
     */
    private Long gmtMessageUp;

    /**
     * 最近一次量测数据上行时间
     */
    private Long gmtMeasdataUp;

    /**
     * 最近一次告警上行时间
     */
    private Long gmtAlarmUp;

    @Override
    public Class<RunMeasPointOpsInfoBatchUpdateResponse> getResponseClass() {
        return RunMeasPointOpsInfoBatchUpdateResponse.class;
    }

}
