package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.RunMeasPointOpsInfoUpdateResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunMeasPointOpsInfoUpdateRequest implements BaseRequest<RunMeasPointOpsInfoUpdateResponse> {

    private static final long serialVersionUID = -2782332642084125711L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 最近一次报文上行时间
     */
    private Long gmtMessageUp;

    /**
     * 最近一次量测数据上行时间
     */
    private Long gmtMeasdataUp;

    /**
     * 最近一次告警上行时间
     */
    private Long gmtAlarmUp;

    @Override
    public Class<RunMeasPointOpsInfoUpdateResponse> getResponseClass() {
        return RunMeasPointOpsInfoUpdateResponse.class;
    }

}
