package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasDataAlarmDiscreteValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataAlarmDiscreteGetRangeResponse extends BaseResponse {

    private static final long serialVersionUID = -6344511836181255678L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测点数据信息Map
     *  <p>key</p>
     *      量测项编码 measItemCode
     *  <p>value</p>
     *      @see MeasDataAlarmDiscreteValue 告警量离散数据值
     */
    private Map<String, List<MeasDataAlarmDiscreteValue>> measDataListMap;

}
