package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataCumFreezeCurveBatchGetMTPsResponse extends BaseResponse {

    private static final long serialVersionUID = 4182286861005254764L;

    /**
     * 批量量测点数据信息Map
     *  <p>key</p>
     *      量测点标识
     *  <p>value</p>
     *      量测点数据信息Map
     *      <p>key</p>
     *          量测项编码 measItemCode
     *      <p>value</p>
     *          @see MeasDataCumFreezeCurveValue 累计量曲线数据值
     */
    private Map<Long, Map<String, List<MeasDataCumFreezeCurveValue>>> batchMeasDataMap;

}
