package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeDayValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataCumFreezeDayGetRangeResponse extends BaseResponse {

    private static final long serialVersionUID = 3630078691600493377L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测点数据信息Map
     *  <p>key</p>
     *      量测项编码 measItemCode
     *  <p>value</p>
     *      @see MeasDataCumFreezeDayValue 累计量日冻结数据值
     */
    private Map<String, List<MeasDataCumFreezeDayValue>> measDataMap;

}
