package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataInsFreezeCurveBatchGetResponse extends BaseResponse {

    private static final long serialVersionUID = -3986262623566863526L;

    /**
     * 批量量测点数据信息Map
     *  <p>key</p>
     *      量测点标识
     *  <p>value</p>
     *      量测点数据信息Map
     *      <p>key</p>
     *          量测项编码 measItemCode
     *      <p>value</p>
     *          @see MeasDataInsFreezeCurveValue 瞬时量曲线数据值
     */
    private Map<Long, Map<String, MeasDataInsFreezeCurveValue>> batchMeasDataMap;

}
