package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataInsFreezeCurveGetRangeBaseResponse implements Serializable {

    private static final long serialVersionUID = 521453465346565123L;
    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测点数据信息Map
     *  <p>key</p>
     *      量测项编码 measItemCode
     *  <p>value</p>
     *      @see MeasDataInsFreezeCurveValue 瞬时量曲线数据值
     */
    private Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap;

}
