package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataLatestBatchGetResponse extends BaseResponse {

    private static final long serialVersionUID = 6602761175469112406L;

    /**
     * 批量量测点数据信息Map
     *  <p>key</p>
     *      量测点标识
     *  <p>value</p>
     *      量测点数据信息Map
     *      <p>key</p>
     *          量测项编码 measItemCode
     *      <p>value</p>
     *          @see MeasDataLatestInfo 量测数据信息
     */
    private Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap;

}
