package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasStatCumDayValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2022-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasStatCumDayBatchGetResponse extends BaseResponse {

    private static final long serialVersionUID = -1516690293898681157L;

    /**
     * 批量量测点数据信息Map
     *  <p>key</p>
     *      量测点标识
     *  <p>value</p>
     *      量测点数据信息Map
     *       <p>key</p>
     *           量测项编码 measItemCode
     *       <p>value</p>
     *           @see MeasStatCumDayValue 累计量日统计数据
     */
    private Map<Long, Map<String, MeasStatCumDayValue>> batchMeasStatMap;

}
