package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasStatCumDayValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasStatCumDayGetResponse extends BaseResponse {

    private static final long serialVersionUID = 5258420260971480081L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测点数据信息Map
     *  <p>key</p>
     *      量测项编码 measItemCode
     *  <p>value</p>
     *      @see MeasStatCumDayValue 累计量日统计数据
     */
    private Map<String, MeasStatCumDayValue> measStatMap;

}
