package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasStatCumYearValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2022-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasStatCumYearBatchGetRangeResponse extends BaseResponse {

    private static final long serialVersionUID = 6138545551559054160L;

    /**
     * 批量量测点数据信息Map
     *  <p>key</p>
     *      量测点标识
     *  <p>value</p>
     *      量测点数据信息Map
     *      <p>key</p>
     *          量测项编码 measItemCode
     *      <p>value</p>
     *          @see MeasStatCumYearValue 累计量年统计数据
     */
    private Map<Long, Map<String, List<MeasStatCumYearValue>>> batchMeasStatListMap;

}
