package com.easesource.iot.datacenter.openservice.response;

import com.easesource.iot.datacenter.openservice.entity.MeasStatInsYearValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class MeasStatInsYearGetRangeResponse extends BaseResponse {

    private static final long serialVersionUID = -8687359283605747281L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测点数据信息Map
     *  <p>key</p>
     *      量测项编码 measItemCode
     *  <p>value</p>
     *      @see MeasStatInsYearValue 瞬时量年统计数据
     */
    private Map<String, List<MeasStatInsYearValue>> measStatListMap;

}
