package com.easesource.iot.datacenter.openservice.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
public interface MeasDataLatestDao extends CrudMapper<MeasDataLatestDo, Long> {

    /**
     * 批量更新
     * @param measDataLatestDoList
     *          量测点最新数据实体列表
     * @return
     */
    int updateBatch(@Param("list") List<MeasDataLatestDo> measDataLatestDoList);

    /**
     * 通过量测点标识和量测项编码更新量测点最新数据实体
     * @param measDataLatestDo
     *          量测点最新数据实体
     * @return
     *          结果
     */
    int updateByMeasPointIdAndMeasItemCode(MeasDataLatestDo measDataLatestDo);

    /**
     * 通过量测点标识和量测项编码删除量测点最新数据实体
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @return
     *          结果
     */
    int deleteByMeasPointIdAndMeasItemCode(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode);

    /**
     * 通过量测点标识和量测项编码获取量测点最新数据实体
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @return
     *          量测点最新数据实体
     */
    MeasDataLatestDo getByMeasPointIdAndMeasItemCode(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode);

    /**
     * 通过量测点标识获取量测点最新数据实体列表
     *
     * @param measPointIdSet
     *          量测点标识
     * @param measItemCodeSet
     *          量测项编码
     * @return
     */
    List<MeasDataLatestDo> getListByMeasPointIdSetAndMeasItemCodeSet(@Param("measPointIdSet") Set<Long> measPointIdSet, @Param("measItemCodeSet") Set<String> measItemCodeSet);

    /**
     * 通过量测点标识和量测项编码获取量测点最新数据视图
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param gmtMeasDataLatest
     *          最近数据
     * @return
     *          量测点最新数据实体
     */
    MeasDataLatestVo getMeasDataLatestVoByMeasPointIdAndMeasItemCode(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode, @Param("gmtMeasDataLatest") Long gmtMeasDataLatest);

    /**
     * 通过量测点标识和量测项编码获取量测点最新数据视图
     *
     * @param measPointIdSet
     *          量测点标识
     * @param measItemCodeSet
     *          量测项编码
     * @param gmtMeasDataLatest
     *          最近数据
     * @return
     *          量测点最新数据实体
     */
    List<MeasDataLatestVo> getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(@Param("measPointIdSet") Set<Long> measPointIdSet, @Param("measItemCodeSet") Set<String> measItemCodeSet, @Param("gmtMeasDataLatest") Long gmtMeasDataLatest);

    int insertBatch(@Param("MeasDataLatestList") List<MeasDataLatestDo> MeasDataLatestList);

    List<MeasDataLatestVo> getMeasDataLatestVoAll();

    void updateMeasDataLatestBatch(@Param("list") List<MeasDataLatestDo> list);
}
