package com.easesource.iot.datacenter.openservice.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointChangeLogDo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointDo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointVo;
import com.easesource.iot.datacenter.openservice.request.EditMeterRequest;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
@Mapper
public interface RunMeasPointDao extends CrudMapper<RunMeasPointDo, Long> {

    int deleteById(Long id);

    RunMeasPointVo getRunMeasPointVoByMeasPointId(Long id);

    List<RunMeasPointVo> getRunMeasPointVoListByAccessGatewayId(@Param("accessGatewayId") Long accessGatewayId);

    List<RunMeasPointVo> getRunMeasPointVoListByOrgNoAndDevAccessGatewaySortNoAndDevAccessGatewayNo(@Param("orgNo") String orgNo, @Param("devAccessGatewaySortNo") String devAccessGatewaySortNo, @Param("devAccessGatewayNo") String devAccessGatewayNo);

    List<RunMeasPointVo> getRunMeasPointVoListByProductKeyAndClientId(@Param("productKey") String productKey, @Param("clientId") String clientId);

    List<RunMeasPointVo> getRunMeasPointVoListByProductKeyAndUpcommProtoAndUpcommLogicAddr(@Param("productKey") String productKey, @Param("upcommProto") String upcommProto, @Param("upcommLogicAddr") String upcommLogicAddr);

    void brushMeasPoint(@Param("id") long id,@Param("devTermCommAddr")String mac,@Param("devMeterCommAddr")String devMeterCommAddr);


    List<RunMeasPointVo> getRunMeasPointListBySn(@Param("sn") String sn,@Param("isMeter") String isMeter);


    void insertRunMeasPointLog(@Param("runMeasPointChangeLogDo") RunMeasPointChangeLogDo runMeasPointChangeLogDo);

    Set<Long> getRunAccessGatewayMeasPointIds(@Param("gatewayIdSet") Set<Long> gatewayIdSet);

    void editMeter(@Param("editMeterRequest")  EditMeterRequest editMeterRequest);

    RunMeasPointVo selectByGatewayIdMeterNo(@Param("devMeterNo")String devMeterNo,@Param("accessGatewayId") Long accessGatewayId);

    List<RunMeasPointVo> getRunMeasPointVoListByIdClear(@Param("devAccessNo") String devAccessNo,@Param("upcommProto") String upcommProto);
}
