package com.easesource.iot.datacenter.openservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.dao.*;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "accessMgmtService")
public class AccessMgmtServiceImpl extends AbstractBaseService implements AccessMgmtService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private DevAccessDao devAccessDao;

    @Resource
    private DevAccessGatewayDao devAccessGatewayDao;

    @Resource
    private DevAccessTrunkingDao devAccessTrunkingDao;

    @Resource
    private DevAccessMeasureDao devAccessMeasureDao;

    @Resource
    private RunAccessGatewayDao runAccessGatewayDao;

    @Resource
    private RunMeasPointDao runMeasPointDao;

    @Resource
    private LogDevAccessEntityDao logDevAccessEntityDao;

    @Override
    public DevAccessGatewayQueryResponse queryDevAccessGateway(DevAccessGatewayQueryRequest devAccessGatewayQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start queryDevAccessGateway >>>>>>> ");
            logger.debug(" DevAccessGatewayQueryRequest     : " + JsonConvertUtils.convertToString(devAccessGatewayQueryRequest));
        }

        DevAccessGatewayQueryResponse response = new DevAccessGatewayQueryResponse();
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" DevAccessGatewayQueryResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end queryDevAccessGateway <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayGetResponse getRunAccessGateway(RunAccessGatewayGetRequest getRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayGetRequest   : " + JsonConvertUtils.convertToString(getRequest));
        }

        RunAccessGatewayGetResponse getResponse = new RunAccessGatewayGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        if(getRequest != null && getRequest.getDevAccessId() != null && getRequest.getDevAccessId() > 0L) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoById(getRequest.getDevAccessId());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(getRequest.getDevAccessId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByOrgNoAndDevAccessSortNoAndDevAccessNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByOrgNoAndDevAccessGatewaySortNoAndDevAccessGatewayNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getClientId())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null &&  !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getDevAccessNo(),getRequest.getUpcommProto())) {
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByIdClear( getRequest.getDevAccessNo(),getRequest.getUpcommProto());
            RunAccessGatewayVo runAccessGateway =new RunAccessGatewayVo();
            if (runMeasPointList.size()>0){
                runAccessGateway=runAccessGatewayDao.getRunAccessGatewayVoById(runMeasPointList.get(0).getAccessGatewayId());

            }
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayGetResponse  : " + JsonConvertUtils.convertToString(getResponse));
            logger.debug(" <<<<<<<< end getRunAccessGateway <<<<<<<< ");
        }
        return getResponse;
    }

    @Override
    public RunAccessGatewayNameAndDescUpdateResponse updateRunAccessGatewayNameAndDesc(RunAccessGatewayNameAndDescUpdateRequest runAccessGatewayNameAndDescUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunAccessGatewayNameAndDesc >>>>>>> ");
            logger.debug(" RunAccessGatewayNameAndDescUpdateRequest : " + JsonConvertUtils.convertToString(runAccessGatewayNameAndDescUpdateRequest));
        }

        RunAccessGatewayNameAndDescUpdateResponse response = new RunAccessGatewayNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayNameAndDescUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            DevAccessDo devAccessDo = devAccessDao.get(devAccessId);
            if(devAccessDo != null && StringUtils.isNotBlank(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName())) {
                devAccessDo.setDevAccessName(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName());
            }
            if(devAccessDo != null && StringUtils.isNotBlank(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc())) {
                devAccessDo.setDevAccessDesc(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc());
            }
            devAccessDao.update(devAccessDo);
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayNameAndDescUpdateResponse  : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunAccessGatewayNameAndDesc <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayRunStatusUpdateResponse updateRunAccessGatewayRunStatus(RunAccessGatewayRunStatusUpdateRequest runAccessGatewayRunStatusUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunAccessGatewayRunStatus >>>>>>> ");
            logger.debug(" RunAccessGatewayRunStatusUpdateRequest   : " + JsonConvertUtils.convertToString(runAccessGatewayRunStatusUpdateRequest));
        }

        RunAccessGatewayRunStatusUpdateResponse response = new RunAccessGatewayRunStatusUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayRunStatusUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                runAccessGatewayDo.setRunStatus(runAccessGatewayRunStatusUpdateRequest.getRunStatus());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayRunStatusUpdateResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunAccessGatewayRunStatus <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayOpsInfoUpdateResponse updateRunAccessGatewayOpsInfo(RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunAccessGatewayOpsInfo >>>>>>> ");
            logger.debug(" RunAccessGatewayOpsInfoUpdateRequest     : " + JsonConvertUtils.convertToString(runAccessGatewayOpsInfoUpdateRequest));
        }

        RunAccessGatewayOpsInfoUpdateResponse response = new RunAccessGatewayOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOpsInfoUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunParam())) {
                    runAccessGatewayDo.setRunParam(runAccessGatewayOpsInfoUpdateRequest.getRunParam());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunClientIp())) {
                    runAccessGatewayDo.setRunClientIp(runAccessGatewayOpsInfoUpdateRequest.getRunClientIp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getRunClientPort())) {
                    runAccessGatewayDo.setRunClientPort(runAccessGatewayOpsInfoUpdateRequest.getRunClientPort());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunServerIp())) {
                    runAccessGatewayDo.setRunServerIp(runAccessGatewayOpsInfoUpdateRequest.getRunServerIp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getRunServerPort())) {
                    runAccessGatewayDo.setRunServerPort(runAccessGatewayOpsInfoUpdateRequest.getRunServerPort());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunServerApn())) {
                    runAccessGatewayDo.setRunServerApn(runAccessGatewayOpsInfoUpdateRequest.getRunServerApn());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer())) {
                    runAccessGatewayDo.setSoftwareVer(runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getHardwareVer())) {
                    runAccessGatewayDo.setHardwareVer(runAccessGatewayOpsInfoUpdateRequest.getHardwareVer());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtConnectedAt(runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtHeartbeatUp(runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMessageUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMeasdataUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtAlarmUp(runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp());
                }
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayOpsInfoUpdateResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunAccessGatewayOpsInfo <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayOfflineSetResponse setRunAccessGatewayOffline(RunAccessGatewayOfflineSetRequest runAccessGatewayOfflineSetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start setRunAccessGatewayOffline >>>>>>> ");
            logger.debug(" RunAccessGatewayOfflineSetRequest        : " + JsonConvertUtils.convertToString(runAccessGatewayOfflineSetRequest));
        }

        RunAccessGatewayOfflineSetResponse response = new RunAccessGatewayOfflineSetResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOfflineSetRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                runAccessGatewayDo.setOnline(false);
                runAccessGatewayDo.setGmtOffline(runAccessGatewayOfflineSetRequest.getGmtOffline());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayOfflineSetResponse       : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end setRunAccessGatewayOffline <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayAddToOrgResponse addToOrgRunAccessGateway(RunAccessGatewayAddToOrgRequest runAccessGatewayAddToOrgRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start addToOrgRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayAddToOrgRequest          : " + JsonConvertUtils.convertToString(runAccessGatewayAddToOrgRequest));
        }

        RunAccessGatewayAddToOrgResponse response = new RunAccessGatewayAddToOrgResponse();
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayAddToOrgResponse         : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end addToOrgRunAccessGateway <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayDeleteFromOrgResponse deleteFromOrgRunAccessGateway(RunAccessGatewayDeleteFromOrgRequest runAccessGatewayDeleteFromOrgRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start deleteFromOrgRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayDeleteFromOrgRequest     : " + JsonConvertUtils.convertToString(runAccessGatewayDeleteFromOrgRequest));
        }

        RunAccessGatewayDeleteFromOrgResponse response = new RunAccessGatewayDeleteFromOrgResponse();
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayDeleteFromOrgResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end deleteFromOrgRunAccessGateway <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayQueryResponse queryRunAccessGateway(RunAccessGatewayQueryRequest queryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start queryRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayQueryRequest     : " + JsonConvertUtils.convertToString(queryRequest));
        }

        RunAccessGatewayQueryResponse queryResponse = new RunAccessGatewayQueryResponse();
        queryResponse.setReturnCode("FAILURE");
        queryResponse.setFailureCode("-1");
        Set<Long> devAccessIdSet = queryRequest.getDevAccessIdSet();
        Set<String> orgNoSet = queryRequest.getOrgNoSet();
        Set<String> devAccessSortNoSet = queryRequest.getDevAccessSortNoSet();
        Set<String> devAccessNoSet = queryRequest.getDevAccessNoSet();
        Set<String> productKeySet = queryRequest.getProductKeySet();
        Set<String> clientIdSet = queryRequest.getClientIdSet();
        Map<String, Object> params = Maps.newHashMap();
        if(devAccessIdSet != null && devAccessIdSet.size() > 0) {
            params.put("devAccessId", devAccessIdSet.iterator().next());
        }
        else if(orgNoSet != null && orgNoSet.size() > 0) {
            params.put("orgNo", orgNoSet.iterator().next());
        }
        else if(devAccessSortNoSet != null && devAccessSortNoSet.size() > 0) {
            params.put("devAccessSortNo", devAccessSortNoSet.iterator().next());
        }
        else if(devAccessNoSet != null && devAccessNoSet.size() > 0) {
            params.put("devAccessNo", devAccessNoSet.iterator().next());
        }
        else if(productKeySet != null && productKeySet.size() > 0) {
            params.put("productKey", productKeySet.iterator().next());
        }
        else if(clientIdSet != null && clientIdSet.size() > 0) {
            params.put("clientId", clientIdSet.iterator().next());
        }
        int runAccessGatewayVoCount = runAccessGatewayDao.getRunAccessGatewayVoCount(params);
        List<RunAccessGatewayVo> runAccessGatewayVoList = runAccessGatewayDao.getRunAccessGatewayVoList(params, null, null);
        queryResponse.setReturnCode("SUCCESS");
        queryResponse.setFailureCode(null);
        queryResponse.setRunAccessGatewayCount(runAccessGatewayVoCount);
        queryResponse.setRunAccessGatewayList(runAccessGatewayVoList);

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayQueryResponse    : " + JsonConvertUtils.convertToString(queryResponse));
            logger.debug(" <<<<<<<< end queryRunAccessGateway <<<<<<<< ");
        }
        return queryResponse;
    }

    @Override
    public RunMeasPointGetResponse getRunMeasPoint(RunMeasPointGetRequest getRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRunMeasPoint >>>>>>> ");
            logger.debug(" RunMeasPointGetRequest       : " + JsonConvertUtils.convertToString(getRequest));
        }

        RunMeasPointGetResponse getResponse = new RunMeasPointGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        Long measPointId = getRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunMeasPoint(runMeasPointVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunMeasPointGetResponse      : " + JsonConvertUtils.convertToString(getResponse));
            logger.debug(" <<<<<<<< end getRunMeasPoint <<<<<<<< ");
        }
        return getResponse;
    }

    @Override
    public RunMeasPointNameAndDescUpdateResponse updateRunMeasPointNameAndDesc(RunMeasPointNameAndDescUpdateRequest runMeasPointNameAndDescUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunMeasPointNameAndDesc >>>>>>> ");
            logger.debug(" RunMeasPointNameAndDescUpdateRequest     : " + JsonConvertUtils.convertToString(runMeasPointNameAndDescUpdateRequest));
        }

        RunMeasPointNameAndDescUpdateResponse response = new RunMeasPointNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointNameAndDescUpdateRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = runMeasPointDao.get(measPointId);
            if(runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                Long accessMeasureId = runMeasPointDo.getAccessMeasureId();
                DevAccessDo devAccessDo = devAccessDao.get(accessMeasureId);
                if(devAccessDo != null && StringUtils.isNotBlank(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName())) {
                    devAccessDo.setDevAccessName(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName());
                }
                if(devAccessDo != null && StringUtils.isNotBlank(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc())) {
                    devAccessDo.setDevAccessDesc(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc());
                }
                devAccessDao.update(devAccessDo);
            }

            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunMeasPointNameAndDescUpdateResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunMeasPointNameAndDesc <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunMeasPointOpsInfoUpdateResponse updateRunMeasPointOpsInfo(RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunMeasPointOpsInfo >>>>>>> ");
            logger.debug(" RunMeasPointOpsInfoUpdateRequest         : " + JsonConvertUtils.convertToString(runMeasPointOpsInfoUpdateRequest));
        }

        RunMeasPointOpsInfoUpdateResponse response = new RunMeasPointOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointOpsInfoUpdateRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = runMeasPointDao.get(measPointId);
            if(runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runMeasPointDo.setGmtMessageUp(runMeasPointOpsInfoUpdateRequest.getGmtMessageUp());
                }
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runMeasPointDo.setGmtMeasdataUp(runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp());
                }
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runMeasPointDo.setGmtAlarmUp(runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp());
                }
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDao.update(runMeasPointDo);
            }

            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunMeasPointOpsInfoUpdateResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunMeasPointOpsInfo <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunMeasPointOpsInfoBatchUpdateResponse batchUpdateRunMeasPointOpsInfo(RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest) {
        RunMeasPointOpsInfoBatchUpdateResponse response = new RunMeasPointOpsInfoBatchUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        List<RunMeasPointVo> runMeasPointList=new ArrayList<>();
        for(Long measPointId:runMeasPointOpsInfoBatchUpdateRequest.getMeasPointIdList()){
            if( measPointId > 0L) {
                RunMeasPointDo runMeasPointDo = runMeasPointDao.get(measPointId);
                if(runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                    if(ObjectUtils.isNotNull(runMeasPointOpsInfoBatchUpdateRequest.getGmtMessageUp())) {
                        runMeasPointDo.setGmtMessageUp(runMeasPointOpsInfoBatchUpdateRequest.getGmtMessageUp());
                    }
                    if(ObjectUtils.isNotNull(runMeasPointOpsInfoBatchUpdateRequest.getGmtMeasdataUp())) {
                        runMeasPointDo.setGmtMeasdataUp(runMeasPointOpsInfoBatchUpdateRequest.getGmtMeasdataUp());
                    }
                    if(ObjectUtils.isNotNull(runMeasPointOpsInfoBatchUpdateRequest.getGmtAlarmUp())) {
                        runMeasPointDo.setGmtAlarmUp(runMeasPointOpsInfoBatchUpdateRequest.getGmtAlarmUp());
                    }
                    runMeasPointDo.setGmtModified(System.currentTimeMillis());
                    runMeasPointDao.update(runMeasPointDo);
                }
                RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
                runMeasPointList.add(runMeasPointVo);
            }
        }
        response.setReturnCode("SUCCESS");
        response.setFailureCode(null);
        response.setRunMeasPointList(runMeasPointList);
        return response;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public RunAccessGatewayRunStatusUpdateResponse brushMeter(String mac,String key) {
        RunAccessGatewayRunStatusUpdateResponse response = new RunAccessGatewayRunStatusUpdateResponse();
        //获取runMeasPoint下装接的表计
        List<RunMeasPointVo> runMeasPointDoList=runMeasPointDao.getRunMeasPointListBySn(mac,null);
        if (CollectionUtils.isEmpty(runMeasPointDoList)){
            return null;
        }
        long now = System.currentTimeMillis();

        long id =iotDeviceIdGenerator.nextId();
        DevAccessDo devAccessDoOld=devAccessDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
        DevAccessDo devAccessDo=new DevAccessDo();
        devAccessDo.setId(id);
        devAccessDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
        devAccessDo.setDevAccessSortNo("HEPSTD-PV-METER");
        devAccessDo.setDevAccessNo(mac+"-"+key);
        devAccessDo.setDevAccessName(key);
        devAccessDo.setDevAccessDesc(key);
        devAccessDo.setDevAccessDetail("{}");
        devAccessDo.setGateway(false);
        devAccessDo.setTrunking(false);
        devAccessDo.setMeasure(true);
        devAccessDo.setLifeState("03");
        devAccessDo.setMfrCode("HEPSTD");
        devAccessDo.setModelCode("HEPSTD-PV-INVERTER");
        devAccessDo.setSortSn(1);
        devAccessDo.setValid(true);
        devAccessDo.setGmtCreate(now);
        devAccessDo.setGmtModified(now);
        devAccessDo.setGmtInvalid(0);
        devAccessDo.setVersion(devAccessDoOld.getVersion()+1);
        devAccessDao.insert(devAccessDo);

        DevAccessMeasureDo devAccessMeasureDoOld=devAccessMeasureDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
        DevAccessMeasureDo devAccessMeasureDo=new DevAccessMeasureDo();
        devAccessMeasureDo.setId(id);
        devAccessMeasureDo.setMeasCommMode("RS485");
        devAccessMeasureDo.setMeasCommAddr(key);
        devAccessMeasureDo.setMeasCommProto("MODBUS-RTU");
        devAccessMeasureDo.setEnableElec(true);
        devAccessMeasureDo.setVersion(devAccessMeasureDoOld.getVersion()+1);
        devAccessMeasureDao.insert(devAccessMeasureDo);

        RunMeasPointDo runMeasPointDo=new RunMeasPointDo();
        runMeasPointDo.setId(iotDeviceIdGenerator.nextId());
        runMeasPointDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
        runMeasPointDo.setAccessMeasureId(id);
        runMeasPointDo.setAccessTrunkingId((long)0);
        runMeasPointDo.setAccessGatewayId(runMeasPointDoList.get(0).getAccessGatewayId());
        runMeasPointDo.setMeasKind(0);
        runMeasPointDo.setMeasSn(0);
        runMeasPointDo.setMeasCommMode("RS485");
        runMeasPointDo.setMeasCommAddr(key);
        runMeasPointDo.setMeasCommProto("MODBUS-RTU");
        runMeasPointDo.setMeasCommPort(0);
        runMeasPointDo.setGmtMessageUp(now);
        runMeasPointDo.setGmtMeasdataUp(now);
        runMeasPointDo.setGmtAlarmUp(0);
        runMeasPointDo.setGmtCreate(now);
        runMeasPointDo.setGmtModified(now);
        runMeasPointDo.setVersion(runMeasPointDoList.get(0).getVersion()+1);
        runMeasPointDao.insert(runMeasPointDo);

        //插入日志表
        RunMeasPointChangeLogDo runMeasPointChangeLogDo=new RunMeasPointChangeLogDo();
        BeanUtils.copyProperties(runMeasPointDo,runMeasPointChangeLogDo);
        runMeasPointChangeLogDo.setSn(mac);
        runMeasPointDao.insertRunMeasPointLog(runMeasPointChangeLogDo);


        response.setReturnCode("SUCCESS");
        response.setFailureCode(null);
        logger.info("终端地址： " + mac + " 三张表刷新成功");
        return response;
    }

    @Override
    public RunMeasPointListResponse getRunMeasPointListBySn(String sn) {
        List<RunMeasPointVo> runMeasPointDoList=runMeasPointDao.getRunMeasPointListBySn(sn,"1");
        RunMeasPointListResponse runMeasPointListResponse=new RunMeasPointListResponse();
        runMeasPointListResponse.setRunMeasPointList(runMeasPointDoList);
        return runMeasPointListResponse;
    }

    @Override
    public BrushMeterResponse addTermMeter(String devTermNo, String devMeterNo) {
        //获取原存在表计
        logger.info("装接终端表计====》终端地址： " + devTermNo + " 添加表计地址： " + devMeterNo);
        RunMeasPointListResponse runMeasPointListResponse=getRunMeasPointListBySn(devTermNo);
        List<RunMeasPointVo> runMeasPointList=runMeasPointListResponse.getRunMeasPointList();
        List<RunMeasPointVo> measCommAddrList = runMeasPointList.stream().filter(runMeasPointVo -> runMeasPointVo.getMeasCommAddr().equals(devMeterNo)).collect(Collectors.toList());
        BrushMeterResponse brushMeterResponse=new BrushMeterResponse();
        if (CollectionUtils.isEmpty(measCommAddrList)) {
            //获取runMeasPoint下装接的表计
            List<RunMeasPointVo> runMeasPointDoList=runMeasPointDao.getRunMeasPointListBySn(devTermNo,null);
            if (CollectionUtils.isEmpty(runMeasPointDoList)){
                return null;
            }
            long now = System.currentTimeMillis();

            long id =iotDeviceIdGenerator.nextId();
            DevAccessDo devAccessDoOld=devAccessDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
            DevAccessDo devAccessDo=new DevAccessDo();
            devAccessDo.setId(id);
            devAccessDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
            devAccessDo.setDevAccessSortNo("HEPSTD-PV-METER");
            devAccessDo.setDevAccessNo(devTermNo+"-"+devMeterNo);
            devAccessDo.setDevAccessName(devMeterNo);
            devAccessDo.setDevAccessDesc(devMeterNo);
            devAccessDo.setDevAccessDetail("{}");
            devAccessDo.setGateway(false);
            devAccessDo.setTrunking(false);
            devAccessDo.setMeasure(true);
            devAccessDo.setLifeState("03");
            devAccessDo.setMfrCode("HEPSTD");
            devAccessDo.setModelCode("HEPSTD-PV-INVERTER");
            devAccessDo.setSortSn(1);
            devAccessDo.setValid(true);
            devAccessDo.setGmtCreate(now);
            devAccessDo.setGmtModified(now);
            devAccessDo.setGmtInvalid(0);
            devAccessDo.setVersion(devAccessDoOld==null?1:devAccessDoOld.getVersion()+1);
            devAccessDao.insert(devAccessDo);

            DevAccessMeasureDo devAccessMeasureDoOld=devAccessMeasureDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
            DevAccessMeasureDo devAccessMeasureDo=new DevAccessMeasureDo();
            devAccessMeasureDo.setId(id);
            devAccessMeasureDo.setMeasCommMode("RS485");
            devAccessMeasureDo.setMeasCommAddr(devMeterNo);
            devAccessMeasureDo.setMeasCommProto("MODBUS-RTU");
            devAccessMeasureDo.setEnableElec(true);
            devAccessMeasureDo.setVersion(devAccessMeasureDoOld.getVersion()+1);
            devAccessMeasureDao.insert(devAccessMeasureDo);

            RunMeasPointDo runMeasPointDo=new RunMeasPointDo();
            runMeasPointDo.setId(iotDeviceIdGenerator.nextId());
            runMeasPointDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
            runMeasPointDo.setAccessMeasureId(id);
            runMeasPointDo.setAccessTrunkingId((long)0);
            runMeasPointDo.setAccessGatewayId(runMeasPointDoList.get(0).getAccessGatewayId());
            runMeasPointDo.setMeasKind(0);
            runMeasPointDo.setMeasSn(0);
            runMeasPointDo.setMeasCommMode("RS485");
            runMeasPointDo.setMeasCommAddr(devMeterNo);
            runMeasPointDo.setMeasCommProto("MODBUS-RTU");
            runMeasPointDo.setMeasCommPort(0);
            runMeasPointDo.setGmtMessageUp(now);
            runMeasPointDo.setGmtMeasdataUp(now);
            runMeasPointDo.setGmtAlarmUp(0);
            runMeasPointDo.setGmtCreate(now);
            runMeasPointDo.setGmtModified(now);
            runMeasPointDo.setVersion(runMeasPointDoList.get(0).getVersion()+1);
            runMeasPointDao.insert(runMeasPointDo);

            //插入日志表
            RunMeasPointChangeLogDo runMeasPointChangeLogDo=new RunMeasPointChangeLogDo();
            BeanUtils.copyProperties(runMeasPointDo,runMeasPointChangeLogDo);
            runMeasPointChangeLogDo.setSn(devTermNo);
            runMeasPointDao.insertRunMeasPointLog(runMeasPointChangeLogDo);

            logger.info("终端地址： " + devTermNo + " 三张表刷新成功");
//            RunAccessGatewayRunStatusUpdateResponse flag = brushMeter(devTermNo, devMeterNo);
            brushMeterResponse.setRunMeasPointId(runMeasPointDo.getId());
            brushMeterResponse.setAccessMeasureId(runMeasPointDo.getAccessMeasureId());
            logger.info("装接成功返回=============>"+JSONObject.toJSONString(brushMeterResponse));
            return brushMeterResponse;
        }
        brushMeterResponse.setRunMeasPointId(measCommAddrList.get(0).getId());
        brushMeterResponse.setAccessMeasureId(measCommAddrList.get(0).getAccessMeasureId());
        logger.info("装接成功返回=============>"+JSONObject.toJSONString(brushMeterResponse));
        return brushMeterResponse;
    }

    @Override
    public void delTermMeter(Long runMeasPointId) {
        logger.info("删除表计：" + runMeasPointId);
        if (runMeasPointId==0){
            return;
        }
        RunMeasPointDo runMeasPointDo = runMeasPointDao.get(runMeasPointId);

        DevAccessDo devAccessDo=new DevAccessDo();
        devAccessDo.setId(runMeasPointDo.getAccessMeasureId());
        devAccessDao.delete(devAccessDo);

        DevAccessMeasureDo devAccessMeasureDo=new DevAccessMeasureDo();
        devAccessMeasureDo.setId(runMeasPointDo.getAccessMeasureId());
        devAccessMeasureDao.delete(devAccessMeasureDo);

        runMeasPointDao.delete(runMeasPointDo);
    }

    @Override
    public void editMeter(EditMeterRequest editMeterRequest) {
        logger.info("修改表计信息：" + JSONObject.toJSONString(editMeterRequest));
        //历史老数据获取
        Long runMeasPointId = editMeterRequest.getRunMeasPointId();
        RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(runMeasPointId);
        if (runMeasPointVo==null){
            return ;
        }
        Long accessMeasureId = runMeasPointVo.getAccessMeasureId();
        DevAccessDo devAccessDoOld = devAccessDao.get(accessMeasureId);
        DevAccessMeasureDo oldDevAccessMeasureDo = devAccessMeasureDao.get(accessMeasureId);
        Map<String, Object> newEntityMap = Maps.newLinkedHashMap();
        DevAccessDo newDevAccessDo = null;
        DevAccessMeasureDo newDevAccessMeasureDo = null;
        try {
            newDevAccessDo = (DevAccessDo) com.easesource.commons.util.BeanUtils.cloneBean(devAccessDoOld);
            newDevAccessMeasureDo = (DevAccessMeasureDo) com.easesource.commons.util.BeanUtils.cloneBean(oldDevAccessMeasureDo);
        }
        catch(IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }

        //编辑的值
        String orgNo= editMeterRequest.getOrgNo();
        String measCommAddrTerm = runMeasPointVo.getUpcommLogicAddr();
        String measCommAddr=editMeterRequest.getMeasCommAddr();
        String measCommMode = editMeterRequest.getMeasCommMode();
        String measCommProto = editMeterRequest.getMeasCommProto();

        if(newDevAccessDo != null) {
            if (StringUtils.isNotBlank(orgNo)) {
                newDevAccessDo.setOrgNo(orgNo);
            }
            if (StringUtils.isNotBlank(measCommAddr)) {
                newDevAccessDo.setDevAccessNo(measCommAddrTerm + "-" + measCommAddr);
                newDevAccessDo.setDevAccessName(measCommAddr);
                newDevAccessDo.setDevAccessDesc(measCommAddr);
            }
            newDevAccessDo.setGmtModified(System.currentTimeMillis());
            newDevAccessDo.setVersion(newDevAccessDo.getSortSn() + 1);
            devAccessDao.update(newDevAccessDo);
            newEntityMap.put("devAccess", newDevAccessDo);
        }
        if (newDevAccessMeasureDo!=null){
            if (StringUtils.isNotBlank(measCommAddr)) {
                newDevAccessMeasureDo.setMeasCommAddr(measCommAddr);
            }

            if(StringUtils.isNotBlank(measCommMode)) {
                newDevAccessMeasureDo.setMeasCommMode(measCommMode);
            }
            if(StringUtils.isNotBlank(measCommProto)) {
                newDevAccessMeasureDo.setMeasCommProto(measCommProto);
            }
            devAccessMeasureDao.update(newDevAccessMeasureDo);
            newEntityMap.put("devAccessMeasure", newDevAccessMeasureDo);
        }
        Map<String, Object> oldEntityMap = Maps.newLinkedHashMap();
        oldEntityMap.put("devAccess", devAccessDoOld);
        oldEntityMap.put("devAccessMeasure", oldDevAccessMeasureDo);

        LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
        logDevAccessEntity.setId(iotDeviceIdGenerator.nextId());
        logDevAccessEntity.setLogType(4);
        logDevAccessEntity.setDevAccessId(accessMeasureId);
        logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString(oldEntityMap, PropertyNamingStrategy.SNAKE_CASE));
        logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString(newEntityMap, PropertyNamingStrategy.SNAKE_CASE));
        logDevAccessEntity.setAlterPathway("PC_WEBAPP");
        logDevAccessEntity.setAlterOper("editMeterAdmin");
        logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
        logDevAccessEntityDao.insertLog(logDevAccessEntity);

        runMeasPointDao.editMeter(editMeterRequest);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RunMeasPointListResponse sync(List<SyncRequest> syncRequests) {
        RunMeasPointListResponse runMeasPointListResponse=new RunMeasPointListResponse();
        List<RunMeasPointVo> runMeasPointList=new ArrayList<>();
        for (SyncRequest syncRequest:syncRequests){
            RunMeasPointVo runMeasPointVo=runMeasPointDao.selectByGatewayIdMeterNo(syncRequest.getDevMeterNo(),syncRequest.getAccessGatewayId());
            if (runMeasPointVo!=null){
                //不为空 档案已经上来 判断规约和量测点标识是否一致 不一致则更新
                if (runMeasPointVo.getMeasSn()!=syncRequest.getMeasSn()||!runMeasPointVo.getMeasCommProto().equals(syncRequest.getMeasCommProto())){
                    RunMeasPointDo runMeasPointDo=new RunMeasPointDo();
                    runMeasPointDo.setId(runMeasPointVo.getId());
                    runMeasPointDo.setMeasSn(syncRequest.getMeasSn());
                    runMeasPointDo.setMeasCommProto(syncRequest.getMeasCommProto());
                    runMeasPointDao.update(runMeasPointDo);
                    runMeasPointVo.setMeasSn(syncRequest.getMeasSn());
                    runMeasPointVo.setMeasCommProto(syncRequest.getMeasCommProto());
                }
                runMeasPointList.add(runMeasPointVo);
                continue;
            }
            //为空 插入三张表刷新
            long now = System.currentTimeMillis();
            long id =iotDeviceIdGenerator.nextId();
            String mac=syncRequest.getDevTermNo();
            String key=syncRequest.getDevMeterNo();
            String orgNo=syncRequest.getOrgNo();

            DevAccessDo devAccessDo=new DevAccessDo();
            devAccessDo.setId(id);
            devAccessDo.setOrgNo(orgNo);
            devAccessDo.setDevAccessSortNo("HEPSTD-PV-METER");
            devAccessDo.setDevAccessNo(mac+"-"+key);
            devAccessDo.setDevAccessName(key);
            devAccessDo.setDevAccessDesc(key);
            devAccessDo.setDevAccessDetail("{}");
            devAccessDo.setGateway(false);
            devAccessDo.setTrunking(false);
            devAccessDo.setMeasure(true);
            devAccessDo.setLifeState("03");
            devAccessDo.setMfrCode("HEPSTD");
            devAccessDo.setModelCode("HEPSTD-PV-INVERTER");
            devAccessDo.setSortSn(1);
            devAccessDo.setValid(true);
            devAccessDo.setGmtCreate(now);
            devAccessDo.setGmtModified(now);
            devAccessDo.setGmtInvalid(0);
            devAccessDo.setVersion(1);
            devAccessDao.insert(devAccessDo);


            DevAccessMeasureDo devAccessMeasureDo=new DevAccessMeasureDo();
            devAccessMeasureDo.setId(id);
            devAccessMeasureDo.setMeasCommMode("RS485");
            devAccessMeasureDo.setMeasCommAddr(key);
            devAccessMeasureDo.setMeasCommProto(syncRequest.getMeasCommProto());
            devAccessMeasureDo.setEnableElec(true);
            devAccessMeasureDo.setVersion(1);
            devAccessMeasureDao.insert(devAccessMeasureDo);

            RunMeasPointDo runMeasPointDo=new RunMeasPointDo();
            runMeasPointDo.setId(iotDeviceIdGenerator.nextId());
            runMeasPointDo.setOrgNo(orgNo);
            runMeasPointDo.setAccessMeasureId(id);
            runMeasPointDo.setAccessTrunkingId((long)0);
            runMeasPointDo.setAccessGatewayId(syncRequest.getAccessGatewayId());
            runMeasPointDo.setMeasKind(0);
            runMeasPointDo.setMeasSn(syncRequest.getMeasSn());
            runMeasPointDo.setMeasCommMode("RS485");
            runMeasPointDo.setMeasCommAddr(key);
            runMeasPointDo.setMeasCommProto(syncRequest.getMeasCommProto());
            runMeasPointDo.setMeasCommPort(0);
            runMeasPointDo.setGmtMessageUp(now);
            runMeasPointDo.setGmtMeasdataUp(now);
            runMeasPointDo.setGmtAlarmUp(0);
            runMeasPointDo.setGmtCreate(now);
            runMeasPointDo.setGmtModified(now);
            runMeasPointDo.setVersion(1);
            runMeasPointDao.insert(runMeasPointDo);
            BeanUtils.copyProperties(runMeasPointDo,runMeasPointVo);
            runMeasPointList.add(runMeasPointVo);
        }
        runMeasPointListResponse.setRunMeasPointList(runMeasPointList);
        runMeasPointListResponse.setReturnCode("SUCCESS");
        return runMeasPointListResponse;
    }
}
