package com.easesource.iot.datacenter.openservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.RegExUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.DevAccessRegisterService;
import com.easesource.iot.datacenter.openservice.constant.DevLifeStateEnum;
import com.easesource.iot.datacenter.openservice.constant.DevRunStatusEnum;
import com.easesource.iot.datacenter.openservice.constant.UpcommTypeEnum;
import com.easesource.iot.datacenter.openservice.dao.*;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "devAccessRegisterService")
public class DevAccessRegisterServiceImpl extends AbstractBaseService implements DevAccessRegisterService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private DevAccessDao devAccessDao;

    @Resource
    private DevAccessGatewayDao devAccessGatewayDao;

    @Resource
    private DevAccessTrunkingDao devAccessTrunkingDao;

    @Resource
    private DevAccessMeasureDao devAccessMeasureDao;

    @Resource
    private RunAccessGatewayDao runAccessGatewayDao;

    @Resource
    private RunMeasPointDao runMeasPointDao;

    @Resource
    private LogDevAccessEntityDao logDevAccessEntityDao;

    @Override
    public RegisteredDevAccessGatewayGetResponse getRegisteredDevAccessGateway(RegisteredDevAccessGatewayGetRequest getRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRegisteredDevAccessGateway >>>>>>> ");
            logger.debug(" RegisteredDevAccessGatewayGetRequest         : " + JsonConvertUtils.convertToString(getRequest));
        }
        RegisteredDevAccessGatewayGetResponse getResponse = new RegisteredDevAccessGatewayGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");

        if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr())) {
            DevAccessGatewayVo devAccessGatewayVo = devAccessGatewayDao.getDevAccessGatewayVoByUpcommProtoAndUpcommLogicAddr(getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setDevAccessGateway(devAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RegisteredDevAccessGatewayGetResponse        : " + JsonConvertUtils.convertToString(getResponse));
            logger.debug(" <<<<<<<< end getRegisteredDevAccessGateway <<<<<<<< ");
        }

        return getResponse;
    }

    @Override
    public NewDevAccessGatewayRegisterResponse registerNewDevAccessGateway(NewDevAccessGatewayRegisterRequest registerRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start registerNewDevAccessGateway >>>>>>> ");
            logger.debug(" NewDevAccessGatewayRegisterRequest           : " + JsonConvertUtils.convertToString(registerRequest));
        }
        NewDevAccessGatewayRegisterResponse registerResponse = new NewDevAccessGatewayRegisterResponse();
        registerResponse.setReturnCode("FAILURE");
        registerResponse.setFailureCode("-1");

        if(registerRequest != null && registerRequest.getDevAccessGatewayParent() != null) {
            Long devAccessGatewayParentId = iotDeviceIdGenerator.nextId();
            DevAccessDo devAccessGatewayParent = registerRequest.getDevAccessGatewayParent();
            devAccessGatewayParent.setId(devAccessGatewayParentId);
            DevAccessGatewayDo devAccessGatewayDo = registerRequest.getDevAccessGatewayDo();
            devAccessGatewayDo.setId(devAccessGatewayParentId);
            RunAccessGatewayDo runAccessGatewayDo = registerRequest.getRunAccessGatewayDo();
            runAccessGatewayDo.setId(devAccessGatewayParentId);
            int measPointCount = runAccessGatewayDo.getMeasPointCount();
            devAccessDao.insert(devAccessGatewayParent);
            devAccessGatewayDao.insert(devAccessGatewayDo);
            runAccessGatewayDao.insert(runAccessGatewayDo);
            if (devAccessGatewayParent.getDevAccessSortNo().contains("SZ")){
                DevAccessMeasureDo devAccessMeasureDo=new DevAccessMeasureDo();
                devAccessMeasureDo.setId(devAccessGatewayParent.getId());
                devAccessMeasureDo.setMeasCommMode("ACSAMP");
                devAccessMeasureDo.setMeasCommProto("TCP_SZ");
                devAccessMeasureDo.setMeasCommAddr(devAccessGatewayParent.getDevAccessNo());
                devAccessMeasureDo.setEnableElec(true);
                devAccessMeasureDo.setEnableWater(false);
                devAccessMeasureDo.setEnableGas(false);
                devAccessMeasureDo.setEnableHeat(false);
                devAccessMeasureDo.setVersion(1);
                devAccessMeasureDao.insert(devAccessMeasureDo);
                RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
                runMeasPointDo.setId(devAccessGatewayParentId);
                runMeasPointDo.setOrgNo(devAccessGatewayParent.getOrgNo());
                runMeasPointDo.setAccessGatewayId(devAccessGatewayParentId);
                runMeasPointDo.setAccessTrunkingId(0L);
                runMeasPointDo.setAccessMeasureId(devAccessGatewayParent.getId());
                runMeasPointDo.setMeasKind(1);
                runMeasPointDo.setMeasSn(0);
                runMeasPointDo.setMeasCommMode("ACSAMP");
                runMeasPointDo.setMeasCommProto("TCP_SZ");
                runMeasPointDo.setMeasCommAddr(devAccessGatewayParent.getDevAccessNo());
                runMeasPointDo.setMeasCommPort(1);
                runMeasPointDo.setGmtMessageUp(System.currentTimeMillis());
                runMeasPointDo.setGmtMeasdataUp(System.currentTimeMillis());
                runMeasPointDo.setGmtAlarmUp(System.currentTimeMillis());
                runMeasPointDo.setGmtCreate(System.currentTimeMillis());
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDo.setVersion(1);
                runMeasPointDao.insert(runMeasPointDo);
            }

            List<DevAccessDo> devAccessMeasureParentList = registerRequest.getDevAccessMeasureParentList();
            List<DevAccessMeasureDo> devAccessMeasureDoList = registerRequest.getDevAccessMeasureDoList();
            for(int i = 0; i < measPointCount; i++) {
                Long devAccessMeasureParentId = iotDeviceIdGenerator.nextId();
                DevAccessDo devAccessMeasureParent = devAccessMeasureParentList.get(i);
                devAccessMeasureParent.setId(devAccessMeasureParentId);
                DevAccessMeasureDo devAccessMeasureDo = devAccessMeasureDoList.get(i);
                devAccessMeasureDo.setId(devAccessMeasureParentId);
                devAccessDao.insert(devAccessMeasureParent);
                devAccessMeasureDao.insert(devAccessMeasureDo);
                RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
                runMeasPointDo.setId(iotDeviceIdGenerator.nextId());
                runMeasPointDo.setOrgNo(devAccessMeasureParent.getOrgNo());
                runMeasPointDo.setAccessGatewayId(devAccessGatewayParentId);
                runMeasPointDo.setAccessTrunkingId(0L);
                runMeasPointDo.setAccessMeasureId(devAccessMeasureParentId);
                runMeasPointDo.setMeasKind(1);
                runMeasPointDo.setMeasSn(devAccessMeasureParent.getDevAccessSortNo().contains("SZ")?0:Integer.parseInt(devAccessMeasureDo.getMeasCommAddr()));
                runMeasPointDo.setMeasCommMode(devAccessMeasureDo.getMeasCommMode());
                runMeasPointDo.setMeasCommProto(devAccessMeasureDo.getMeasCommProto());
                runMeasPointDo.setMeasCommAddr(devAccessMeasureDo.getMeasCommAddr());
                runMeasPointDo.setMeasCommPort(1);
                runMeasPointDo.setGmtMessageUp(System.currentTimeMillis());
                runMeasPointDo.setGmtMeasdataUp(System.currentTimeMillis());
                runMeasPointDo.setGmtAlarmUp(System.currentTimeMillis());
                runMeasPointDo.setGmtCreate(System.currentTimeMillis());
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDo.setVersion(1);
                runMeasPointDao.insert(runMeasPointDo);
            }
            registerResponse.setReturnCode("SUCCESS");
            registerResponse.setFailureCode(null);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" NewDevAccessGatewayRegisterResponse          : " + JsonConvertUtils.convertToString(registerResponse));
            logger.debug(" <<<<<<<< end registerNewDevAccessGateway <<<<<<<< ");
        }
        return registerResponse;
    }

    @Override
    public GmDevTermCancelResponse cancelGmDevTerm(GmDevTermCancelRequest cancelRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start cancelGmDevTerm >>>>>>> ");
            logger.debug(" GmDevTermCancelRequest       : " + JsonConvertUtils.convertToString(cancelRequest));
        }
        GmDevTermCancelResponse cancelResponse = new GmDevTermCancelResponse();
        cancelResponse.setReturnCode("FAILURE");
        cancelResponse.setFailureCode("-1");

        if(cancelRequest != null) {
            Long accessGatewayId = cancelRequest.getAccessGatewayId();
            AtomicReference<Long> acsampMeasPointIdRef = new AtomicReference<>(0L);
            if(!(accessGatewayId != null && accessGatewayId > 0L)) {
                cancelResponse.setReturnCode("FAILURE");
                cancelResponse.setFailureCode("10000006");
                cancelResponse.setFailureMsg("传入的接入网关设备标识非法");
                return cancelResponse;
            }

            DevAccessDo devAccessDo = devAccessDao.get(accessGatewayId);
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(accessGatewayId);
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(accessGatewayId);
            if(CollectionUtils.isNotEmpty(runMeasPointList)) {
                boolean hasAllAcsampRunMeasPointList = runMeasPointList.stream().allMatch(t -> StringUtils.equals(t.getMeasCommMode(), "ACSAMP"));
                if(!hasAllAcsampRunMeasPointList) {
                    cancelResponse.setReturnCode("FAILURE");
                    cancelResponse.setFailureCode("10000007");
                    cancelResponse.setFailureMsg("接入网关设备下有其他接入量测表计设备，请先拆除！");
                    return cancelResponse;
                }
            }

            /*if(devAccessDo == null) {
                cancelResponse.setReturnCode("FAILURE");
                cancelResponse.setFailureCode("10000120");
                cancelResponse.setFailureMsg("该采集终端编号不存在，无法删除");
            }
            if(runAccessGatewayVo == null) {
                cancelResponse.setReturnCode("FAILURE");
                cancelResponse.setFailureCode("10000121");
                cancelResponse.setFailureMsg("该采集终端通讯地址不存在，无法删除");
            }*/
            if(devAccessDo != null && runAccessGatewayVo != null && !devAccessDo.getId().equals(runAccessGatewayVo.getId())) {
                cancelResponse.setReturnCode("FAILURE");
                cancelResponse.setFailureCode("10000122");
                cancelResponse.setFailureMsg("接入网关设备和接入网关设备运行工况实体不一致，无法删除");
                return cancelResponse;
            }
            if(devAccessDo != null) {
                Map<String, Object> oldEntityMap = Maps.newLinkedHashMap();
                oldEntityMap.put("devAccess", devAccessDo);
                DevAccessGatewayDo devAccessGatewayDo = devAccessGatewayDao.get(accessGatewayId);
                if(devAccessGatewayDo != null) {
                    oldEntityMap.put("devAccessGateway", devAccessGatewayDo);
                    devAccessGatewayDao.delete(devAccessGatewayDo);
                }
                DevAccessTrunkingDo devAccessTrunkingDo = devAccessTrunkingDao.get(accessGatewayId);
                if(devAccessTrunkingDo != null) {
                    oldEntityMap.put("devAccessTrunking", devAccessTrunkingDo);
                    devAccessTrunkingDao.delete(devAccessTrunkingDo);
                }
                DevAccessMeasureDo devAccessMeasureDo = devAccessMeasureDao.get(accessGatewayId);
                if(devAccessMeasureDo != null) {
                    oldEntityMap.put("devAccessMeasure", devAccessMeasureDo);
                    devAccessMeasureDao.delete(devAccessMeasureDo);
                }
                devAccessDao.delete(devAccessDo);

                // logDevAccessEntityDao
                LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
                logDevAccessEntity.setId(iotDeviceIdGenerator.nextId());
                logDevAccessEntity.setLogType(3);
                logDevAccessEntity.setDevAccessId(accessGatewayId);
                logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString(oldEntityMap, PropertyNamingStrategy.SNAKE_CASE));
                logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString(Maps.newLinkedHashMap()));
                logDevAccessEntity.setAlterPathway(StringUtils.defaultIfBlank(cancelRequest.getPathway(), "PC_WEBAPP"));
                logDevAccessEntity.setAlterOper(StringUtils.defaultIfBlank(cancelRequest.getOperator(), "$UNKNOWN^"));
                logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
                logDevAccessEntityDao.insertLog(logDevAccessEntity);
            }
            if(runAccessGatewayVo != null) {
                runAccessGatewayDao.deleteById(runAccessGatewayVo.getId());
            }
            if(CollectionUtils.isNotEmpty(runMeasPointList)) {
                runMeasPointList.forEach(t -> {
                    acsampMeasPointIdRef.set(t.getId());
                    runMeasPointDao.deleteById(t.getId());
                });
            }

            cancelResponse.setReturnCode("SUCCESS");
            cancelResponse.setFailureCode(null);
            cancelResponse.setAccessGatewayId(accessGatewayId);
            cancelResponse.setAcsampMeasPointId(acsampMeasPointIdRef.get());
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" GmDevTermCancelResponse      : " + JsonConvertUtils.convertToString(cancelResponse));
            logger.debug(" <<<<<<<< end cancelGmDevTerm <<<<<<<< ");
        }
        return cancelResponse;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public GmDevTermModifyResponse modifyGmDevTerm(GmDevTermModifyRequest modifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start modifyGmDevTerm >>>>>>> ");
            logger.debug(" GmDevTermModifyRequest       : " + JsonConvertUtils.convertToString(modifyRequest));
        }
        logger.info("编辑终端>>>>>>>>>>>>>>>>>>>>>>"+JSONObject.toJSONString(modifyRequest));
        GmDevTermModifyResponse modifyResponse = new GmDevTermModifyResponse();
        modifyResponse.setReturnCode("FAILURE");
        modifyResponse.setFailureCode("-1");

        if(modifyRequest != null) {
            Long accessGatewayId = modifyRequest.getAccessGatewayId();
            if(!(accessGatewayId != null && accessGatewayId > 0L)) {
                modifyResponse.setReturnCode("FAILURE");
                modifyResponse.setFailureCode("10000006");
                modifyResponse.setFailureMsg("传入的接入网关设备标识非法");
                return modifyResponse;
            }

            DevAccessDo oldDevAccessDo = devAccessDao.get(accessGatewayId);
            RunAccessGatewayVo oldRunAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(accessGatewayId);
            List<RunMeasPointVo> oldRunMeasPointList = runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(accessGatewayId);
            if(oldDevAccessDo == null) {
                modifyResponse.setReturnCode("FAILURE");
                modifyResponse.setFailureCode("10000008");
                modifyResponse.setFailureMsg("接入网关设备不存在");
                return modifyResponse;
            }

            Map<String, Object> oldEntityMap = Maps.newLinkedHashMap();
            oldEntityMap.put("devAccess", oldDevAccessDo);
            DevAccessGatewayDo oldDevAccessGatewayDo = devAccessGatewayDao.get(accessGatewayId);
            if(oldDevAccessGatewayDo != null) {
                oldEntityMap.put("devAccessGateway", oldDevAccessGatewayDo);
            }
            DevAccessTrunkingDo oldDevAccessTrunkingDo = devAccessTrunkingDao.get(accessGatewayId);
            if(oldDevAccessTrunkingDo != null) {
                oldEntityMap.put("devAccessTrunking", oldDevAccessTrunkingDo);
            }
            DevAccessMeasureDo oldDevAccessMeasureDo = devAccessMeasureDao.get(accessGatewayId);
            if(oldDevAccessMeasureDo != null) {
                oldEntityMap.put("devAccessMeasure", oldDevAccessMeasureDo);
            }

            // 变更后
            String orgNo = StringUtils.trim(modifyRequest.getOrgNo());
            String devTermNo = StringUtils.trim(modifyRequest.getDevTermNo());
            String devTermName = StringUtils.trim(modifyRequest.getDevTermName());
            String devTermCommProto = StringUtils.trim(modifyRequest.getDevTermCommProto());
            String devTermCommProtoVer = StringUtils.trim(modifyRequest.getDevTermCommProtoVer());
            Integer devTermCommMode = modifyRequest.getDevTermCommMode();
            String devTermCommAddr = StringUtils.trim(modifyRequest.getDevTermCommAddr());
            String devTermCommParam = StringUtils.trim(modifyRequest.getDevTermCommParam());
            String productKey = StringUtils.trim(modifyRequest.getProductKey());
            String devAccessSortNo = null;
            String upcommProto = null;
            String upcommProtoVer = null;
            String upcommLogicAddr = devTermCommAddr;
            int upcommType = 0;
            String upcommParam = devTermCommParam;
            Boolean encrypt = modifyRequest.getEncrypt();
            String encryptType = StringUtils.trim(modifyRequest.getEncryptType());
            String encryptInfo = StringUtils.trim(modifyRequest.getEncryptInfo());
            String acsampMeasCommMode = "ACSAMP";
            String acsampMeasCommProto = null;
            String acsampMeasCommAddr = null;
            if(StringUtils.isNotBlank(devTermCommProto) && devTermCommMode != null) {
                if(StringUtils.equals(devTermCommProto, "GAEADCU")) {
                    devAccessSortNo = "GAEADCU";
                    if(devTermCommMode == 1) {
                        upcommProto = "TCP_GAEADCU";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    }
                    else if(devTermCommMode == 2) {
                        upcommProto = "UDP_GAEADCU";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "V4");
                    productKey = "GAEA_DCU_V4";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;

                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 8)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为8位16进制字符串");
                        return modifyResponse;
                    }
                }
                else if(StringUtils.equals(devTermCommProto, "DLT698_45")) {
                    devAccessSortNo = "DLT698_45";
                    if(devTermCommMode == 1) {
                        upcommProto = "TCP_DLT698_45";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    }
                    else if(devTermCommMode == 2) {
                        upcommProto = "UDP_DLT698_45";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "2017");
                    productKey = "DLT698_45_2017";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;

                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                        return modifyResponse;
                    }
                }
                else if(StringUtils.equals(devTermCommProto, "DLT698_45_WITH_1867")) {
                    devAccessSortNo = "DLT698_45_WITH_1867";
                    if(devTermCommMode == 1) {
                        upcommProto = "TCP_DLT698_45_WITH_1867";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    }
                    else if(devTermCommMode == 2) {
                        upcommProto = "UDP_DLT698_45_WITH_1867";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "2020");
                    productKey = "DLT698_45_WITH_1867_2017";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;

                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 8)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为8位16进制字符串");
                        return modifyResponse;
                    }
                }
                else if(StringUtils.equals(devTermCommProto, "QGDW1376_1")) {
                    devAccessSortNo = "QGDW1376_1";
                    if(devTermCommMode == 1) {
                        upcommProto = "TCP_QGDW1376_1";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    }
                    else if(devTermCommMode == 2) {
                        upcommProto = "UDP_QGDW1376_1";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "2013");
                    productKey = "QGDW1376_1_2013";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;

                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 8)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为8位16进制字符串");
                        return modifyResponse;
                    }
                }
                else if(StringUtils.equals(devTermCommProto, "IEC104")) {
                    devAccessSortNo = "IEC104";
                    if(devTermCommMode == 1) {
                        upcommProto = "TCP_IEC104";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    }
                    else if(devTermCommMode == 2) {
                        upcommProto = "UDP_IEC104";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "STD");
                    productKey = "IEC_104_STD";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = StringUtils.leftPad(upcommLogicAddr, 10, '0') + "00";

                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 4)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为4位16进制字符串");
                        return modifyResponse;
                    }
                }
                else if(StringUtils.equals(devTermCommProto, "HUAYUN104")) {
                    devAccessSortNo = "HUAYUN104";
                    if(devTermCommMode == 1) {
                        upcommProto = "TCP_HUAYUN104";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    }
                    else if(devTermCommMode == 2) {
                        upcommProto = "UDP_HUAYUN104";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "");
                    productKey = "HUAYUN104";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;

                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                        return modifyResponse;
                    }
                }
                else if(StringUtils.equals(devTermCommProto, "MQTT_JALASMART")) {
                    devAccessSortNo = "JALASMART_GATEWAY";
                    if(devTermCommMode == 1) {
                        upcommProto = "MQTT_JALASMART";
                        upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    }
                    else {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("传入采集终端通讯方式不支持");
                        return modifyResponse;
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.6");
                    productKey = "b03b99VXEV1";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;

//                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 24)) {
//                        modifyResponse.setReturnCode("FAILURE");
//                        modifyResponse.setFailureCode("10000011");
//                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为24位16进制字符串");
//                        return modifyResponse;
//                    }
                }
                else if(StringUtils.equals(devTermCommProto, "MQTT_TIMUIOT")) {
                    devAccessSortNo = "TIMUIOT_GATEWAY";
                    if(devTermCommMode == 1) {
                        upcommProto = "MQTT_TIMUIOT";
                        upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    }
                    else {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("传入采集终端通讯方式不支持");
                        return modifyResponse;
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.28");
                    productKey = "YINDE";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;

                    if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                        return modifyResponse;
                    }
                }
                else if(StringUtils.equals(devTermCommProto, "MQTT_DINGIIOT")) {
                    devAccessSortNo = "DINGIIOT_GATEWAY";
                    if(devTermCommMode == 1) {
                        upcommProto = "MQTT_DINGIIOT";
                        upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    }
                    else {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("传入采集终端通讯方式不支持");
                        return modifyResponse;
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.2");
                    productKey = "dingiiot";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;

                    /*if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                        return modifyResponse;
                    }*/
                }
                else if(StringUtils.equals(devTermCommProto, "MQTT_IDCCIOT")) {
                    devAccessSortNo = "IDCCIOT_GATEWAY";
                    if(devTermCommMode == 1) {
                        upcommProto = "MQTT_IDCCIOT";
                        upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    }
                    else {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("传入采集终端通讯方式不支持");
                        return modifyResponse;
                    }
                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.2");
                    productKey = "IDCCIOT";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;

                    /*if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                        return modifyResponse;
                    }*/
                }
                else if(StringUtils.equals(devTermCommProto, "LWM2M_CTWING")) {
                    devAccessSortNo = "LWM2M_CTWING_GATEWAY";
                    /*if(devTermCommMode == 2) {
                        upcommProto = "LWM2M_CTWING_GATEWAY";
                        upcommType = UpcommTypeEnum.UDP_LWM2M.getType();
                    }
                    else {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("传入采集终端通讯方式不支持");
                        return modifyResponse;
                    }*/
                    //
                    upcommProto = "LWM2M_CTWING_GATEWAY";
                    upcommType = UpcommTypeEnum.UDP_LWM2M.getType();

                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.9.0");
                    productKey = "LWM2M_CTWING";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                }
                else if(StringUtils.equals(devTermCommProto, "WSAPI_SUNTRONT")) {
                    devAccessSortNo = "WSAPI_SUNTRONT_GATEWAY";
                    devTermCommMode = 2;
                    upcommProto = "WSAPI_SUNTRONT_GATEWAY";
                    upcommType = UpcommTypeEnum.UDP_LWM2M.getType();

                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.0");
                    productKey = "WSAPI_SUNTRONT";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                }
                else if(StringUtils.equals(devTermCommProto, "ENOSIOT_API_2")) {
                    devAccessSortNo = "ENOSIOT_API_2_GATEWAY";
                    devTermCommMode = 1;
                    upcommProto = "ENOSIOT_API_2_GATEWAY";
                    upcommType = UpcommTypeEnum.TCP_HTTP.getType();

                    upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "V2");
                    productKey = "ENOSIOT_API_2";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                }
                else {
                    modifyResponse.setReturnCode("FAILURE");
                    modifyResponse.setFailureCode("10000010");
                    modifyResponse.setFailureMsg("传入采集终端通讯规约不支持");
                    return modifyResponse;
                }
            }
            String devAccessNo = devTermNo;

            if(!StringUtils.equals(orgNo, oldDevAccessDo.getOrgNo())
                || !StringUtils.equals(devAccessSortNo, oldDevAccessDo.getDevAccessSortNo())
                || !StringUtils.equals(devAccessNo, oldDevAccessDo.getDevAccessNo())) {
                DevAccessDo devAccessDo = devAccessDao.getByOrgNoAndDevAccessSortNoAndDevAccessNo(orgNo, devAccessSortNo, devAccessNo);
                if(devAccessDo != null && devAccessDo.getId() > 0L) {
                    modifyResponse.setReturnCode("FAILURE");
                    modifyResponse.setFailureCode("10000020");
                    modifyResponse.setFailureMsg("该采集终端编号已存在");
                }
            }

            if(!StringUtils.equals(productKey, oldRunAccessGatewayVo.getProductKey())
                || !StringUtils.equals(upcommProto, oldRunAccessGatewayVo.getUpcommProto())
                || !StringUtils.equals(upcommLogicAddr, oldRunAccessGatewayVo.getUpcommLogicAddr())) {
                RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(productKey, upcommProto, upcommLogicAddr);
                if(runAccessGatewayVo != null && runAccessGatewayVo.getId() > 0L) {
                    modifyResponse.setReturnCode("FAILURE");
                    modifyResponse.setFailureCode("10000021");
                    modifyResponse.setFailureMsg("该采集终端通讯地址已存在");
                }
            }

            Map<String, Object> newEntityMap = Maps.newLinkedHashMap();
            DevAccessDo newDevAccessDo = null;
            try {
                newDevAccessDo = (DevAccessDo) BeanUtils.cloneBean(oldDevAccessDo);
            }
            catch(IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }

            if(newDevAccessDo != null) {
                if(StringUtils.isNotBlank(orgNo)) {
                    newDevAccessDo.setOrgNo(orgNo);
                }
                if(StringUtils.isNotBlank(devAccessSortNo)) {
                    newDevAccessDo.setDevAccessSortNo(devAccessSortNo);
                }
                if(StringUtils.isNotBlank(devAccessNo)) {
                    newDevAccessDo.setDevAccessNo(devAccessNo);
                }
                if(StringUtils.isNotBlank(devTermName)) {
                    newDevAccessDo.setDevAccessName(devTermName);
                    newDevAccessDo.setDevAccessDesc(devTermName);
                }
                if(StringUtils.isNotBlank(modifyRequest.getMfrCode())) {
                    newDevAccessDo.setMfrCode(StringUtils.trim(modifyRequest.getMfrCode()));
                }
                if(StringUtils.isNotBlank(modifyRequest.getModelCode())) {
                    newDevAccessDo.setModelCode(StringUtils.trim(modifyRequest.getModelCode()));
                }
                newDevAccessDo.setValid(true);
                newDevAccessDo.setGmtModified(System.currentTimeMillis());
                newDevAccessDo.setVersion(newDevAccessDo.getSortSn() + 1);
                devAccessDao.update(newDevAccessDo);
                newEntityMap.put("devAccess", newDevAccessDo);

                if(oldDevAccessGatewayDo != null) {
                    DevAccessGatewayDo newDevAccessGatewayDo = null;
                    try {
                        newDevAccessGatewayDo = (DevAccessGatewayDo) BeanUtils.cloneBean(oldDevAccessGatewayDo);
                    }
                    catch(IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
                        logger.error(e.getMessage(), e.fillInStackTrace());
                    }
                    if(newDevAccessGatewayDo != null) {
                        if(StringUtils.isNotBlank(upcommProto)) {
                            newDevAccessGatewayDo.setUpcommProto(upcommProto);
                        }
                        if(StringUtils.isNotBlank(upcommProtoVer)) {
                            newDevAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
                        }
                        if(StringUtils.isNotBlank(upcommLogicAddr)) {
                            newDevAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
                        }
                        if(upcommType > 0) {
                            newDevAccessGatewayDo.setUpcommType(upcommType);
                        }
                        if(StringUtils.isNotBlank(upcommParam)) {
                            newDevAccessGatewayDo.setUpcommParam(upcommParam);
                        }
                        if(encrypt != null) {
                            newDevAccessGatewayDo.setEncrypt(encrypt);
                        }
                        if(StringUtils.isNotBlank(encryptType)) {
                            newDevAccessGatewayDo.setEncryptType(encryptType);
                        }
                        if(StringUtils.isNotBlank(encryptInfo)) {
                            newDevAccessGatewayDo.setEncryptInfo(encryptInfo);
                        }
                        newDevAccessGatewayDo.setVersion(newDevAccessGatewayDo.getVersion() + 1);
                        devAccessGatewayDao.update(newDevAccessGatewayDo);
                        newEntityMap.put("devAccessGateway", newDevAccessGatewayDo);
                    }
                }

                if(oldDevAccessMeasureDo != null && StringUtils.isNotBlank(acsampMeasCommProto) && StringUtils.isNotBlank(acsampMeasCommAddr)) {
                    DevAccessMeasureDo newDevAccessMeasureDo = null;
                    try {
                        newDevAccessMeasureDo = (DevAccessMeasureDo) BeanUtils.cloneBean(oldDevAccessMeasureDo);
                    }
                    catch(IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
                        logger.error(e.getMessage(), e.fillInStackTrace());
                    }
                    if(newDevAccessMeasureDo != null) {
                        if(StringUtils.isNotBlank(acsampMeasCommMode)) {
                            newDevAccessMeasureDo.setMeasCommMode(acsampMeasCommMode);
                        }
                        if(StringUtils.isNotBlank(acsampMeasCommProto)) {
                            newDevAccessMeasureDo.setMeasCommProto(acsampMeasCommProto);
                        }
                        if(StringUtils.isNotBlank(acsampMeasCommAddr)) {
                            newDevAccessMeasureDo.setMeasCommAddr(acsampMeasCommAddr);
                        }
                        newDevAccessMeasureDo.setVersion(newDevAccessMeasureDo.getVersion() + 1);
                        devAccessMeasureDao.update(newDevAccessMeasureDo);
                        newEntityMap.put("devAccessMeasure", newDevAccessMeasureDo);
                    }
                }

                // logDevAccessEntityDao
                LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
                logDevAccessEntity.setId(iotDeviceIdGenerator.nextId());
                logDevAccessEntity.setLogType(2);
                logDevAccessEntity.setDevAccessId(accessGatewayId);
                logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString(oldEntityMap, PropertyNamingStrategy.SNAKE_CASE));
                logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString(newEntityMap, PropertyNamingStrategy.SNAKE_CASE));
                logDevAccessEntity.setAlterPathway(StringUtils.defaultIfBlank(modifyRequest.getPathway(), "PC_WEBAPP"));
                logDevAccessEntity.setAlterOper(StringUtils.defaultIfBlank(modifyRequest.getOperator(), "$UNKNOWN^"));
                logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
                logDevAccessEntityDao.insertLog(logDevAccessEntity);
            }

            RunAccessGatewayDo newRunAccessGatewayDo = null;
            try {
                newRunAccessGatewayDo = new RunAccessGatewayDo();
                BeanUtils.copyProperties(newRunAccessGatewayDo, oldRunAccessGatewayVo);
            }
            catch(IllegalAccessException | InvocationTargetException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }

            if(newRunAccessGatewayDo.getId() > 0L) {
                if(StringUtils.isNotBlank(orgNo)) {
                    newRunAccessGatewayDo.setOrgNo(orgNo);
                }
                if(StringUtils.isNotBlank(productKey)) {
                    newRunAccessGatewayDo.setProductKey(productKey);
                }
                if(StringUtils.isNotBlank(devAccessNo)) {
                    newRunAccessGatewayDo.setClientId(devAccessNo);
                }
                if(StringUtils.isNotBlank(upcommProto)) {
                    newRunAccessGatewayDo.setUpcommProto(upcommProto);
                }
                if(StringUtils.isNotBlank(upcommProtoVer)) {
                    newRunAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
                }
                if(StringUtils.isNotBlank(upcommLogicAddr)) {
                    newRunAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
                }
                if(upcommType > 0) {
                    newRunAccessGatewayDo.setUpcommType(upcommType);
                }
                if(StringUtils.isNotBlank(upcommParam)) {
                    newRunAccessGatewayDo.setUpcommParam(upcommParam);
                }
                if(encrypt != null) {
                    newRunAccessGatewayDo.setEncrypt(encrypt);
                }
                if(StringUtils.isNotBlank(encryptType)) {
                    newRunAccessGatewayDo.setEncryptType(encryptType);
                }
                if(StringUtils.isNotBlank(encryptInfo)) {
                    newRunAccessGatewayDo.setEncryptInfo(encryptInfo);
                }
                newRunAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                newRunAccessGatewayDo.setVersion(newRunAccessGatewayDo.getVersion() + 1);
                runAccessGatewayDao.update(newRunAccessGatewayDo);
            }

            Long acsampMeasPointId = null;
            if(CollectionUtils.isNotEmpty(oldRunMeasPointList)) {
                for(RunMeasPointVo oldRunMeasPointVo : oldRunMeasPointList) {
                    if (!"ACSAMP".equals(oldRunMeasPointVo.getMeasCommMode())){
                        continue;
                    }
                    RunMeasPointDo newRunMeasPointDo = null;
                    try {
                        newRunMeasPointDo = new RunMeasPointDo();
                        BeanUtils.copyProperties(newRunMeasPointDo, oldRunMeasPointVo);
                    }
                    catch(IllegalAccessException | InvocationTargetException e) {
                        logger.error(e.getMessage(), e.fillInStackTrace());
                    }
                    if(newRunMeasPointDo.getId() > 0L) {
                        acsampMeasPointId = newRunMeasPointDo.getId();
                        if(StringUtils.isNotBlank(orgNo)) {
                            newRunMeasPointDo.setOrgNo(orgNo);
                        }
                        if(StringUtils.isNotBlank(acsampMeasCommMode)) {
                            newRunMeasPointDo.setMeasCommMode(acsampMeasCommMode);
                        }
                        if(StringUtils.isNotBlank(acsampMeasCommProto)) {
                            newRunMeasPointDo.setMeasCommProto(acsampMeasCommProto);
                        }
                        if(StringUtils.isNotBlank(acsampMeasCommAddr)) {
                            newRunMeasPointDo.setMeasCommAddr(acsampMeasCommAddr);
                        }
                        newRunMeasPointDo.setGmtModified(System.currentTimeMillis());
                        newRunMeasPointDo.setVersion(newRunMeasPointDo.getVersion() + 1);
                        runMeasPointDao.update(newRunMeasPointDo);
                    }
                }
            }

            modifyResponse.setReturnCode("SUCCESS");
            modifyResponse.setFailureCode(null);
            modifyResponse.setAccessGatewayId(accessGatewayId);
            modifyResponse.setAcsampMeasPointId(acsampMeasPointId);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" GmDevTermModifyResponse      : " + JsonConvertUtils.convertToString(modifyResponse));
            logger.debug(" <<<<<<<< end modifyGmDevTerm <<<<<<<< ");
        }
        return modifyResponse;
    }

    @Override
    public GmDevTermRegisterResponse registerGmDevTerm(GmDevTermRegisterRequest registerRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start registerGmDevTerm >>>>>>> ");
            logger.debug(" GmDevTermRegisterRequest     : " + JsonConvertUtils.convertToString(registerRequest));
        }
        GmDevTermRegisterResponse registerResponse = new GmDevTermRegisterResponse();
        registerResponse.setReturnCode("FAILURE");
        registerResponse.setFailureCode("-1");

        if(registerRequest != null) {
            if(StringUtils.isBlank(registerRequest.getOrgNo())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000000");
                registerResponse.setFailureMsg("传入单位编号为空");
                return registerResponse;
            }
            if(StringUtils.isBlank(registerRequest.getDevTermNo())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000001");
                registerResponse.setFailureMsg("传入采集终端编号为空");
                return registerResponse;
            }
            if(StringUtils.isBlank(registerRequest.getDevTermName())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000002");
                registerResponse.setFailureMsg("传入采集终端名称为空");
                return registerResponse;
            }
            if(StringUtils.isBlank(registerRequest.getDevTermCommProto())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000003");
                registerResponse.setFailureMsg("传入采集终端通讯规约为空");
                return registerResponse;
            }
            if(StringUtils.isBlank(registerRequest.getDevTermCommAddr())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000004");
                registerResponse.setFailureMsg("传入采集终端通讯地址为空");
                return registerResponse;
            }
            if(registerRequest.getDevTermCommMode() != 1) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000005");
                registerResponse.setFailureMsg("传入采集终端通讯方式非法");
                return registerResponse;
            }
            String orgNo = StringUtils.trim(registerRequest.getOrgNo());
            String devTermNo = StringUtils.trim(registerRequest.getDevTermNo());
            String devTermName = StringUtils.trim(registerRequest.getDevTermName());
            String devTermCommProto = StringUtils.trim(registerRequest.getDevTermCommProto());
            String devTermCommProtoVer = StringUtils.trim(registerRequest.getDevTermCommProtoVer());
            Integer devTermCommMode = registerRequest.getDevTermCommMode();
            String devTermCommAddr = StringUtils.trim(registerRequest.getDevTermCommAddr());
            String productKey = StringUtils.trim(registerRequest.getProductKey());
            String devAccessSortNo = null;
            boolean gateway = true;
            boolean trunking = false;
            boolean measure = true;
            String upcommProto = null;
            String upcommProtoVer = null;
            String upcommLogicAddr = devTermCommAddr;
            int upcommType = 0;
            String upcommParam = "{}";
            boolean encrypt = false;
            String encryptType = "";
            String encryptInfo = "{}";
            String acsampMeasCommMode = "ACSAMP";
            String acsampMeasCommProto = null;
            String acsampMeasCommAddr = null;
            if(StringUtils.equals(devTermCommProto, "GAEADCU")) {
                devAccessSortNo = "GAEADCU";
                if(devTermCommMode == 1) {
                    upcommProto = "TCP_GAEADCU";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                }
                else if(devTermCommMode == 2) {
                    upcommProto = "UDP_GAEADCU";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "V4");
                productKey = "GAEA_DCU_V4";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;

                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 8)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为8位16进制字符串");
                    return registerResponse;
                }
            }
            else if(StringUtils.equals(devTermCommProto, "DLT698_45")) {
                devAccessSortNo = "DLT698_45";
                if(devTermCommMode == 1) {
                    upcommProto = "TCP_DLT698_45";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                }
                else if(devTermCommMode == 2) {
                    upcommProto = "UDP_DLT698_45";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "2017");
                productKey = "DLT698_45_2017";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;

                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                    return registerResponse;
                }
            }
            else if(StringUtils.equals(devTermCommProto, "DLT698_45_WITH_1867")) {
                devAccessSortNo = "DLT698_45_WITH_1867";
                if(devTermCommMode == 1) {
                    upcommProto = "TCP_DLT698_45_WITH_1867";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                }
                else if(devTermCommMode == 2) {
                    upcommProto = "UDP_DLT698_45_WITH_1867";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "2020");
                productKey = "DLT698_45_WITH_1867_2017";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;

                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 8)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为8位16进制字符串");
                    return registerResponse;
                }
            }
            else if(StringUtils.equals(devTermCommProto, "QGDW1376_1")) {
                devAccessSortNo = "QGDW1376_1";
                if(devTermCommMode == 1) {
                    upcommProto = "TCP_QGDW1376_1";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                }
                else if(devTermCommMode == 2) {
                    upcommProto = "UDP_QGDW1376_1";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "2013");
                productKey = "QGDW1376_1_2013";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;

                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 8)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为8位16进制字符串");
                    return registerResponse;
                }
            }
            else if(StringUtils.equals(devTermCommProto, "IEC104")) {
                devAccessSortNo = "IEC104";
                if(devTermCommMode == 1) {
                    upcommProto = "TCP_IEC104";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                }
                else if(devTermCommMode == 2) {
                    upcommProto = "UDP_IEC104";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "STD");
                productKey = "IEC_104_STD";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = StringUtils.leftPad(upcommLogicAddr, 10, '0') + "00";

                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 4)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为4位16进制字符串");
                    return registerResponse;
                }
            }
            else if(StringUtils.equals(devTermCommProto, "HUAYUN104")) {
                devAccessSortNo = "HUAYUN104";
                if(devTermCommMode == 1) {
                    upcommProto = "TCP_HUAYUN104";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                }
                else if(devTermCommMode == 2) {
                    upcommProto = "UDP_HUAYUN104";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "");
                productKey = "HUAYUN104";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;

                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                    return registerResponse;
                }
            }
            else if(StringUtils.equals(devTermCommProto, "MQTT_JALASMART")) {
                devAccessSortNo = "JALASMART_GATEWAY";
                if(devTermCommMode == 1) {
                    upcommProto = "MQTT_JALASMART";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                }
                else {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("传入采集终端通讯方式不支持");
                    return registerResponse;
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.6");
                productKey = "b03b99VXEV1";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;

//                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 24)) {
//                    registerResponse.setReturnCode("FAILURE");
//                    registerResponse.setFailureCode("10000011");
//                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为24位16进制字符串");
//                    return registerResponse;
//                }
            }
            else if(StringUtils.equals(devTermCommProto, "MQTT_TIMUIOT")) {
                devAccessSortNo = "TIMUIOT_GATEWAY";
                if(devTermCommMode == 1) {
                    upcommProto = "MQTT_TIMUIOT";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                }
                else {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("传入采集终端通讯方式不支持");
                    return registerResponse;
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.28");
                productKey = "YINDE";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;

                if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                    return registerResponse;
                }
            }
            else if(StringUtils.equals(devTermCommProto, "MQTT_DINGIIOT")) {
                devAccessSortNo = "DINGIIOT_GATEWAY";
                if(devTermCommMode == 1) {
                    upcommProto = "MQTT_DINGIIOT";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                }
                else {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("传入采集终端通讯方式不支持");
                    return registerResponse;
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.2");
                productKey = "dingiiot";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;

                /*if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                    return registerResponse;
                }*/
            }
            else if(StringUtils.equals(devTermCommProto, "MQTT_IDCCIOT")) {
                devAccessSortNo = "IDCCIOT_GATEWAY";
                if(devTermCommMode == 1) {
                    upcommProto = "MQTT_IDCCIOT";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                }
                else {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("传入采集终端通讯方式不支持");
                    return registerResponse;
                }
                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.2");
                productKey = "IDCCIOT";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;

                    /*if(!RegExUtils.isHexStrValid(upcommLogicAddr, 12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("传入采集终端通讯地址非法，必须为12位16进制字符串");
                        return modifyResponse;
                    }*/
            }
            else if(StringUtils.equals(devTermCommProto, "LWM2M_CTWING")) {
                devAccessSortNo = "LWM2M_CTWING_GATEWAY";
                /*if(devTermCommMode == 2) {
                    upcommProto = "LWM2M_CTWING_GATEWAY";
                    upcommType = UpcommTypeEnum.UDP_LWM2M.getType();
                }
                else {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("传入采集终端通讯方式不支持");
                    return registerResponse;
                }*/
                //
                upcommProto = "LWM2M_CTWING_GATEWAY";
                upcommType = UpcommTypeEnum.UDP_LWM2M.getType();

                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.9.0");
                productKey = "LWM2M_CTWING";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            }
            else if(StringUtils.equals(devTermCommProto, "WSAPI_SUNTRONT")) {
                devAccessSortNo = "WSAPI_SUNTRONT_GATEWAY";
                devTermCommMode = 2;
                upcommProto = "WSAPI_SUNTRONT_GATEWAY";
                upcommType = UpcommTypeEnum.UDP_LWM2M.getType();

                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "1.0");
                productKey = "WSAPI_SUNTRONT";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            }
            else if(StringUtils.equals(devTermCommProto, "ENOSIOT_API_2")) {
                devAccessSortNo = "ENOSIOT_API_2_GATEWAY";
                devTermCommMode = 1;
                upcommProto = "ENOSIOT_API_2_GATEWAY";
                upcommType = UpcommTypeEnum.TCP_HTTP.getType();

                upcommProtoVer = StringUtils.defaultIfBlank(devTermCommProtoVer, "V2");
                productKey = "ENOSIOT_API_2";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            }
            else {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000010");
                registerResponse.setFailureMsg("传入采集终端通讯规约不支持");
                return registerResponse;
            }
            String devAccessNo = devTermNo;

            DevAccessDo devAccessDo = devAccessDao.getByOrgNoAndDevAccessSortNoAndDevAccessNo(orgNo, devAccessSortNo, devAccessNo);
            if(devAccessDo != null && devAccessDo.getId() > 0L) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000020");
                registerResponse.setFailureMsg("该采集终端编号已存在");
            }

            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(productKey, upcommProto, upcommLogicAddr);
            if(runAccessGatewayVo != null && runAccessGatewayVo.getId() > 0L) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000021");
                registerResponse.setFailureMsg("该采集终端通讯地址已存在");
            }

            Map<String, Object> newEntityMap = Maps.newLinkedHashMap();
            Long accessGatewayId = iotDeviceIdGenerator.nextId();
            devAccessDo = new DevAccessDo();
            devAccessDo.setId(accessGatewayId);
            devAccessDo.setOrgNo(orgNo);
            devAccessDo.setDevAccessSortNo(devAccessSortNo);
            devAccessDo.setDevAccessNo(devAccessNo);
            devAccessDo.setDevAccessName(devTermName);
            devAccessDo.setDevAccessDesc(devTermName);
            devAccessDo.setDevAccessDetail("{}");
            devAccessDo.setGateway(gateway);
            devAccessDo.setTrunking(trunking);
            devAccessDo.setMeasure(measure);
            devAccessDo.setLifeState(DevLifeStateEnum.RUNNING.getCode());
            devAccessDo.setMfrCode(StringUtils.trimToEmpty(registerRequest.getMfrCode()));
            devAccessDo.setModelCode(StringUtils.trimToEmpty(registerRequest.getModelCode()));
            devAccessDo.setSortSn(1);
            devAccessDo.setValid(true);
            devAccessDo.setGmtCreate(System.currentTimeMillis());
            devAccessDo.setGmtModified(System.currentTimeMillis());
            devAccessDo.setGmtInvalid(0L);
            devAccessDo.setVersion(1);
            devAccessDao.insert(devAccessDo);
            newEntityMap.put("devAccess", devAccessDo);

            DevAccessGatewayDo devAccessGatewayDo = new DevAccessGatewayDo();
            devAccessGatewayDo.setId(accessGatewayId);
            devAccessGatewayDo.setUpcommProto(upcommProto);
            devAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
            devAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
            devAccessGatewayDo.setUpcommType(upcommType);
            devAccessGatewayDo.setUpcommParam(upcommParam);
            devAccessGatewayDo.setEncrypt(encrypt);
            devAccessGatewayDo.setEncryptType(encryptType);
            devAccessGatewayDo.setEncryptInfo(encryptInfo);
            devAccessGatewayDo.setVersion(1);
            devAccessGatewayDao.insert(devAccessGatewayDo);
            newEntityMap.put("devAccessGateway", devAccessGatewayDo);

            if(StringUtils.isNotBlank(acsampMeasCommProto) && StringUtils.isNotBlank(acsampMeasCommAddr)) {
                DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
                devAccessMeasureDo.setId(accessGatewayId);
                devAccessMeasureDo.setMeasCommMode(acsampMeasCommMode);
                devAccessMeasureDo.setMeasCommProto(acsampMeasCommProto);
                devAccessMeasureDo.setMeasCommAddr(acsampMeasCommAddr);
                devAccessMeasureDo.setEnableElec(true);
                devAccessMeasureDo.setElecPhaseCount(3);
                devAccessMeasureDo.setEnableWater(false);
                devAccessMeasureDo.setEnableGas(false);
                devAccessMeasureDo.setEnableHeat(false);
                devAccessMeasureDo.setEnableSteam(false);
                devAccessMeasureDo.setVersion(1);
                devAccessMeasureDao.insert(devAccessMeasureDo);
                newEntityMap.put("devAccessMeasure", devAccessMeasureDo);
            }

            RunAccessGatewayDo runAccessGatewayDo = new RunAccessGatewayDo();
            runAccessGatewayDo.setId(accessGatewayId);
            runAccessGatewayDo.setOrgNo(orgNo);
            runAccessGatewayDo.setProductKey(productKey);
            runAccessGatewayDo.setClientId(devAccessNo);
            runAccessGatewayDo.setUpcommProto(upcommProto);
            runAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
            runAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
            runAccessGatewayDo.setUpcommType(upcommType);
            runAccessGatewayDo.setUpcommParam(upcommParam);
            runAccessGatewayDo.setCascade(false);
            runAccessGatewayDo.setParentId(0L);
            runAccessGatewayDo.setEncrypt(encrypt);
            runAccessGatewayDo.setEncryptType(encryptType);
            runAccessGatewayDo.setEncryptInfo(encryptInfo);
            runAccessGatewayDo.setRunStatus(DevRunStatusEnum.GOTORUN.getStatus());
            runAccessGatewayDo.setRunParam("{}");
            runAccessGatewayDo.setRunMode(1);
            runAccessGatewayDo.setRunHeartbeatCycle(30);
            runAccessGatewayDo.setMeasPointCount(1);
            runAccessGatewayDo.setOnline(false);
            runAccessGatewayDo.setGmtConnectedAt(0L);
            runAccessGatewayDo.setGmtHeartbeatUp(0L);
            runAccessGatewayDo.setGmtMessageUp(0L);
            runAccessGatewayDo.setGmtMeasdataUp(0L);
            runAccessGatewayDo.setGmtAlarmUp(0L);
            runAccessGatewayDo.setGmtOffline(0L);
            runAccessGatewayDo.setGmtCreate(System.currentTimeMillis());
            runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
            runAccessGatewayDo.setVersion(1);
            runAccessGatewayDao.insert(runAccessGatewayDo);

            Long acsampMeasPointId = iotDeviceIdGenerator.nextId();
            if(StringUtils.isNotBlank(acsampMeasCommProto) && StringUtils.isNotBlank(acsampMeasCommAddr)) {
                RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
                runMeasPointDo.setId(acsampMeasPointId);
                runMeasPointDo.setOrgNo(orgNo);
                runMeasPointDo.setAccessGatewayId(accessGatewayId);
                runMeasPointDo.setAccessTrunkingId(0L);
                runMeasPointDo.setAccessMeasureId(accessGatewayId);
                runMeasPointDo.setMeasKind(0);
                runMeasPointDo.setMeasSn(0);
                runMeasPointDo.setMeasCommMode(acsampMeasCommMode);
                runMeasPointDo.setMeasCommProto(acsampMeasCommProto);
                runMeasPointDo.setMeasCommAddr(acsampMeasCommAddr);
                runMeasPointDo.setMeasCommPort(0);
                runMeasPointDo.setMeasCommParam("{}");
                runMeasPointDo.setGmtMessageUp(0L);
                runMeasPointDo.setGmtMeasdataUp(0L);
                runMeasPointDo.setGmtAlarmUp(0L);
                runMeasPointDo.setGmtCreate(System.currentTimeMillis());
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDo.setVersion(1);
                runMeasPointDao.insert(runMeasPointDo);
            }

            // logDevAccessEntityDao
            LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
            logDevAccessEntity.setId(iotDeviceIdGenerator.nextId());
            logDevAccessEntity.setLogType(1);
            logDevAccessEntity.setDevAccessId(accessGatewayId);
            logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString(Maps.newLinkedHashMap()));
            logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString(newEntityMap, PropertyNamingStrategy.SNAKE_CASE));
            logDevAccessEntity.setAlterPathway(StringUtils.defaultIfBlank(registerRequest.getPathway(), "PC_WEBAPP"));
            logDevAccessEntity.setAlterOper(StringUtils.defaultIfBlank(registerRequest.getOperator(), "$UNKNOWN^"));
            logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
            logDevAccessEntityDao.insertLog(logDevAccessEntity);

            registerResponse.setReturnCode("SUCCESS");
            registerResponse.setFailureCode(null);
            registerResponse.setAccessGatewayId(accessGatewayId);
            registerResponse.setAcsampMeasPointId(acsampMeasPointId);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" GmDevTermRegisterResponse    : " + JsonConvertUtils.convertToString(registerResponse));
            logger.debug(" <<<<<<<< end registerGmDevTerm <<<<<<<< ");
        }
        return registerResponse;
    }

    @Override
    public GmDevMeterModifyResponse modifyGmDevMeter(GmDevMeterModifyRequest gmDevMeterModifyRequest) {

        GmDevMeterModifyResponse gmDevMeterModifyResponse=new GmDevMeterModifyResponse();
        RunMeasPointDo runMeasPointDo =null;
        try {
            runMeasPointDo = (RunMeasPointDo) BeanUtils.cloneBean(gmDevMeterModifyRequest);
        }catch (Exception e){
            e.printStackTrace();
        }
        runMeasPointDo.setId(gmDevMeterModifyRequest.getRunMeasPointId());
        runMeasPointDao.update(runMeasPointDo);
        gmDevMeterModifyResponse.setRunMeasPointId(gmDevMeterModifyRequest.getRunMeasPointId());
        gmDevMeterModifyResponse.setReturnCode("SUCCESS");
        gmDevMeterModifyResponse.setFailureCode(null);
        return gmDevMeterModifyResponse;
    }

}
