package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.IotPointMeasItemCodeService;
import com.easesource.iot.datacenter.openservice.dao.IotMeasItemCodeDao;
import com.easesource.iot.datacenter.openservice.dao.IotPointMeasItemCodeDao;
import com.easesource.iot.datacenter.openservice.entity.IotPointMeasItemCodeDo;
import com.easesource.iot.datacenter.openservice.request.IotPointMeasItemCodeRequest;
import com.easesource.iot.datacenter.openservice.response.BaseResponse;
import com.easesource.iot.datacenter.openservice.response.IotPointMeasItemCodeResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2024/2/1 14:57
 */
@Service(value = "IotPointMeasItemCodeService")
public class IotPointMeasItemCodeServiceImpl  extends AbstractBaseService implements IotPointMeasItemCodeService {

    @Autowired
    private IotMeasItemCodeDao iotMeasItemCodeDao;

    @Autowired
    private IotPointMeasItemCodeDao iotPointMeasItemCodeDao;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public IotPointMeasItemCodeResponse insertOrUpdatePointMeasItemCode(List<IotPointMeasItemCodeRequest> iotPointMeasItemCodeRequests) {
        IotPointMeasItemCodeResponse iotPointMeasItemCodeResponse=new IotPointMeasItemCodeResponse();
        List<String> measItemCodeList=iotMeasItemCodeDao.getMeasItemCodeList();
        long now = System.currentTimeMillis();
        for (IotPointMeasItemCodeRequest iotPointMeasItemCodeRequest:iotPointMeasItemCodeRequests){
            if (!measItemCodeList.contains(iotPointMeasItemCodeRequest.getMeasItemCode())){
                iotPointMeasItemCodeResponse.setFailureCode("500");
                iotPointMeasItemCodeResponse.setReturnCode("FAILURE");
                iotPointMeasItemCodeResponse.setFailureMsg(iotPointMeasItemCodeRequest.getMeasItemCode()+"编码不存在,请调整编码或联系管理员新加编码！！！");
                return iotPointMeasItemCodeResponse;
            }
            //存在的该规约下该量测点
            IotPointMeasItemCodeDo iotPointMeasItemCodeDo=iotPointMeasItemCodeDao.getIotPointMeasItemCode(iotPointMeasItemCodeRequest);

            //id 为空 新数据 判断后插入
            if (iotPointMeasItemCodeRequest.getId()!=null){
                if (iotPointMeasItemCodeDo!=null&&!iotPointMeasItemCodeDo.getId().equals(iotPointMeasItemCodeRequest.getId())&&iotPointMeasItemCodeDo.getPointItemCode().equals(iotPointMeasItemCodeRequest.getPointItemCode())){
                    iotPointMeasItemCodeResponse.setFailureCode("500");
                    iotPointMeasItemCodeResponse.setReturnCode("FAILURE");
                    iotPointMeasItemCodeResponse.setFailureMsg(iotPointMeasItemCodeRequest.getPointItemCode()+"点位重复！！！");
                    return iotPointMeasItemCodeResponse;
                }
                IotPointMeasItemCodeDo iotPointMeasItemCodeDoupdate=new IotPointMeasItemCodeDo();
                BeanUtils.copyProperties(iotPointMeasItemCodeRequest,iotPointMeasItemCodeDoupdate);
                iotPointMeasItemCodeDoupdate.setMeasItemCode(iotPointMeasItemCodeRequest.getMeasItemCode());
                iotPointMeasItemCodeDoupdate.setPointItemCode(iotPointMeasItemCodeRequest.getPointItemCode());
                iotPointMeasItemCodeDoupdate.setMeasCommProto(iotPointMeasItemCodeRequest.getMeasCommProto());
                iotPointMeasItemCodeDoupdate.setGmtCreate(now);
                iotPointMeasItemCodeDoupdate.setGmtModified(now);
                iotPointMeasItemCodeDao.update(iotPointMeasItemCodeDoupdate);
                continue;
            }
            if (iotPointMeasItemCodeDo!=null&&iotPointMeasItemCodeDo.getPointItemCode().equals(iotPointMeasItemCodeRequest.getPointItemCode())){
                iotPointMeasItemCodeResponse.setFailureCode("500");
                iotPointMeasItemCodeResponse.setReturnCode("FAILURE");
                iotPointMeasItemCodeResponse.setFailureMsg(iotPointMeasItemCodeRequest.getPointItemCode()+"点位重复！！！");
                return iotPointMeasItemCodeResponse;
            }
            IotPointMeasItemCodeDo iotPointMeasItemCodeDonew=new IotPointMeasItemCodeDo();
            BeanUtils.copyProperties(iotPointMeasItemCodeRequest,iotPointMeasItemCodeDonew);
            iotPointMeasItemCodeDonew.setMeasCommMode("RS485");
            iotPointMeasItemCodeDonew.setIsValid(1);
            iotPointMeasItemCodeDonew.setIsDelete(0);
            iotPointMeasItemCodeDonew.setGmtCreate(now);
            iotPointMeasItemCodeDonew.setGmtModified(now);
            iotPointMeasItemCodeDao.insert(iotPointMeasItemCodeDonew);
        }
        iotPointMeasItemCodeResponse.setReturnCode("SUCCESS");
        return iotPointMeasItemCodeResponse;
    }

    @Override
    public void deletePointMeasItemCode(IotPointMeasItemCodeRequest iotPointMeasItemCodeRequest) {
        iotPointMeasItemCodeDao.updateForDelete(iotPointMeasItemCodeRequest.getId());
    }

    @Override
    public List<IotPointMeasItemCodeDo> selectIotPointMeasItemCodeList(String measCommProto) {

        List<IotPointMeasItemCodeDo>  iotPointMeasItemCodeDoList=iotPointMeasItemCodeDao.getIotPointMeasItemCodeList(measCommProto);
        return iotPointMeasItemCodeDoList;
    }
}
