package com.easesource.iot.datacenter.openservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Sorter;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataInsFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.easesource.iot.datacenter.openservice.util.DataWarehouse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measDataService")
public class MeasDataServiceImpl extends AbstractBaseService implements MeasDataService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;

    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

//    @Resource
//    private MeasLatestOperator redisOperator;

    @Override
    public MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataLatest >>>>>>> ");
            logger.debug(" MeasDataLatestGetRequest     : " + JsonConvertUtils.convertToString(measDataLatestGetRequest));
        }
        if(measDataLatestGetRequest.getMeasItemCodeSet().size() == 0) {
            logger.warn("measItemCodeSet is empty");
        }

        MeasDataLatestGetResponse response = new MeasDataLatestGetResponse();
        Long measPointId = measDataLatestGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataLatestGetRequest.getMeasItemCodeSet();
        Map<String, MeasDataLatestInfo> measDataMap = Maps.newHashMap();
        List<MeasDataLatestVo> measDataLatestVoList = null;
        if(measItemCodeSet.size() > 0) {
            measDataLatestVoList = DataWarehouse.getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(Sets.newHashSet(measPointId), measItemCodeSet, measDataLatestGetRequest.getGmtMeasDataLatest());
        }
        if(measDataLatestVoList != null) {
            measDataLatestVoList.forEach(measDataLatestVo -> {
                //logger.info(" measDataLatestVo : " + JsonConvertUtils.convertToString(measDataLatestVo));
                String measItemCode = measDataLatestVo.getMeasItemCode();
                if(measDataLatestVo.getMeasDataInfo() != null) {
                    Map measDataInfoMap = JsonConvertUtils.convertFromString(measDataLatestVo.getMeasDataInfo(), Map.class);
                    String measDataClassName = (String) measDataInfoMap.get("measDataClass");
                    Class measDataClass = null;
                    Object measDataValue = null;
                    BigDecimal selfRate = measDataLatestVo.getSelfRate();
                    if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                        selfRate = new BigDecimal("1.0");
                    }
                    BigDecimal ctRate = measDataLatestVo.getCtRate();
                    if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ctRate = new BigDecimal("1.0");
                    }
                    BigDecimal ptRate = measDataLatestVo.getPtRate();
                    if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ptRate = new BigDecimal("1.0");
                    }
                    if(StringUtils.equals(measDataClassName, "java.math.BigDecimal")) {
                        measDataClass = java.math.BigDecimal.class;
                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, RoundingMode.HALF_UP);
                        if(measDataLatestGetRequest.getMeasDataSideType() == 1) {
                            //measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                            if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                                // 电压 * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                                // 电流 * CT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, RoundingMode.HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                                // 功率 * CT * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                                // 电量 * CT * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                            }
                        }
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Boolean")) {
                        measDataClass = java.lang.Boolean.class;
                        measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.String")) {
                        measDataClass = java.lang.String.class;
                        measDataValue = measDataInfoMap.get("measDataValue").toString();
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Integer")) {
                        measDataClass = java.lang.Integer.class;
                        measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Long")) {
                        measDataClass = java.lang.Long.class;
                        measDataValue = Long.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.util.Date")) {
                        measDataClass = java.util.Date.class;
                        measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
                    }
                    int measDataSource = NumberUtils.toInt(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), 0);
                    long gmtMeasDataLatest = NumberUtils.toLong(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), System.currentTimeMillis());
                    measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
                }
            });
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataLatestGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchGetMeasDataLatest >>>>>>> ");
            logger.debug(" MeasDataLatestBatchGetRequest    : " + JsonConvertUtils.convertToString(measDataLatestBatchGetRequest));
        }
        if(measDataLatestBatchGetRequest.getMeasItemCodeSet().size() == 0) {
            logger.warn("measItemCodeSet is empty");
        }

        MeasDataLatestBatchGetResponse response = new MeasDataLatestBatchGetResponse();
        Set<Long> measPointIdSet = measDataLatestBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataLatestBatchGetRequest.getMeasItemCodeSet();
        Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap = Maps.newHashMap();
        List<MeasDataLatestVo> results = null;
        if(measPointIdSet.size() > 0 && measItemCodeSet.size() > 0) {
            results = DataWarehouse.getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(measPointIdSet, measItemCodeSet, measDataLatestBatchGetRequest.getGmtMeasDataLatest());
        }
        if(results != null) {
            Map<Long, List<MeasDataLatestVo>> groupMeasPointIdResults = results.stream().collect(Collectors.groupingBy(MeasDataLatestVo::getMeasPointId));
            groupMeasPointIdResults.forEach((measPointId, list1) -> {
                Map<String, MeasDataLatestInfo> measDataMap = Maps.newHashMap();
                Map<String, List<MeasDataLatestVo>> groupMeasItemCodeResults = list1.stream().collect(Collectors.groupingBy(MeasDataLatestVo::getMeasItemCode));
                groupMeasItemCodeResults.forEach((measItemCode, list2) -> {
                    if(list2 != null && list2.size() > 0) {
                        MeasDataLatestVo measDataLatestVo = list2.get(0);
                        //logger.info(" measDataLatestVo : " + JsonConvertUtils.convertToString(measDataLatestVo));
                        if(measDataLatestVo != null && measDataLatestVo.getMeasDataInfo() != null) {
                            Map measDataInfoMap = JsonConvertUtils.convertFromString(measDataLatestVo.getMeasDataInfo(), Map.class);
                            String measDataClassName = (String) measDataInfoMap.get("measDataClass");
                            Class measDataClass = null;
                            Object measDataValue = null;
                            BigDecimal selfRate = measDataLatestVo.getSelfRate();
                            if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                                selfRate = new BigDecimal("1.0");
                            }
                            BigDecimal ctRate = measDataLatestVo.getCtRate();
                            if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                                ctRate = new BigDecimal("1.0");
                            }
                            BigDecimal ptRate = measDataLatestVo.getPtRate();
                            if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                                ptRate = new BigDecimal("1.0");
                            }
                            if(StringUtils.equals(measDataClassName, "java.math.BigDecimal")) {
                                measDataClass = java.math.BigDecimal.class;
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, RoundingMode.HALF_UP);
                                if(measDataLatestBatchGetRequest.getMeasDataSideType() == 1) {
                                    //measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                                        // 电压 * PT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                                        // 电流 * CT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                                        // 功率 * CT * PT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                    else if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                                        // 电量 * CT * PT
                                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                                    }
                                }
                            }
                            else if(StringUtils.equals(measDataClassName, "java.lang.Boolean")) {
                                measDataClass = java.lang.Boolean.class;
                                measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
                            }
                            else if(StringUtils.equals(measDataClassName, "java.lang.String")) {
                                measDataClass = java.lang.String.class;
                                measDataValue = measDataInfoMap.get("measDataValue").toString();
                            }
                            else if(StringUtils.equals(measDataClassName, "java.lang.Integer")) {
                                measDataClass = java.lang.Integer.class;
                                measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
                            }
                            else if(StringUtils.equals(measDataClassName, "java.util.Date")) {
                                measDataClass = java.util.Date.class;
                                measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
                            }
                            int measDataSource = NumberUtils.toInt(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), 0);
                            long gmtMeasDataLatest = NumberUtils.toLong(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), System.currentTimeMillis());
                            measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
                        }
                    }
                });
                batchMeasDataMap.put(measPointId, measDataMap);
            });
        }
        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataLatestBatchGetResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end batchGetMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsDiscreteGetRangeResponse getRangeMeasDataInsDiscrete(MeasDataInsDiscreteGetRangeRequest measDataInsDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataInsFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString(measDataInsFreezeCurveGetRequest));
        }

        MeasDataInsFreezeCurveGetResponse response = new MeasDataInsFreezeCurveGetResponse();
        Long measPointId = measDataInsFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataInsFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataInsFreezeCurveValue> measDataMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            if(measDataInsFreezeCurveVo != null) {
                BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataInsFreezeCurveGetRequest.getMeasDataSideType() == 1) {
                    //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                        // 电压 * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                        // 电流 * CT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                        // 功率 * CT * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataMap.put(measItemCode, new MeasDataInsFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
            }
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataInsFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataInsFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString(measDataInsFreezeCurveGetRangeRequest));
        }

        MeasDataInsFreezeCurveGetRangeResponse response = new MeasDataInsFreezeCurveGetRangeResponse();
        Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            List<MeasDataInsFreezeCurveValue> measDataList = Lists.newArrayList();
            for(MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo : measDataInsFreezeCurveList) {
                BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                    //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                        // 电压 * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                        // 电流 * CT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                        // 功率 * CT * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataList.add(new MeasDataInsFreezeCurveValue(measPointId, measItemCode, measDataInsFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataInsFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }


    @Override
    public MeasDataInsFreezeCurveGetRangeListResponse  getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequestList) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataInsFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString(measDataInsFreezeCurveGetRangeRequestList));
        }
        MeasDataInsFreezeCurveGetRangeListResponse measDataInsFreezeCurveGetRangeListResponse=new MeasDataInsFreezeCurveGetRangeListResponse();
        List<MeasDataInsFreezeCurveGetRangeBaseResponse> responseList=new ArrayList<>();
        List<Long> measPointIds=measDataInsFreezeCurveGetRangeRequestList.stream().map(MeasDataInsFreezeCurveGetRangeRequest::getMeasPointId).distinct().collect(Collectors.toList());
        List<String> measItemCodeList=measDataInsFreezeCurveGetRangeRequestList.stream().map(MeasDataInsFreezeCurveGetRangeRequest::getMeasItemCodeSet).flatMap(Set::stream).distinct().collect(Collectors.toList());
        Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = Maps.newHashMap();

        //如果measPointIds 根据10个一组分批查询
        int groupSize = 10;
        for (int i = 0; i < measPointIds.size(); i += groupSize) {
            int endIndex = Math.min(i + groupSize, measPointIds.size());
            List<Long> subList = measPointIds.subList(i, endIndex);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveListByList(subList,measItemCodeList, measDataInsFreezeCurveGetRangeRequestList.get(0).getGmtMeasFreezeStart(), measDataInsFreezeCurveGetRangeRequestList.get(0).getGmtMeasFreezeEnd(), new Sorter("gmt_meas_freeze", "ASC"));
            //measDataInsFreezeCurveList 根据measPointId分组
            Map<Long, List<MeasDataInsFreezeCurveVo>> measDataInsFreezeCurveMap = measDataInsFreezeCurveList.stream().collect(Collectors.groupingBy(MeasDataInsFreezeCurveVo::getMeasPointId));
            measDataInsFreezeCurveMap.forEach((key, value) -> {
                MeasDataInsFreezeCurveGetRangeBaseResponse response = new MeasDataInsFreezeCurveGetRangeBaseResponse();
                List<MeasDataInsFreezeCurveValue> measDataList = new ArrayList<>();
                for (MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo : value) {
                    BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                    if (!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                        selfRate = new BigDecimal("1.0");
                    }
                    BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                    if (!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ctRate = new BigDecimal("1.0");
                    }
                    BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                    if (!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ptRate = new BigDecimal("1.0");
                    }
                    BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                    if (measDataInsFreezeCurveGetRangeRequestList.get(0).getMeasDataSideType() == 1) {
                        //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                        if (StringUtils.containsAny(measDataInsFreezeCurveVo.getMeasItemCode(), "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                            // 电压 * PT
                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        } else if (StringUtils.containsAny(measDataInsFreezeCurveVo.getMeasItemCode(), "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                            // 电流 * CT
                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        } else if (StringUtils.containsAny(measDataInsFreezeCurveVo.getMeasItemCode(), "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                            // 功率 * CT * PT
                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                    }
                    response.setMeasPointId(measDataInsFreezeCurveVo.getMeasPointId());
                    measDataList.add(new MeasDataInsFreezeCurveValue(measDataInsFreezeCurveVo.getMeasPointId(), measDataInsFreezeCurveVo.getMeasItemCode(), measDataInsFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
                }
                //measDataList根据measItemCode 分组
                Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMapReult = measDataList.stream().collect(Collectors.groupingBy(MeasDataInsFreezeCurveValue::getMeasItemCode));
                measDataListMap.putAll(measDataListMapReult);
                response.setMeasDataListMap(measDataListMap);
                responseList.add(response);
            });

        }

//        measDataInsFreezeCurveGetRangeRequestList.forEach(measDataInsFreezeCurveGetRangeRequest->{
//            MeasDataInsFreezeCurveGetRangeBaseResponse response = new MeasDataInsFreezeCurveGetRangeBaseResponse();
//            Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
//            Set<String> measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
//            long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
//            long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
//            Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = Maps.newHashMap();
//            for(String measItemCode : measItemCodeSet) {
//                Map<String, Object> params = Maps.newHashMap();
//                params.put("measPointId", measPointId);
//                params.put("measItemCode", measItemCode);
//                params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
//                params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
//                List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
//                List<MeasDataInsFreezeCurveValue> measDataList = Lists.newArrayList();
//                for(MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo : measDataInsFreezeCurveList) {
//                    BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
//                    if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
//                        selfRate = new BigDecimal("1.0");
//                    }
//                    BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
//                    if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
//                        ctRate = new BigDecimal("1.0");
//                    }
//                    BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
//                    if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
//                        ptRate = new BigDecimal("1.0");
//                    }
//                    BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
//                    if(measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
//                        //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
//                        if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
//                            // 电压 * PT
//                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
//                        }
//                        else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
//                            // 电流 * CT
//                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
//                        }
//                        else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
//                            // 功率 * CT * PT
//                            measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
//                        }
//                    }
//                    measDataList.add(new MeasDataInsFreezeCurveValue(measPointId, measItemCode, measDataInsFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
//                }
//                measDataListMap.put(measItemCode, measDataList);
//            }
//            response.setMeasPointId(measPointId);
//            response.setMeasDataListMap(measDataListMap);
//
//            if(logger.isDebugEnabled()) {
//                logger.debug(" MeasDataInsFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
//                logger.debug(" <<<<<<<< end getRangeMeasDataInsFreezeCurve <<<<<<<< ");
//            }
//            responseList.add(response);
//        });
        measDataInsFreezeCurveGetRangeListResponse.setDataList(responseList);
        measDataInsFreezeCurveGetRangeListResponse.setReturnCode("SUCCESS");
        return measDataInsFreezeCurveGetRangeListResponse;
    }

    @Override
    public MeasDataCumDiscreteGetRangeResponse getRangeMeasDataCumDiscrete(MeasDataCumDiscreteGetRangeRequest measDataCumDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveGetRequest));
        }

        MeasDataCumFreezeCurveGetResponse response = new MeasDataCumFreezeCurveGetResponse();
        Long measPointId = measDataCumFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataCumFreezeCurveValue> measDataMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo = null;
            try {
                measDataCumFreezeCurveVo = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            } catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if(measDataCumFreezeCurveVo != null) {
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if(measDataCumFreezeCurveGetRequest.getMeasDataSideType() == 1) {
                    // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                        // 电量 * CT * PT
                        measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    }
                }
                measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, RoundingMode.HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            }
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchGetMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveBatchGetRequest     : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveBatchGetRequest));
        }

        MeasDataCumFreezeCurveBatchGetResponse response = new MeasDataCumFreezeCurveBatchGetResponse();
        Set<Long> measPointIdSet = measDataCumFreezeCurveBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataCumFreezeCurveBatchGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveBatchGetRequest.getGmtMeasFreeze();
        Map<Long, Map<String, MeasDataCumFreezeCurveValue>> batchMeasDataMap = Maps.newHashMap();
        List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoListByMeasPointIdSetAndMeasItemCodeSetAndGmtMeasFreeze(measPointIdSet, measItemCodeSet, gmtMeasFreeze);
        measDataCumFreezeCurveList.forEach(measDataCumFreezeCurveVo -> {
            Long measPointId = measDataCumFreezeCurveVo.getMeasPointId();
            String measItemCode = measDataCumFreezeCurveVo.getMeasItemCode();
            Map<String, MeasDataCumFreezeCurveValue> measDataMap = batchMeasDataMap.get(measPointId);
            if(measDataMap == null) {
                measDataMap = Maps.newHashMap();
            }
            BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
            if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                selfRate = new BigDecimal("1.0");
            }
            BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
            if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                ctRate = new BigDecimal("1.0");
            }
            BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
            if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                ptRate = new BigDecimal("1.0");
            }
            BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
            if(measDataCumFreezeCurveBatchGetRequest.getMeasDataSideType() == 1) {
                // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                    // 电量 * CT * PT
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                }
            }
            measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, RoundingMode.HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            batchMeasDataMap.put(measPointId, measDataMap);
        });
        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveBatchGetMTPsResponse batchGetMTPsMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetMTPsRequest measDataCumFreezeCurveBatchGetMTPsRequest) {
        MeasDataCumFreezeCurveBatchGetMTPsResponse response = new MeasDataCumFreezeCurveBatchGetMTPsResponse();
        Set<Long> measPointIdSet = measDataCumFreezeCurveBatchGetMTPsRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataCumFreezeCurveBatchGetMTPsRequest.getMeasItemCodeSet();
        Set<Long> gmtMeasFreezeSet = measDataCumFreezeCurveBatchGetMTPsRequest.getGmtMeasFreezeSet();
        Map<Long, Map<String, List<MeasDataCumFreezeCurveValue>>> batchMeasDataMap = Maps.newHashMap();
        List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoListByMeasPointIdSetAndMeasItemCodeSetAndGmtMeasFreezeMTPs(measPointIdSet, measItemCodeSet, gmtMeasFreezeSet);
        if (measDataCumFreezeCurveList.size()<measPointIdSet.size()*measItemCodeSet.size()*gmtMeasFreezeSet.size()){
            //数据有掉点
            measPointIdSet.forEach(measPointId->{
                measItemCodeSet.forEach(measItemCode->{
                    gmtMeasFreezeSet.forEach(gmtMeasFreeze ->{
                        List<MeasDataCumFreezeCurveVo> collect = measDataCumFreezeCurveList.stream()
                            .filter(curve -> curve.getMeasPointId().equals(measPointId)
                                && curve.getMeasItemCode().equals(measItemCode)
                                && curve.getGmtMeasFreeze() == gmtMeasFreeze).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(collect)){
                            MeasDataCumFreezeCurveVo measDataCumFreezeCurve=measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreezeMTPs(measPointId,measItemCode,gmtMeasFreeze);
                            if (measDataCumFreezeCurve!=null){
                                measDataCumFreezeCurve.setGmtMeasFreeze(gmtMeasFreeze);
                                measDataCumFreezeCurveList.add(measDataCumFreezeCurve);
                            }
                        }
                    });
                });
            });
        }
        measDataCumFreezeCurveList.forEach(measDataCumFreezeCurveVo -> {
            Long measPointId = measDataCumFreezeCurveVo.getMeasPointId();
            String measItemCode = measDataCumFreezeCurveVo.getMeasItemCode();
            Map<String, List<MeasDataCumFreezeCurveValue>> measDataMap = batchMeasDataMap.get(measPointId);
            if(measDataMap == null) {
                measDataMap = Maps.newHashMap();
            }
            BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
            if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                selfRate = new BigDecimal("1.0");
            }
            BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
            if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                ctRate = new BigDecimal("1.0");
            }
            BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
            if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                ptRate = new BigDecimal("1.0");
            }
            BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
            if(measDataCumFreezeCurveBatchGetMTPsRequest.getMeasDataSideType() == 1) {
                // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                    // 电量 * CT * PT
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                }
            }
            List<MeasDataCumFreezeCurveValue> measDataCumFreezeCurveValues = measDataMap.get(measItemCode);
            if(CollectionUtils.isEmpty(measDataCumFreezeCurveValues)){
                measDataCumFreezeCurveValues = Lists.newArrayList();
            }
            measDataCumFreezeCurveValues.add(new MeasDataCumFreezeCurveValue(measPointId, measItemCode, measDataCumFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, RoundingMode.HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            measDataMap.put(measItemCode,measDataCumFreezeCurveValues);
            batchMeasDataMap.put(measPointId, measDataMap);
        });
        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveGetRangeRequest));
        }

        MeasDataCumFreezeCurveGetRangeResponse response = new MeasDataCumFreezeCurveGetRangeResponse();
        Long measPointId = measDataCumFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataListMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            List<MeasDataCumFreezeCurveValue> measDataList = Lists.newArrayList();
            for(MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataCumFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                    // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                        // 电量 * CT * PT
                        measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataList.add(new MeasDataCumFreezeCurveValue(measPointId, measItemCode, measDataCumFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeDayGetResponse getMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRequest measDataCumFreezeDayGetRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeDayGetRangeResponse getRangeMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRangeRequest measDataCumFreezeDayGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStateBoolDiscreteGetRangeResponse getRangeMeasDataStateBoolDiscrete(MeasDataStateBoolDiscreteGetRangeRequest measDataStateBoolDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStateCharDiscreteGetRangeResponse getRangeMeasDataStateCharDiscrete(MeasDataStateCharDiscreteGetRangeRequest measDataStateCharDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStatsDiscreteGetRangeResponse getRangeMeasDataStatsDiscrete(MeasDataStatsDiscreteGetRangeRequest measDataStatsDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataAlarmDiscreteGetRangeResponse getRangeMeasDataAlarmDiscrete(MeasDataAlarmDiscreteGetRangeRequest measDataAlarmDiscreteGetRangeRequest) {
        return null;
    }

}
