package com.easesource.iot.datacenter.openservice.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.easesource.iot.datacenter.openservice.dao.MeasDataLatestSynchronizerDao;
import com.easesource.iot.datacenter.openservice.entity.GmDevMeterSynchronizerDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestVo;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.BiConsumer;

@SuppressWarnings(value = "all")
@Component
@Slf4j
public class MeasLatestOperator {

    public static final String exceedTitle = "measDataLatest";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private RedisUtil redisUtil;

    @Resource
    private MeasDataLatestSynchronizerDao measDataLatestSynchronizerDao;

    @Resource
    public RedisTemplate redisTemplate;


    /**
     * 拼接最新数据的键
     */
    public String splicKey(Long measPointId) {
        return exceedTitle.concat(":").concat(String.valueOf(measPointId));
    }

    /**
     * 获取所有的原始数据
     */
    public List<MeasDataLatestVo> getAllMeasDataLatest() {
        List<Object> originalValue = redisUtil.getAllValue();
        //对数据进行处理
        List<MeasDataLatestVo> voList = new ArrayList<>();
        for (Object obj : originalValue) {
            MeasDataLatestVo measDataLatestVo = JSON.parseObject(obj.toString(), MeasDataLatestVo.class);
            voList.add(measDataLatestVo);
        }
        return voList;
    }

    /**
     * 获取超前缀的数量
     */
//    public Long CorrectVerification() {
//        return redisUtil.CorrectVer(exceedTitle);
//    }

    /**
     * 获取所有的key
     */
    public Set<String> getAllKey() {
        return redisUtil.getAllKey();
    }


    /**
     * 存储List
     *
     * @param measPointId
     * @param valueList
     */
    public void replaceData(Long measPointId, Map<String, MeasDataLatestVo> valueList) {
        String key = splicKey(measPointId);
        redisUtil.setCacheMap(key, valueList);
    }


    /**
     * 批量删除原始数据
     */
//    public void deleteOriginalData(Set<String> keys) {
//        redisUtil.deleteObject(keys);
//    }

    /**
     * 获取整体数据
     */
    public Map<String, MeasDataLatestVo> getEnsembleMeasLatest(Long measPointId) {
        try {
            String key = splicKey(measPointId);
            if (redisUtil.hasKey(key)) {
                // 返现擦除了
                Map<String, JSONObject> map = redisUtil.getCacheMap(key);
                // init with cap
                Map<String, MeasDataLatestVo> result = new HashMap<>(map.size());
                map.forEach((k, v) -> {
                    result.put(k, JSON.parseObject(v.toJSONString(), MeasDataLatestVo.class));
                });


                return result;
            }
        } catch (Exception e) {
            logger.error("根据measPointId获取数据失败：{}", measPointId, e);
        }
        return null;
    }

    /**
     * 获取measItemCode - measDataInfo
     *
     * @param measPointId
     * @param measItemCode
     * @return
     */
    public MeasDataLatestVo getMeasDataLatest(Long measPointId, String measItemCode) {
        Map<String, MeasDataLatestVo> map = getEnsembleMeasLatest(measPointId);
        if (map != null) {
            Set<String> keySet = map.keySet();
            for (String key : keySet) {
                if (measItemCode.equals(key)) {
                    return map.get(key);
                }
            }
        }
        return null;
    }

    /**
     * 更新数据
     *
     * @param measDataLatestDo
     */
    public void updateMeasDataLatest(MeasDataLatestVo measDataLatestVo) {
        try {
            Map<String, MeasDataLatestVo> map = getEnsembleMeasLatest(measDataLatestVo.getMeasPointId());
            if (map == null) {
                map = new HashMap<>();
                map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
                replaceData(measDataLatestVo.getMeasPointId(), map);
                return;
            } else {
                HashOperations<String, String, Object> hashOperations = redisTemplate.opsForHash();
                hashOperations.put(splicKey(measDataLatestVo.getMeasPointId()), measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            }
        } catch (Exception e) {
            logger.error("根据measPointId更新数据失败： {}", measDataLatestVo.getMeasPointId(), e);
        }
    }

    /**
     * 批量获取
     *
     * @param measPointIdSet
     * @param measItemCodeSet
     * @return
     */
    public List<MeasDataLatestDo> getListByMeasPointIdSetAndMeasItemCodeSet(Set<Long> measPointIdSet, Set<String> measItemCodeSet) {
        List<MeasDataLatestDo> list = new ArrayList<>();
        for (Long measPointId : measPointIdSet) {
            Map<String, MeasDataLatestVo> map = getEnsembleMeasLatest(measPointId);
            if (map != null) {
                map.forEach((key, value) -> {
                    if (measItemCodeSet.contains(key)) {
                        MeasDataLatestDo latestDo = new MeasDataLatestDo();
                        latestDo.setId(value.getId());
                        latestDo.setMeasPointId(value.getMeasPointId());
                        latestDo.setMeasItemCode(value.getMeasItemCode());
                        latestDo.setMeasDataInfo(value.getMeasDataInfo());
                        latestDo.setGmtCreate(value.getGmtCreate());
                        latestDo.setGmtModified(value.getGmtModified());
                        list.add(latestDo);
                    }
                });
            }
        }
        if (list.size() == 0) {
            return null;
        }
        return list;

    }

    /**
     * 更新
     *
     * @param latestDo
     */
    public void insertmeasLatest(MeasDataLatestDo latestDo) {
        boolean flg = false;
        Map<String, MeasDataLatestVo> map = getEnsembleMeasLatest(latestDo.getMeasPointId());
        if (map != null) {
            MeasDataLatestVo mv = map.getOrDefault(latestDo.getMeasItemCode(), null);
            if (mv != null) {
                mv.setMeasDataInfo(latestDo.getMeasDataInfo());
                mv.setGmtModified(latestDo.getGmtModified());
                HashOperations<String, String, Object> hashOperations = redisTemplate.opsForHash();
                hashOperations.put(splicKey(latestDo.getMeasPointId()), latestDo.getMeasItemCode(), mv);
            } else {
                MeasDataLatestVo vo = doToMeasDataLatestVo(latestDo);
                updateVoRate(vo);
                HashOperations<String, String, Object> hashOperations = redisTemplate.opsForHash();
                hashOperations.put(splicKey(latestDo.getMeasPointId()), latestDo.getMeasItemCode(), vo);
            }
        } else {
            map = new HashMap<>();
            MeasDataLatestVo vo = doToMeasDataLatestVo(latestDo);
            updateVoRate(vo);
            map.put(latestDo.getMeasItemCode(), vo);
            replaceData(latestDo.getMeasPointId(), map);
        }
    }

    /**
     * do to vo
     *
     * @param latestDo
     * @return
     */
    public MeasDataLatestVo doToMeasDataLatestVo(MeasDataLatestDo latestDo) {
        MeasDataLatestVo vo = new MeasDataLatestVo();
        vo.setId(latestDo.getId());
        vo.setMeasPointId(latestDo.getMeasPointId());
        vo.setMeasItemCode(latestDo.getMeasItemCode());
        vo.setMeasDataInfo(latestDo.getMeasDataInfo());
        vo.setGmtCreate(latestDo.getGmtCreate());
        vo.setGmtModified(latestDo.getGmtModified());
        updateVoRate(vo);
        return vo;
    }


    /**
     * update rate
     *
     * @param vo
     */
    public void updateVoRate(MeasDataLatestVo vo) {
        GmDevMeterSynchronizerDo gmDevMeterSynchronizerDo = measDataLatestSynchronizerDao.getRate(vo.getMeasPointId());
        if (gmDevMeterSynchronizerDo != null) {
            vo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
            vo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
            vo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
        }
    }


    /**
     * 删除
     *
     * @param measPointId
     * @param measItemCode
     */
    public void deleteByMeasPointIdAndMeasItemCode(Long measPointId, String measItemCode) {
        Map<String, MeasDataLatestVo> map = getEnsembleMeasLatest(measPointId);
        if (map != null) {
            if (map.containsKey(measItemCode)) {
                map.remove(measItemCode);
            }
        }
        replaceData(measPointId, map);
    }

    public List<MeasDataLatestVo> getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(Set<Long> newHashSet, Set<String> measItemCodeSet, Long gmtMeasDataLatest) {
        List<MeasDataLatestVo> list = new ArrayList<>();
        for (Long measPointId : newHashSet) {
            Map<String, MeasDataLatestVo> map = getEnsembleMeasLatest(measPointId);
            if (map != null) {
                map.forEach((key, value) -> {
                    if (measItemCodeSet.contains(key)) {
                        if (gmtMeasDataLatest != null && gmtMeasDataLatest > 0) {
                            if (value.getGmtModified() > gmtMeasDataLatest) {
                                list.add(value);
                            }
                        } else {
                            list.add(value);
                        }
                    }
                });
            }
        }
        if (list.size() == 0) {
            return null;
        }
        return list;

    }
}
