/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.util;

import com.easesource.iot.datacenter.openservice.dao.MeasDataLatestSynchronizerDao;
import com.easesource.iot.datacenter.openservice.entity.GmDevMeterSynchronizerDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataWarehouse {
    private static final Logger log = LoggerFactory.getLogger(DataWarehouse.class);
    @Resource
    private MeasDataLatestSynchronizerDao measDataLatestSynchronizerDao;
    private static final ConcurrentHashMap<Long, ConcurrentHashMap<String, MeasDataLatestVo>> dataMap = new ConcurrentHashMap(2500);

    public static MeasDataLatestVo getMeasDataLatest(Long measPointId, String measItemCode) {
        Map map = dataMap.getOrDefault(measPointId, null);
        if (map != null) {
            return map.getOrDefault(measItemCode, null);
        }
        return null;
    }

    public static void updateMeasDataLatest(MeasDataLatestVo measDataLatestVo) {
        ConcurrentHashMap<String, MeasDataLatestVo> map = dataMap.getOrDefault(measDataLatestVo.getMeasPointId(), null);
        if (map != null) {
            if (map.containsKey(measDataLatestVo.getMeasItemCode())) {
                map.replace(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            } else {
                map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            }
            dataMap.replace(measDataLatestVo.getMeasPointId(), map);
        } else {
            map = new ConcurrentHashMap<String, MeasDataLatestVo>();
            map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            dataMap.put(measDataLatestVo.getMeasPointId(), map);
        }
    }

    public static List<MeasDataLatestDo> getListByMeasPointIdSetAndMeasItemCodeSet(Set<Long> measPointIdSet, Set<String> measItemCodeSet) {
        ArrayList<MeasDataLatestDo> list = new ArrayList<MeasDataLatestDo>();
        for (Long measPointId : measPointIdSet) {
            Map map = dataMap.getOrDefault(measPointId, null);
            if (map == null) continue;
            map.forEach((key, value) -> {
                if (measItemCodeSet.contains(key)) {
                    MeasDataLatestDo latestDo = new MeasDataLatestDo();
                    latestDo.setId(value.getId());
                    latestDo.setMeasPointId(value.getMeasPointId());
                    latestDo.setMeasItemCode(value.getMeasItemCode());
                    latestDo.setMeasDataInfo(value.getMeasDataInfo());
                    latestDo.setGmtCreate(value.getGmtCreate());
                    latestDo.setGmtModified(value.getGmtModified());
                    list.add(latestDo);
                }
            });
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public static void deleteByMeasPointIdAndMeasItemCode(Long measPointId, String measItemCode) {
        ConcurrentHashMap map = dataMap.getOrDefault(measPointId, null);
        if (measPointId != null) {
            map.remove(measItemCode);
        }
    }

    public static List<MeasDataLatestVo> getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(Set<Long> newHashSet, Set<String> measItemCodeSet, Long gmtMeasDataLatest) {
        ArrayList<MeasDataLatestVo> list = new ArrayList<MeasDataLatestVo>();
        for (Long measPointId : newHashSet) {
            Map map = dataMap.getOrDefault(measPointId, null);
            if (map == null) continue;
            map.forEach((key, value) -> {
                if (measItemCodeSet.contains(key)) {
                    if (gmtMeasDataLatest != null && gmtMeasDataLatest > 0L) {
                        if (value.getGmtModified() > gmtMeasDataLatest) {
                            list.add((MeasDataLatestVo)value);
                        }
                    } else {
                        list.add((MeasDataLatestVo)value);
                    }
                }
            });
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public void insertmeasLatest(MeasDataLatestDo latestDo) {
        ConcurrentHashMap<String, Object> map = dataMap.getOrDefault(latestDo.getMeasPointId(), null);
        if (map != null) {
            MeasDataLatestVo vo = map.getOrDefault(latestDo.getMeasItemCode(), null);
            if (vo != null) {
                vo.setMeasDataInfo(latestDo.getMeasDataInfo());
                vo.setGmtModified(latestDo.getGmtModified());
                this.updateVoRate(vo);
                map.replace(latestDo.getMeasItemCode(), vo);
                dataMap.replace(latestDo.getMeasPointId(), map);
            } else {
                MeasDataLatestVo measDataLatestVo = this.doToMeasDataLatestVo(latestDo);
                map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
                dataMap.replace(measDataLatestVo.getMeasPointId(), map);
            }
        } else {
            MeasDataLatestVo measDataLatestVo = this.doToMeasDataLatestVo(latestDo);
            map = new ConcurrentHashMap<String, Object>();
            map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
            dataMap.put(measDataLatestVo.getMeasPointId(), map);
        }
    }

    public MeasDataLatestVo doToMeasDataLatestVo(MeasDataLatestDo latestDo) {
        MeasDataLatestVo vo = new MeasDataLatestVo();
        vo.setId(latestDo.getId());
        vo.setMeasPointId(latestDo.getMeasPointId());
        vo.setMeasItemCode(latestDo.getMeasItemCode());
        vo.setMeasDataInfo(latestDo.getMeasDataInfo());
        vo.setGmtCreate(latestDo.getGmtCreate());
        vo.setGmtModified(latestDo.getGmtModified());
        this.updateVoRate(vo);
        return vo;
    }

    public void updateVoRate(MeasDataLatestVo vo) {
        GmDevMeterSynchronizerDo gmDevMeterSynchronizerDo = this.measDataLatestSynchronizerDao.getRate(vo.getMeasPointId());
        if (gmDevMeterSynchronizerDo != null) {
            vo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
            vo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
            vo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
        }
    }
}

