/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.util;

import com.alibaba.fastjson.JSON;
import com.easesource.iot.datacenter.openservice.dao.MeasDataLatestSynchronizerDao;
import com.easesource.iot.datacenter.openservice.entity.GmDevMeterSynchronizerDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestVo;
import com.easesource.iot.datacenter.openservice.util.RedisUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class MeasLatestOperator {
    private static final Logger log = LoggerFactory.getLogger(MeasLatestOperator.class);
    public static final String exceedTitle = "measDataLatest";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private MeasDataLatestSynchronizerDao measDataLatestSynchronizerDao;
    @Resource
    public RedisTemplate redisTemplate;

    public String splicKey(Long measPointId) {
        return exceedTitle.concat(":").concat(String.valueOf(measPointId));
    }

    public List<MeasDataLatestVo> getAllMeasDataLatest() {
        List<Object> originalValue = this.redisUtil.getAllValue();
        ArrayList<MeasDataLatestVo> voList = new ArrayList<MeasDataLatestVo>();
        for (Object obj : originalValue) {
            MeasDataLatestVo measDataLatestVo = (MeasDataLatestVo)JSON.parseObject((String)obj.toString(), MeasDataLatestVo.class);
            voList.add(measDataLatestVo);
        }
        return voList;
    }

    public Set<String> getAllKey() {
        return this.redisUtil.getAllKey();
    }

    public void replaceData(Long measPointId, Map<String, MeasDataLatestVo> valueList) {
        String key = this.splicKey(measPointId);
        this.redisUtil.setCacheMap(key, valueList);
    }

    public Map<String, MeasDataLatestVo> getEnsembleMeasLatest(Long measPointId) {
        try {
            String key = this.splicKey(measPointId);
            if (this.redisUtil.hasKey(key).booleanValue()) {
                Map map = this.redisUtil.getCacheMap(key);
                HashMap<String, MeasDataLatestVo> result = new HashMap<String, MeasDataLatestVo>(map.size());
                map.forEach((k, v) -> result.put((String)k, (MeasDataLatestVo)JSON.parseObject((String)v.toJSONString(), MeasDataLatestVo.class)));
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636emeasPointId\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff1a{}", (Object)measPointId, (Object)e);
        }
        return null;
    }

    public MeasDataLatestVo getMeasDataLatest(Long measPointId, String measItemCode) {
        Map<String, MeasDataLatestVo> map = this.getEnsembleMeasLatest(measPointId);
        if (map != null) {
            Set<String> keySet = map.keySet();
            for (String key : keySet) {
                if (!measItemCode.equals(key)) continue;
                return map.get(key);
            }
        }
        return null;
    }

    public void updateMeasDataLatest(MeasDataLatestVo measDataLatestVo) {
        try {
            Map<String, MeasDataLatestVo> map = this.getEnsembleMeasLatest(measDataLatestVo.getMeasPointId());
            if (map == null) {
                map = new HashMap<String, MeasDataLatestVo>();
                map.put(measDataLatestVo.getMeasItemCode(), measDataLatestVo);
                this.replaceData(measDataLatestVo.getMeasPointId(), map);
                return;
            }
            HashOperations hashOperations = this.redisTemplate.opsForHash();
            hashOperations.put((Object)this.splicKey(measDataLatestVo.getMeasPointId()), (Object)measDataLatestVo.getMeasItemCode(), (Object)measDataLatestVo);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636emeasPointId\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a {}", (Object)measDataLatestVo.getMeasPointId(), (Object)e);
        }
    }

    public List<MeasDataLatestDo> getListByMeasPointIdSetAndMeasItemCodeSet(Set<Long> measPointIdSet, Set<String> measItemCodeSet) {
        ArrayList<MeasDataLatestDo> list = new ArrayList<MeasDataLatestDo>();
        for (Long measPointId : measPointIdSet) {
            Map<String, MeasDataLatestVo> map = this.getEnsembleMeasLatest(measPointId);
            if (map == null) continue;
            map.forEach((key, value) -> {
                if (measItemCodeSet.contains(key)) {
                    MeasDataLatestDo latestDo = new MeasDataLatestDo();
                    latestDo.setId(value.getId());
                    latestDo.setMeasPointId(value.getMeasPointId());
                    latestDo.setMeasItemCode(value.getMeasItemCode());
                    latestDo.setMeasDataInfo(value.getMeasDataInfo());
                    latestDo.setGmtCreate(value.getGmtCreate());
                    latestDo.setGmtModified(value.getGmtModified());
                    list.add(latestDo);
                }
            });
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public void insertmeasLatest(MeasDataLatestDo latestDo) {
        boolean flg = false;
        Map<String, MeasDataLatestVo> map = this.getEnsembleMeasLatest(latestDo.getMeasPointId());
        if (map != null) {
            MeasDataLatestVo mv = map.getOrDefault(latestDo.getMeasItemCode(), null);
            if (mv != null) {
                mv.setMeasDataInfo(latestDo.getMeasDataInfo());
                mv.setGmtModified(latestDo.getGmtModified());
                HashOperations hashOperations = this.redisTemplate.opsForHash();
                hashOperations.put((Object)this.splicKey(latestDo.getMeasPointId()), (Object)latestDo.getMeasItemCode(), (Object)mv);
            } else {
                MeasDataLatestVo vo = this.doToMeasDataLatestVo(latestDo);
                this.updateVoRate(vo);
                HashOperations hashOperations = this.redisTemplate.opsForHash();
                hashOperations.put((Object)this.splicKey(latestDo.getMeasPointId()), (Object)latestDo.getMeasItemCode(), (Object)vo);
            }
        } else {
            map = new HashMap<String, MeasDataLatestVo>();
            MeasDataLatestVo vo = this.doToMeasDataLatestVo(latestDo);
            this.updateVoRate(vo);
            map.put(latestDo.getMeasItemCode(), vo);
            this.replaceData(latestDo.getMeasPointId(), map);
        }
    }

    public MeasDataLatestVo doToMeasDataLatestVo(MeasDataLatestDo latestDo) {
        MeasDataLatestVo vo = new MeasDataLatestVo();
        vo.setId(latestDo.getId());
        vo.setMeasPointId(latestDo.getMeasPointId());
        vo.setMeasItemCode(latestDo.getMeasItemCode());
        vo.setMeasDataInfo(latestDo.getMeasDataInfo());
        vo.setGmtCreate(latestDo.getGmtCreate());
        vo.setGmtModified(latestDo.getGmtModified());
        this.updateVoRate(vo);
        return vo;
    }

    public void updateVoRate(MeasDataLatestVo vo) {
        GmDevMeterSynchronizerDo gmDevMeterSynchronizerDo = this.measDataLatestSynchronizerDao.getRate(vo.getMeasPointId());
        if (gmDevMeterSynchronizerDo != null) {
            vo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
            vo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
            vo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
        }
    }

    public void deleteByMeasPointIdAndMeasItemCode(Long measPointId, String measItemCode) {
        Map<String, MeasDataLatestVo> map = this.getEnsembleMeasLatest(measPointId);
        if (map != null && map.containsKey(measItemCode)) {
            map.remove(measItemCode);
        }
        this.replaceData(measPointId, map);
    }

    public List<MeasDataLatestVo> getMeasDataLatestVoListByMeasPointIdSetAndMeasItemCodeSet(Set<Long> newHashSet, Set<String> measItemCodeSet, Long gmtMeasDataLatest) {
        ArrayList<MeasDataLatestVo> list = new ArrayList<MeasDataLatestVo>();
        for (Long measPointId : newHashSet) {
            Map<String, MeasDataLatestVo> map = this.getEnsembleMeasLatest(measPointId);
            if (map == null) continue;
            map.forEach((key, value) -> {
                if (measItemCodeSet.contains(key)) {
                    if (gmtMeasDataLatest != null && gmtMeasDataLatest > 0L) {
                        if (value.getGmtModified() > gmtMeasDataLatest) {
                            list.add((MeasDataLatestVo)value);
                        }
                    } else {
                        list.add((MeasDataLatestVo)value);
                    }
                }
            });
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }
}

