package com.easesource.system.openservices.authmgmt.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.authmgmt.entity.SysRoleDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-17
 */
public interface SysRoleDao extends CrudMapper<SysRoleDo, Long> {

    /**
     * 通过应用标识、单位编号、角色编码获取系统角色
     * @param appId
     *          应用标识
     * @param orgNo
     *          单位编号
     * @param roleCode
     *          角色编码
     * @return
     *          系统角色
     */
    SysRoleDo getByAppIdAndOrgNoAndRoleCode(@Param("appId") Long appId, @Param("orgNo") String orgNo, @Param("roleCode") String roleCode);

    List<Long> getModuleIdListByRoleId(@Param("roleId") Long roleId);

    List<Long> getMenuItemIdListByRoleId(@Param("roleId") Long roleId);

    List<Long> getRoleIdListByUserId(@Param("userId") Long userId);

    List<SysRoleDo> getListByUserId(@Param("userId") Long userId);

}
