package com.easesource.system.openservices.authmgmt.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.authmgmt.entity.SysRoleDo;
import com.easesource.system.openservices.authmgmt.entity.SysRoleModuleDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-17
 */
public interface SysRoleModuleDao extends CrudMapper<SysRoleModuleDo, Long> {

    /**
     * 通过角色标识或功能组件标识删除系统角色功能组件关系
     * @param roleId
     *          角色标识
     * @param moduleId
     *          功能组件标识
     * @return
     *          系统角色功能组件关系
     */
    int deleteByRoleIdOrModuleId(@Param("roleId") Long roleId, @Param("moduleId") Long moduleId);

    /**
     * 通过角色标识和功能组件标识获取系统角色功能组件关系
     * @param roleId
     *          角色标识
     * @param moduleId
     *          功能组件标识
     * @return
     *          系统角色功能组件关系
     */
    SysRoleModuleDo getByRoleIdAndModuleId(@Param("roleId") Long roleId, @Param("moduleId") Long moduleId);

    List<SysRoleModuleDo> getListByRoleId(@Param("roleId") Long roleId);

    List<SysRoleModuleDo> getListByModuleId(@Param("moduleId") Long moduleId);

    List<SysRoleModuleDo> getListByUserId(@Param("userId") Long userId);

}
