package com.easesource.system.openservices.authmgmt.service.impl;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.authmgmt.dao.SysRoleDao;
import com.easesource.system.openservices.authmgmt.dao.SysRoleModuleDao;
import com.easesource.system.openservices.authmgmt.entity.SysRoleDo;
import com.easesource.system.openservices.authmgmt.entity.SysRoleModuleDo;
import com.easesource.system.openservices.authmgmt.request.*;
import com.easesource.system.openservices.authmgmt.response.*;
import com.easesource.system.openservices.authmgmt.service.SysRoleService;
import com.easesource.system.openservices.basemgmt.dao.SysAppDao;
import com.easesource.system.openservices.basemgmt.dao.SysModuleDao;
import com.easesource.system.openservices.basemgmt.entity.SysAppDo;
import com.easesource.system.openservices.basemgmt.entity.SysModuleDo;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.easesource.system.openservices.orgmgmt.dao.SysOrgDao;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgDo;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-27
 */
@Service
public class SysRoleServiceImpl extends AbstractBaseService implements SysRoleService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private SysAppDao sysAppDao;
    private SysOrgDao sysOrgDao;
    private SysRoleDao sysRoleDao;
    private SysModuleDao sysModuleDao;
    private SysRoleModuleDao sysRoleModuleDao;

    @Autowired
    public SysRoleServiceImpl(SysAppDao sysAppDao, SysOrgDao sysOrgDao, SysRoleDao sysRoleDao, SysModuleDao sysModuleDao, SysRoleModuleDao sysRoleModuleDao) {
        this.sysAppDao = sysAppDao;
        this.sysOrgDao = sysOrgDao;
        this.sysRoleDao = sysRoleDao;
        this.sysModuleDao = sysModuleDao;
        this.sysRoleModuleDao = sysRoleModuleDao;
    }

    @Override
    public SysRoleCreateResponse createSysRole(SysRoleCreateRequest sysRoleCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysRole >>>>>> ");
            logger.debug(" SysRoleCreateRequest             : " + JsonConvertUtils.convertToString(sysRoleCreateRequest));
        }
        SysRoleCreateResponse sysRoleCreateResponse = new SysRoleCreateResponse();
        sysRoleCreateResponse.setFailureDefault();
        if(sysRoleCreateRequest != null && sysRoleCreateRequest.getAppId() != null && sysRoleCreateRequest.getOrgNo() != null) {
            SysAppDo sysAppDo = sysAppDao.get(sysRoleCreateRequest.getAppId());
            SysOrgDo sysOrgDo = sysOrgDao.get(sysRoleCreateRequest.getOrgNo());
            SysRoleDo sysRoleDo = sysRoleDao.getByAppIdAndOrgNoAndRoleCode(sysRoleCreateRequest.getAppId(), sysRoleCreateRequest.getOrgNo(), sysRoleCreateRequest.getRoleCode());
            if(sysAppDo != null && sysOrgDo != null && sysRoleDo == null) {
                sysRoleDo = new SysRoleDo();
                sysRoleDo.setId(idGenerator.nextId());
                sysRoleDo.setAppId(sysRoleCreateRequest.getAppId());
                sysRoleDo.setOrgNo(sysRoleCreateRequest.getOrgNo());
                sysRoleDo.setRoleCode(StringUtils.trim(sysRoleCreateRequest.getRoleCode()));
                sysRoleDo.setRoleType(sysRoleCreateRequest.getRoleType());
                sysRoleDo.setRoleName(StringUtils.trim(sysRoleCreateRequest.getRoleName()));
                sysRoleDo.setRoleDesc(StringUtils.trimToEmpty(sysRoleCreateRequest.getRoleDesc()));
                sysRoleDo.setRoleLevel(sysRoleCreateRequest.getRoleLevel());
                sysRoleDo.setParentId(sysRoleCreateRequest.getParentId());
                sysRoleDo.setSortSn(sysRoleCreateRequest.getSortSn());
                sysRoleDo.setValid(true);
                sysRoleDo.setCreator(sysRoleCreateRequest.getCreator());
                sysRoleDo.setGmtCreate(System.currentTimeMillis());
                sysRoleDo.setModifier(sysRoleCreateRequest.getCreator());
                sysRoleDo.setGmtModified(System.currentTimeMillis());
                sysRoleDo.setInvalider("");
                sysRoleDo.setGmtInvalid(0L);
                sysRoleDo.setVersion(1);
                int result = sysRoleDao.insert(sysRoleDo);
                if(result > 0) {
                    sysRoleCreateResponse.setSuccess();
                    sysRoleCreateResponse.setSysRole(sysRoleDao.get(sysRoleDo.getId()));
                    if(sysRoleCreateRequest.getModuleIdList() != null && sysRoleCreateRequest.getModuleIdList().size() > 0) {
                        int i = 1;
                        for(Long moduleId : sysRoleCreateRequest.getModuleIdList()) {
                            if(moduleId != null && moduleId > 0L) {
                                SysRoleModuleDo sysRoleModuleDo = new SysRoleModuleDo();
                                sysRoleModuleDo.setId(idGenerator.nextId());
                                sysRoleModuleDo.setRoleId(sysRoleDo.getId());
                                sysRoleModuleDo.setModuleId(moduleId);
                                sysRoleModuleDo.setSortSn(i++);
                                sysRoleModuleDo.setValid(false);
                                sysRoleModuleDo.setCreator(sysRoleCreateRequest.getCreator());
                                sysRoleModuleDo.setGmtCreate(System.currentTimeMillis());
                                sysRoleModuleDo.setModifier(sysRoleCreateRequest.getCreator());
                                sysRoleModuleDo.setGmtModified(System.currentTimeMillis());
                                sysRoleModuleDo.setInvalider("");
                                sysRoleModuleDo.setGmtInvalid(0L);
                                sysRoleModuleDo.setVersion(1);
                                sysRoleModuleDao.insert(sysRoleModuleDo);
                            }
                        }
                    }
                }
            }
            else {
                if(sysAppDo == null) {
                    sysRoleCreateResponse.setFailure("SYS_APP_NOTEXIST", "系统应用不存在");
                }
                if(sysOrgDo == null) {
                    sysRoleCreateResponse.setFailure("SYS_ORG_NOTEXIST", "系统单位不存在");
                }
                if(sysRoleDo != null) {
                    sysRoleCreateResponse.setFailure("SYS_ROLE_CODE_ISEXIST", "系统角色编码已存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleCreateResponse        : " + JsonConvertUtils.convertToString(sysRoleCreateResponse));
            logger.debug(" <<<<<<< end createSysRole <<<<<<< ");
        }
        return sysRoleCreateResponse;
    }

    @Override
    public SysRoleModifyResponse modifySysRole(SysRoleModifyRequest sysRoleModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysRole >>>>>> ");
            logger.debug(" SysRoleModifyRequest         : " + JsonConvertUtils.convertToString(sysRoleModifyRequest));
        }
        SysRoleModifyResponse sysRoleModifyResponse = new SysRoleModifyResponse();
        sysRoleModifyResponse.setFailureDefault();
        if(sysRoleModifyRequest != null && sysRoleModifyRequest.getRoleId() != null) {
            SysRoleDo sysRoleDo = sysRoleDao.get(sysRoleModifyRequest.getRoleId());
            if(sysRoleDo == null) {
                sysRoleModifyResponse.setFailure("SYS_ROLE_NOTEXIST", "该系统角色不存在");
            }
            else {
                if(ObjectUtils.isNotNull(sysRoleModifyRequest.getRoleType())) {
                    sysRoleDo.setRoleType(sysRoleModifyRequest.getRoleType());
                }
                sysRoleDo.setRoleName(StringUtils.trim(sysRoleModifyRequest.getRoleName()));
                sysRoleDo.setRoleDesc(StringUtils.trimToEmpty(sysRoleModifyRequest.getRoleDesc()));
                if(ObjectUtils.isNotNull(sysRoleModifyRequest.getSortSn())) {
                    sysRoleDo.setSortSn(sysRoleModifyRequest.getSortSn());
                }
                sysRoleDo.setModifier(sysRoleModifyRequest.getModifier());
                sysRoleDo.setGmtModified(System.currentTimeMillis());
                int result = sysRoleDao.update(sysRoleDo);
                if(result > 0) {
                    sysRoleModifyResponse.setSuccess();
                    sysRoleModifyResponse.setSysRole(sysRoleDao.get(sysRoleDo.getId()));
                    if(sysRoleModifyRequest.getModuleIdList() != null && sysRoleModifyRequest.getModuleIdList().size() > 0) {
                        int i = 1;
                        for(Long moduleId : sysRoleModifyRequest.getModuleIdList()) {
                            if(moduleId != null && moduleId > 0L) {
                                SysRoleModuleDo sysRoleModuleDo = new SysRoleModuleDo();
                                sysRoleModuleDo.setId(idGenerator.nextId());
                                sysRoleModuleDo.setRoleId(sysRoleDo.getId());
                                sysRoleModuleDo.setModuleId(moduleId);
                                sysRoleModuleDo.setSortSn(i++);
                                sysRoleModuleDo.setValid(false);
                                sysRoleModuleDo.setCreator(sysRoleModifyRequest.getModifier());
                                sysRoleModuleDo.setGmtCreate(System.currentTimeMillis());
                                sysRoleModuleDo.setModifier(sysRoleModifyRequest.getModifier());
                                sysRoleModuleDo.setGmtModified(System.currentTimeMillis());
                                sysRoleModuleDo.setInvalider("");
                                sysRoleModuleDo.setGmtInvalid(0L);
                                sysRoleModuleDo.setVersion(1);
                                sysRoleModuleDao.insert(sysRoleModuleDo);
                            }
                        }
                    }
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleModifyResponse        : " + JsonConvertUtils.convertToString(sysRoleModifyResponse));
            logger.debug(" <<<<<<< end modifySysRole <<<<<<< ");
        }
        return sysRoleModifyResponse;
    }

    @Override
    public SysRoleInvalidateResponse invalidateSysRole(SysRoleInvalidateRequest sysRoleInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysRole >>>>>> ");
            logger.debug(" SysRoleInvalidateRequest     : " + JsonConvertUtils.convertToString(sysRoleInvalidateRequest));
        }
        SysRoleInvalidateResponse sysRoleInvalidateResponse = new SysRoleInvalidateResponse();
        sysRoleInvalidateResponse.setFailureDefault();
        SysRoleDo sysRoleDo = null;
        if(sysRoleInvalidateRequest != null && sysRoleInvalidateRequest.getRoleId() != null) {
            sysRoleDo = sysRoleDao.get(sysRoleInvalidateRequest.getRoleId());
        }
        if(sysRoleDo == null) {
            sysRoleInvalidateResponse.setFailure("SYS_ROLE_NOTEXIST", "该系统角色不存在");
        }
        else {
            sysRoleDo.setValid(false);
            sysRoleDo.setInvalider(sysRoleInvalidateRequest.getInvalider());
            sysRoleDo.setGmtInvalid(System.currentTimeMillis());
            int result = sysRoleDao.update(sysRoleDo);
            if(result > 0) {
                sysRoleInvalidateResponse.setSuccess();
                sysRoleInvalidateResponse.setSysRole(sysRoleDao.get(sysRoleDo.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleInvalidateResponse    : " + JsonConvertUtils.convertToString(sysRoleInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysRole <<<<<<< ");
        }
        return sysRoleInvalidateResponse;
    }

    @Override
    public SysRoleDeleteResponse deleteSysRole(SysRoleDeleteRequest sysRoleDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysRole >>>>>> ");
            logger.debug(" SysRoleDeleteRequest         : " + JsonConvertUtils.convertToString(sysRoleDeleteRequest));
        }
        SysRoleDeleteResponse sysRoleDeleteResponse = new SysRoleDeleteResponse();
        sysRoleDeleteResponse.setFailureDefault();
        SysRoleDo sysRoleDo = null;
        if(sysRoleDeleteRequest != null && sysRoleDeleteRequest.getRoleId() != null) {
            sysRoleDo = sysRoleDao.get(sysRoleDeleteRequest.getRoleId());
        }
        if(sysRoleDo == null) {
            sysRoleDeleteResponse.setFailure("SYS_ROLE_NOTEXIST", "该系统角色不存在");
        }
        else {
            int result = sysRoleDao.delete(sysRoleDo);
            if(result > 0) {
                sysRoleDeleteResponse.setSuccess();
                sysRoleDeleteResponse.setSysRole(sysRoleDo);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleDeleteResponse            : " + JsonConvertUtils.convertToString(sysRoleDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysRole <<<<<<< ");
        }
        return sysRoleDeleteResponse;
    }

    @Override
    public SysRoleGetResponse getSysRole(SysRoleGetRequest sysRoleGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysRole >>>>>> ");
            logger.debug(" SysRoleGetRequest            : " + JsonConvertUtils.convertToString(sysRoleGetRequest));
        }
        SysRoleGetResponse sysRoleGetResponse = new SysRoleGetResponse();
        sysRoleGetResponse.setFailureDefault();
        SysRoleDo sysRoleDo = null;
        if(sysRoleGetRequest != null && sysRoleGetRequest.getRoleId() != null) {
            sysRoleDo = sysRoleDao.get(sysRoleGetRequest.getRoleId());
        }
        else if(sysRoleGetRequest != null && sysRoleGetRequest.getAppId() != null && StringUtils.isNotBlank(sysRoleGetRequest.getOrgNo()) && StringUtils.isNotBlank(sysRoleGetRequest.getRoleCode())) {
            sysRoleDo = sysRoleDao.getByAppIdAndOrgNoAndRoleCode(sysRoleGetRequest.getAppId(), sysRoleGetRequest.getOrgNo(), sysRoleGetRequest.getRoleCode());
        }
        if(sysRoleDo == null) {
            sysRoleGetResponse.setFailure("SYS_ROLE_NOTEXIST", "该系统角色不存在");
        }
        else {
            sysRoleGetResponse.setSuccess();
            sysRoleGetResponse.setSysRole(sysRoleDo);
            sysRoleGetResponse.setModuleIdList(sysRoleDao.getModuleIdListByRoleId(sysRoleDo.getId()));
            sysRoleGetResponse.setMenuItemIdList(sysRoleDao.getMenuItemIdListByRoleId(sysRoleDo.getId()));
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleGetResponse           : " + JsonConvertUtils.convertToString(sysRoleGetResponse));
            logger.debug(" <<<<<<< end getSysRole <<<<<<< ");
        }
        return sysRoleGetResponse;
    }

    @Override
    public SysRoleQueryResponse querySysRole(SysRoleQueryRequest sysRoleQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysRole >>>>>> ");
            logger.debug(" SysRoleQueryRequest          : " + JsonConvertUtils.convertToString(sysRoleQueryRequest));
        }
        SysRoleQueryResponse sysRoleQueryResponse = new SysRoleQueryResponse();
        sysRoleQueryResponse.setFailureDefault();
        if(sysRoleQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("appId", sysRoleQueryRequest.getAppId());
            params.put("orgNo", sysRoleQueryRequest.getOrgNo());
            params.put("roleCode", sysRoleQueryRequest.getRoleCode());
            params.put("roleType", sysRoleQueryRequest.getRoleType());
            params.put("roleName", sysRoleQueryRequest.getRoleName());
            params.put("roleDesc", sysRoleQueryRequest.getRoleDesc());
            params.put("roleLevel", sysRoleQueryRequest.getRoleLevel());
            params.put("parentId", sysRoleQueryRequest.getParentId());
            params.put("valid", sysRoleQueryRequest.getIsValid());
            int sysRoleDoCount = sysRoleDao.getCount(params);
            List<SysRoleDo> sysRoleDoList = sysRoleDao.getList(params, new Sorter("sort_sn", ""), new Pager(sysRoleQueryRequest.getPageNumber(), sysRoleQueryRequest.getPageSize()));
            sysRoleQueryResponse.setSuccess();
            sysRoleQueryResponse.setSysRoleCount(sysRoleDoCount);
            sysRoleQueryResponse.setSysRoleList(sysRoleDoList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleQueryResponse         : " + JsonConvertUtils.convertToString(sysRoleQueryResponse));
            logger.debug(" <<<<<<< end querySysRole <<<<<<< ");
        }
        return sysRoleQueryResponse;
    }

    @Override
    public SysRoleModuleCreateResponse createSysRoleModule(SysRoleModuleCreateRequest sysRoleModuleCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysRoleModule >>>>>> ");
            logger.debug(" SysRoleModuleCreateRequest   : " + JsonConvertUtils.convertToString(sysRoleModuleCreateRequest));
        }
        SysRoleModuleCreateResponse sysRoleModuleCreateResponse = new SysRoleModuleCreateResponse();
        sysRoleModuleCreateResponse.setFailureDefault();
        if(sysRoleModuleCreateRequest != null && sysRoleModuleCreateRequest.getRoleId() != null && sysRoleModuleCreateRequest.getModuleId() != null) {
            SysRoleDo sysRoleDo = sysRoleDao.get(sysRoleModuleCreateRequest.getRoleId());
            SysModuleDo sysModuleDo = sysModuleDao.get(sysRoleModuleCreateRequest.getModuleId());
            SysRoleModuleDo sysRoleModuleDo = sysRoleModuleDao.getByRoleIdAndModuleId(sysRoleModuleCreateRequest.getRoleId(), sysRoleModuleCreateRequest.getModuleId());
            if(sysRoleDo != null && sysModuleDo != null && sysRoleModuleDo == null) {
                sysRoleModuleDo = new SysRoleModuleDo();
                sysRoleModuleDo.setId(idGenerator.nextId());
                sysRoleModuleDo.setRoleId(sysRoleModuleCreateRequest.getRoleId());
                sysRoleModuleDo.setModuleId(sysRoleModuleCreateRequest.getModuleId());
                sysRoleModuleDo.setSortSn(sysRoleModuleCreateRequest.getSortSn());
                sysRoleModuleDo.setValid(true);
                sysRoleModuleDo.setCreator(sysRoleModuleCreateRequest.getCreator());
                sysRoleModuleDo.setGmtCreate(System.currentTimeMillis());
                sysRoleModuleDo.setModifier(sysRoleModuleCreateRequest.getCreator());
                sysRoleModuleDo.setGmtModified(System.currentTimeMillis());
                sysRoleModuleDo.setInvalider("");
                sysRoleModuleDo.setGmtInvalid(0L);
                sysRoleModuleDo.setVersion(1);
                int result = sysRoleModuleDao.insert(sysRoleModuleDo);
                if(result > 0) {
                    sysRoleModuleCreateResponse.setSuccess();
                    sysRoleModuleCreateResponse.setSysRoleModule(sysRoleModuleDao.get(sysRoleModuleDo.getId()));
                    sysRoleModuleCreateResponse.setSysRole(sysRoleDo);
                    sysRoleModuleCreateResponse.setSysModule(sysModuleDo);
                }
            }
            else {
                if(sysRoleDo == null) {
                    sysRoleModuleCreateResponse.setFailure("SYS_ROLE_NOTEXIST", "系统角色不存在");
                }
                if(sysModuleDo == null) {
                    sysRoleModuleCreateResponse.setFailure("SYS_MODULE_NOTEXIST", "系统功能组件不存在");
                }
                if(sysRoleModuleDo != null) {
                    sysRoleModuleCreateResponse.setFailure("SYS_ROLE_MODULE_RELA_ISEXIST", "系统角色功能组件关系已存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleModuleCreateResponse  : " + JsonConvertUtils.convertToString(sysRoleModuleCreateResponse));
            logger.debug(" <<<<<<< end createSysRoleModule <<<<<<< ");
        }
        return sysRoleModuleCreateResponse;
    }

    @Override
    public SysRoleModuleModifyResponse modifySysRoleModule(SysRoleModuleModifyRequest sysRoleModuleModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysRoleModule >>>>>> ");
            logger.debug(" SysRoleModuleModifyRequest   : " + JsonConvertUtils.convertToString(sysRoleModuleModifyRequest));
        }
        SysRoleModuleModifyResponse sysRoleModuleModifyResponse = new SysRoleModuleModifyResponse();
        sysRoleModuleModifyResponse.setFailureDefault();
        if(sysRoleModuleModifyRequest != null && sysRoleModuleModifyRequest.getRoleModuleId() != null
            && sysRoleModuleModifyRequest.getRoleId() != null && sysRoleModuleModifyRequest.getModuleId() != null) {
            SysRoleModuleDo sysRoleModuleDo = sysRoleModuleDao.get(sysRoleModuleModifyRequest.getRoleModuleId());
            if(sysRoleModuleDo == null) {
                sysRoleModuleModifyResponse.setFailure("SYS_ROLE_MODULE_RELA_NOTEXIST", "系统角色功能组件关系不存在");
            }
            else {
                SysRoleDo sysRoleDo = sysRoleDao.get(sysRoleModuleModifyRequest.getRoleId());
                if(sysRoleDo == null) {
                    sysRoleModuleModifyResponse.setFailure("SYS_ROLE_NOTEXIST", "该系统应用不存在");
                }
                SysModuleDo sysModuleDo = sysModuleDao.get(sysRoleModuleModifyRequest.getModuleId());
                if(sysModuleDo == null) {
                    sysRoleModuleModifyResponse.setFailure("SYS_MODULE_NOTEXIST", "该系统功能组件不存在");
                }
                if(ObjectUtils.notEqual(sysRoleModuleDo.getRoleId(), sysRoleModuleModifyRequest.getRoleId())
                    || ObjectUtils.notEqual(sysRoleModuleDo.getModuleId(), sysRoleModuleModifyRequest.getModuleId())) {
                    SysRoleModuleDo sysRoleModuleDoOther = sysRoleModuleDao.getByRoleIdAndModuleId(sysRoleModuleModifyRequest.getRoleId(), sysRoleModuleModifyRequest.getModuleId());
                    if(sysRoleModuleDoOther != null) {
                        sysRoleModuleModifyResponse.setFailure("SYS_ROLE_MODULE_RELA_ISEXIST", "修改后系统角色功能组件关系已存在");
                    }
                }
                sysRoleModuleDo.setRoleId(sysRoleModuleModifyRequest.getRoleId());
                sysRoleModuleDo.setModuleId(sysRoleModuleModifyRequest.getModuleId());
                sysRoleModuleDo.setSortSn(sysRoleModuleModifyRequest.getSortSn());
                sysRoleModuleDo.setModifier(sysRoleModuleModifyRequest.getModifier());
                sysRoleModuleDo.setGmtModified(System.currentTimeMillis());
                int result = sysRoleModuleDao.update(sysRoleModuleDo);
                if(result > 0) {
                    sysRoleModuleModifyResponse.setSuccess();
                    sysRoleModuleModifyResponse.setSysRoleModule(sysRoleModuleDao.get(sysRoleModuleDo.getId()));
                    sysRoleModuleModifyResponse.setSysRole(sysRoleDo);
                    sysRoleModuleModifyResponse.setSysModule(sysModuleDo);
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleModuleModifyResponse  : " + JsonConvertUtils.convertToString(sysRoleModuleModifyResponse));
            logger.debug(" <<<<<<< end modifySysRoleModule <<<<<<< ");
        }
        return sysRoleModuleModifyResponse;
    }

    @Override
    public SysRoleModuleInvalidateResponse invalidateSysRoleModule(SysRoleModuleInvalidateRequest sysRoleModuleInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysRoleModule >>>>>> ");
            logger.debug(" SysRoleModuleInvalidateRequest   : " + JsonConvertUtils.convertToString(sysRoleModuleInvalidateRequest));
        }
        SysRoleModuleInvalidateResponse sysRoleModuleInvalidateResponse = new SysRoleModuleInvalidateResponse();
        sysRoleModuleInvalidateResponse.setFailureDefault();
        SysRoleModuleDo sysRoleModuleDo = null;
        if(sysRoleModuleInvalidateRequest != null && sysRoleModuleInvalidateRequest.getRoleModuleId() != null) {
            sysRoleModuleDo = sysRoleModuleDao.get(sysRoleModuleInvalidateRequest.getRoleModuleId());
        }
        else if(sysRoleModuleInvalidateRequest != null && sysRoleModuleInvalidateRequest.getRoleId() != null && sysRoleModuleInvalidateRequest.getModuleId() != null) {
            sysRoleModuleDo = sysRoleModuleDao.getByRoleIdAndModuleId(sysRoleModuleInvalidateRequest.getRoleId(), sysRoleModuleInvalidateRequest.getModuleId());
        }
        if(sysRoleModuleDo == null) {
            sysRoleModuleInvalidateResponse.setFailure("SYS_ROLE_MODULE_RELA_NOTEXIST", "系统角色功能组件关系不存在");
        }
        else {
            sysRoleModuleDo.setValid(false);
            sysRoleModuleDo.setInvalider(sysRoleModuleInvalidateRequest.getInvalider());
            sysRoleModuleDo.setGmtInvalid(System.currentTimeMillis());
            int result = sysRoleModuleDao.update(sysRoleModuleDo);
            if(result > 0) {
                sysRoleModuleInvalidateResponse.setSuccess();
                sysRoleModuleInvalidateResponse.setSysRoleModule(sysRoleModuleDao.get(sysRoleModuleDo.getId()));
                sysRoleModuleInvalidateResponse.setSysRole(sysRoleDao.get(sysRoleModuleDo.getRoleId()));
                sysRoleModuleInvalidateResponse.setSysModule(sysModuleDao.get(sysRoleModuleDo.getModuleId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleModuleInvalidateResponse  : " + JsonConvertUtils.convertToString(sysRoleModuleInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysRoleModule <<<<<<< ");
        }
        return sysRoleModuleInvalidateResponse;
    }

    @Override
    public SysRoleModuleDeleteResponse deleteSysRoleModule(SysRoleModuleDeleteRequest sysRoleModuleDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysRoleModule >>>>>> ");
            logger.debug(" SysRoleModuleDeleteRequest   : " + JsonConvertUtils.convertToString(sysRoleModuleDeleteRequest));
        }
        SysRoleModuleDeleteResponse sysRoleModuleDeleteResponse = new SysRoleModuleDeleteResponse();
        sysRoleModuleDeleteResponse.setFailureDefault();
        SysRoleModuleDo sysRoleModuleDo = null;
        if(sysRoleModuleDeleteRequest != null && sysRoleModuleDeleteRequest.getRoleId() != null && sysRoleModuleDeleteRequest.getModuleId() != null) {
            sysRoleModuleDo = sysRoleModuleDao.getByRoleIdAndModuleId(sysRoleModuleDeleteRequest.getRoleId(), sysRoleModuleDeleteRequest.getModuleId());
            if(sysRoleModuleDo == null) {
                sysRoleModuleDeleteResponse.setFailure("SYS_ROLE_MODULE_RELA_NOTEXIST", "系统角色功能组件关系不存在");
            }
            else {
                int result = sysRoleModuleDao.delete(sysRoleModuleDo);
                if(result > 0) {
                    sysRoleModuleDeleteResponse.setSuccess();
                    sysRoleModuleDeleteResponse.setSysRoleModule(sysRoleModuleDo);
                }
            }
        }
        else if(sysRoleModuleDeleteRequest != null && (sysRoleModuleDeleteRequest.getRoleId() != null || sysRoleModuleDeleteRequest.getModuleId() != null)) {
            int result = sysRoleModuleDao.deleteByRoleIdOrModuleId(sysRoleModuleDeleteRequest.getRoleId(), sysRoleModuleDeleteRequest.getModuleId());
            if(logger.isDebugEnabled()) {
                logger.debug(String.format("deleteByRoleIdOrModuleId %s, %d ", result > 0 ? "success" : "failure", result));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleModuleDeleteResponse  : " + JsonConvertUtils.convertToString(sysRoleModuleDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysRoleModule <<<<<<< ");
        }
        return sysRoleModuleDeleteResponse;
    }

    @Override
    public SysRoleModuleGetResponse getSysRoleModule(SysRoleModuleGetRequest sysRoleModuleGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysRoleModule >>>>>> ");
            logger.debug(" SysRoleModuleGetRequest      : " + JsonConvertUtils.convertToString(sysRoleModuleGetRequest));
        }
        SysRoleModuleGetResponse sysRoleModuleGetResponse = new SysRoleModuleGetResponse();
        sysRoleModuleGetResponse.setFailureDefault();
        SysRoleModuleDo sysRoleModuleDo = null;
        if(sysRoleModuleGetRequest != null && sysRoleModuleGetRequest.getRoleModuleId() != null) {
            sysRoleModuleDo = sysRoleModuleDao.get(sysRoleModuleGetRequest.getRoleModuleId());
        }
        else if(sysRoleModuleGetRequest != null && sysRoleModuleGetRequest.getRoleId() != null && sysRoleModuleGetRequest.getModuleId() != null) {
            sysRoleModuleDo = sysRoleModuleDao.getByRoleIdAndModuleId(sysRoleModuleGetRequest.getRoleId(), sysRoleModuleGetRequest.getModuleId());
        }
        if(sysRoleModuleDo == null) {
            sysRoleModuleGetResponse.setFailure("SYS_ROLE_MODULE_RELA_NOTEXIST", "系统角色功能组件关系不存在");
        }
        else {
            sysRoleModuleGetResponse.setSuccess();
            sysRoleModuleGetResponse.setSysRoleModule(sysRoleModuleDo);
            sysRoleModuleGetResponse.setSysRole(sysRoleDao.get(sysRoleModuleDo.getRoleId()));
            sysRoleModuleGetResponse.setSysModule(sysModuleDao.get(sysRoleModuleDo.getModuleId()));
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleModuleGetResponse     : " + JsonConvertUtils.convertToString(sysRoleModuleGetResponse));
            logger.debug(" <<<<<<< end getSysRoleModule <<<<<<< ");
        }
        return sysRoleModuleGetResponse;
    }

    @Override
    public SysRoleModuleQueryResponse querySysRoleModule(SysRoleModuleQueryRequest sysRoleModuleQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysRoleModule >>>>>> ");
            logger.debug(" SysRoleModuleQueryRequest    : " + JsonConvertUtils.convertToString(sysRoleModuleQueryRequest));
        }
        SysRoleModuleQueryResponse sysRoleModuleQueryResponse = new SysRoleModuleQueryResponse();
        sysRoleModuleQueryResponse.setFailureDefault();
        if(sysRoleModuleQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("roleId", sysRoleModuleQueryRequest.getRoleId());
            params.put("roleCode", sysRoleModuleQueryRequest.getRoleCode());
            params.put("moduleId", sysRoleModuleQueryRequest.getModuleId());
            params.put("moduleCode", sysRoleModuleQueryRequest.getModuleCode());
            params.put("valid", sysRoleModuleQueryRequest.getIsValid());
            int sysRoleModuleDoCount = sysRoleModuleDao.getCount(params);
            List<SysRoleModuleDo> sysRoleModuleDoList = sysRoleModuleDao.getList(params, new Sorter("sort_sn", ""), new Pager(sysRoleModuleQueryRequest.getPageNumber(), sysRoleModuleQueryRequest.getPageSize()));
            sysRoleModuleQueryResponse.setSuccess();
            sysRoleModuleQueryResponse.setSysRoleModuleCount(sysRoleModuleDoCount);
            sysRoleModuleQueryResponse.setSysRoleModuleList(sysRoleModuleDoList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysRoleModuleQueryResponse   : " + JsonConvertUtils.convertToString(sysRoleModuleQueryResponse));
            logger.debug(" <<<<<<< end querySysRoleModule <<<<<<< ");
        }
        return sysRoleModuleQueryResponse;
    }

}
