package com.easesource.system.openservices.basemgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.basemgmt.entity.SysCodeDo;
import com.easesource.system.openservices.basemgmt.entity.SysCodeVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
public interface SysCodeDao extends CrudMapper<SysCodeDo, Long> {

    /**
     * 通过代码分类编号和代码值获取系统代码
     *
     * @param codeSortNo
     *          代码分类编号
     * @param codeValue
     *          代码值
     * @return
     *          系统代码
     */
    SysCodeDo getByCodeSortNoAndCodeValue(@Param("codeSortNo") String codeSortNo, @Param("codeValue") String codeValue);

    /**
     * 通过代码分类编号和代码值获取系统代码名称
     *
     * @param codeSortNo
     *          代码分类编号
     * @param codeValue
     *          代码值
     * @return
     *          系统代码名称
     */
    String getNameByCodeSortNoAndCodeValue(@Param("codeSortNo") String codeSortNo, @Param("codeValue") String codeValue);

    /**
     * 通过代码标识获取系统代码视图
     *
     * @param id
     *          代码标识
     * @return  系统代码视图
     */
    SysCodeVo getSysCodeVo(Long id);

    /**
     * 通过代码分类编号和代码值获取系统代码视图
     *
     * @param codeSortNo
     *          代码分类编号
     * @param codeValue
     *          代码值
     * @return
     *          系统代码视图
     */
    SysCodeVo getSysCodeVoByCodeSortNoAndCodeValue(@Param("codeSortNo") String codeSortNo, @Param("codeValue") String codeValue);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysCodeVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysCodeVo> getSysCodeVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
