package com.easesource.system.openservices.basemgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.basemgmt.entity.SysMenuItemDo;
import com.easesource.system.openservices.basemgmt.entity.SysMenuItemVo;
import com.easesource.system.openservices.basemgmt.entity.SysMenuTreeVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-17
 */
public interface SysMenuItemDao extends CrudMapper<SysMenuItemDo, Long> {

    /**
     * 通过菜单项编码获取系统菜单项实体类
     * @param menuItemCode
     *          菜单项编码
     * @return
     *          系统菜单项实体类
     */
    SysMenuItemDo getByMenuItemCode(@Param("menuItemCode") String menuItemCode);

    /**
     * 通过菜单项标识获取系统菜单项视图
     * @param id
     *          菜单项标识
     * @return
     *          系统菜单项视图
     */
    SysMenuItemVo getSysMenuItemVo(Long id);

    /**
     * 通过菜单树编码获取系统菜单树视图
     * @param menuItemCode
     *          菜单树编码
     * @return
     *          系统菜单树视图
     */
    SysMenuItemVo getSysMenuItemVoByMenuItemCode(@Param("menuItemCode") String menuItemCode);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysMenuItemVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysMenuItemVo> getSysMenuItemVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
