package com.easesource.system.openservices.basemgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.basemgmt.entity.SysMenuTreeDo;
import com.easesource.system.openservices.basemgmt.entity.SysMenuTreeVo;
import com.easesource.system.openservices.basemgmt.entity.SysModuleVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-17
 */
public interface SysMenuTreeDao extends CrudMapper<SysMenuTreeDo, Long> {

    /**
     * 通过菜单树编码获取系统菜单树实体类
     * @param menuTreeCode
     *          菜单树编码
     * @return
     *          系统菜单树实体类
     */
    SysMenuTreeDo getByMenuTreeCode(@Param("menuTreeCode") String menuTreeCode);

    /**
     * 菜单树标识
     * @param id
     * @return
     */
    SysMenuTreeVo getSysMenuTreeVo(Long id);

    /**
     * 通过菜单树编码获取系统菜单树视图
     * @param menuTreeCode
     *          菜单树编码
     * @return
     *          系统菜单树视图
     */
    SysMenuTreeVo getSysMenuTreeVoByMenuTreeCode(@Param("menuTreeCode") String menuTreeCode);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysMenuTreeVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysMenuTreeVo> getSysMenuTreeVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
