package com.easesource.system.openservices.basemgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.basemgmt.entity.SysModuleDo;
import com.easesource.system.openservices.basemgmt.entity.SysModuleVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
public interface SysModuleDao extends CrudMapper<SysModuleDo, Long> {

    /**
     * 通过功能组件编码获取系统功能组件实体类
     * @param moduleCode
     *          功能组件编码
     * @return
     *          系统功能组件实体类
     */
    SysModuleDo getByModuleCode(@Param("moduleCode") String moduleCode);

    /**
     * 通过功能组件标识获取系统功能组件视图
     *
     * @param id
     *          功能组件标识
     * @return  系统功能组件视图
     */
    SysModuleVo getSysModuleVo(Long id);

    /**
     * 通过功能组件编码获取系统功能组件视图
     *
     * @param moduleCode
     *          功能组件编码
     * @return  系统功能组件视图
     */
    SysModuleVo getSysModuleVoByModuleCode(@Param("moduleCode") String moduleCode);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysModuleVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysModuleVo> getSysModuleVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
