package com.easesource.system.openservices.basemgmt.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.basemgmt.entity.SysParamIndivalueDo;
import org.apache.ibatis.annotations.Param;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-19
 */
public interface SysParamIndivalueDao extends CrudMapper<SysParamIndivalueDo, Long> {

    /**
     * 通过参数标识和单位编号获取系统参数个性化值
     * @param paramId
     *          参数标识
     * @param orgNo
     *          单位编号
     * @return
     *          系统参数个性化值
     */
    SysParamIndivalueDo getByParamIdAndOrgNo(@Param("paramId") String paramId, @Param("orgNo") String orgNo);

    /**
     * 通过参数编号和单位编号获取系统参数个性化值
     * @param paramNo
     *          参数编号
     * @param orgNo
     *          单位编号
     * @return
     *          系统参数个性化值
     */
    SysParamIndivalueDo getByParamNoAndOrgNo(@Param("paramNo") String paramNo, @Param("orgNo") String orgNo);

}
