package com.easesource.system.openservices.basemgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.basemgmt.dao.SysAppDao;
import com.easesource.system.openservices.basemgmt.entity.SysAppDo;
import com.easesource.system.openservices.basemgmt.request.*;
import com.easesource.system.openservices.basemgmt.response.*;
import com.easesource.system.openservices.basemgmt.service.SysAppService;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysAppServiceImpl extends AbstractBaseService implements SysAppService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final SysAppDao sysAppDao;

    @Autowired
    public SysAppServiceImpl(SysAppDao sysAppDao) {
        this.sysAppDao = sysAppDao;
    }

    @Override
    public SysAppCreateResponse createSysApp(SysAppCreateRequest sysAppCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysApp >>>>>> ");
            logger.debug(" SysAppCreateRequest              : " + JsonConvertUtils.convertToString(sysAppCreateRequest));
        }
        SysAppCreateResponse sysAppCreateResponse = new SysAppCreateResponse();
        sysAppCreateResponse.setFailureDefault();
        if(sysAppCreateRequest != null && StringUtils.isNotBlank(sysAppCreateRequest.getAppNo())) {
            String appNo = StringUtils.trim(sysAppCreateRequest.getAppNo());
            SysAppDo sysAppDo = sysAppDao.getByAppNo(appNo);
            if(sysAppDo == null) {
                sysAppDo = new SysAppDo();
                sysAppDo.setId(idGenerator.nextId());
                sysAppDo.setAppNo(appNo);
                sysAppDo.setAppType(sysAppCreateRequest.getAppType());
                sysAppDo.setAppName(StringUtils.trim(sysAppCreateRequest.getAppName()));
                sysAppDo.setAppDesc(StringUtils.trim(sysAppCreateRequest.getAppDesc()));
                sysAppDo.setAppConf(StringUtils.trim(sysAppCreateRequest.getAppConf()));
                sysAppDo.setSortSn(sysAppCreateRequest.getSortSn());
                sysAppDo.setValid(true);
                sysAppDo.setCreator(sysAppCreateRequest.getCreator());
                sysAppDo.setGmtCreate(System.currentTimeMillis());
                sysAppDo.setModifier(sysAppCreateRequest.getCreator());
                sysAppDo.setGmtModified(System.currentTimeMillis());
                sysAppDo.setInvalider("");
                sysAppDo.setGmtInvalid(0L);
                sysAppDo.setVersion(1);
                int result = sysAppDao.insert(sysAppDo);
                if(result > 0) {
                    sysAppCreateResponse.setSuccess();
                    sysAppCreateResponse.setSysApp(sysAppDao.get(sysAppDo.getId()));
                }
            }
            else {
                sysAppCreateResponse.setFailure("SYS_APP_NO_ISEXIST", "应用编号已存在");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysAppCreateResponse            : " + JsonConvertUtils.convertToString(sysAppCreateResponse));
            logger.debug(" <<<<<<< end createSysApp <<<<<<< ");
        }
        return sysAppCreateResponse;
    }

    @Override
    public SysAppModifyResponse modifySysApp(SysAppModifyRequest sysAppModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysApp >>>>>> ");
            logger.debug(" SysAppModifyRequest          : " + JsonConvertUtils.convertToString(sysAppModifyRequest));
        }
        SysAppModifyResponse sysAppModifyResponse = new SysAppModifyResponse();
        sysAppModifyResponse.setFailureDefault();
        if(sysAppModifyRequest != null && sysAppModifyRequest.getAppId() != null && StringUtils.isNotBlank(sysAppModifyRequest.getAppNo())) {
            SysAppDo sysAppDo = sysAppDao.get(sysAppModifyRequest.getAppId());
            if(sysAppDo == null) {
                sysAppModifyResponse.setFailure("SYS_APP_NO_NOTEXIST", "该系统应用不存在");
            }
            else {
                if(StringUtils.isNotBlank(sysAppModifyRequest.getAppNo())) {
                    sysAppDo.setAppNo(StringUtils.trim(sysAppModifyRequest.getAppNo()));
                }
                sysAppDo.setAppType(sysAppModifyRequest.getAppType());
                if(StringUtils.isNotBlank(sysAppModifyRequest.getAppName())) {
                    sysAppDo.setAppName(StringUtils.trim(sysAppModifyRequest.getAppName()));
                }
                if(StringUtils.isNotBlank(sysAppModifyRequest.getAppDesc())) {
                    sysAppDo.setAppDesc(StringUtils.trim(sysAppModifyRequest.getAppDesc()));
                }
                if(StringUtils.isNotBlank(sysAppModifyRequest.getAppConf())) {
                    sysAppDo.setAppConf(StringUtils.trim(sysAppModifyRequest.getAppConf()));
                }
                sysAppDo.setSortSn(sysAppModifyRequest.getSortSn());
                sysAppDo.setModifier(sysAppModifyRequest.getModifier());
                sysAppDo.setGmtModified(System.currentTimeMillis());
                int result = sysAppDao.update(sysAppDo);
                if(result > 0) {
                    sysAppModifyResponse.setSuccess();
                    sysAppModifyResponse.setSysApp(sysAppDao.get(sysAppDo.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysAppModifyResponse         : " + JsonConvertUtils.convertToString(sysAppModifyResponse));
            logger.debug(" <<<<<<< end modifySysApp <<<<<<< ");
        }
        return sysAppModifyResponse;
    }

    @Override
    public SysAppInvalidateResponse invalidateSysApp(SysAppInvalidateRequest sysAppInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysApp >>>>>> ");
            logger.debug(" SysAppInvalidateRequest      : " + JsonConvertUtils.convertToString(sysAppInvalidateRequest));
        }
        SysAppInvalidateResponse sysAppInvalidateResponse = new SysAppInvalidateResponse();
        sysAppInvalidateResponse.setFailureDefault();
        SysAppDo sysAppDo = null;
        if(sysAppInvalidateRequest != null && sysAppInvalidateRequest.getAppId() != null) {
            sysAppDo = sysAppDao.get(sysAppInvalidateRequest.getAppId());
        }
        if(sysAppDo == null) {
            sysAppInvalidateResponse.setFailure("SYS_APP_NOTEXIST", "该系统应用不存在");
        }
        else {
            sysAppDo.setValid(false);
            sysAppDo.setInvalider(sysAppInvalidateRequest.getInvalider());
            sysAppDo.setGmtInvalid(System.currentTimeMillis());
            int result = sysAppDao.update(sysAppDo);
            if(result > 0) {
                sysAppInvalidateResponse.setSuccess();
                sysAppInvalidateResponse.setSysApp(sysAppDao.get(sysAppDo.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysAppInvalidateResponse     : " + JsonConvertUtils.convertToString(sysAppInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysApp <<<<<<< ");
        }
        return sysAppInvalidateResponse;
    }

    @Override
    public SysAppDeleteResponse deleteSysApp(SysAppDeleteRequest sysAppDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysApp >>>>>> ");
            logger.debug(" SysAppDeleteRequest          : " + JsonConvertUtils.convertToString(sysAppDeleteRequest));
        }
        SysAppDeleteResponse sysAppDeleteResponse = new SysAppDeleteResponse();
        sysAppDeleteResponse.setFailureDefault();
        SysAppDo sysAppDo = null;
        if(sysAppDeleteRequest != null && sysAppDeleteRequest.getAppId() != null) {
            sysAppDo = sysAppDao.get(sysAppDeleteRequest.getAppId());
        }
        if(sysAppDo == null) {
            sysAppDeleteResponse.setFailure("SYS_APP_NOTEXIST", "该系统应用不存在");
        }
        else {
            int result = sysAppDao.delete(sysAppDo);
            if(result > 0) {
                sysAppDeleteResponse.setSuccess();
                sysAppDeleteResponse.setSysApp(sysAppDo);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysAppDeleteResponse         : " + JsonConvertUtils.convertToString(sysAppDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysApp <<<<<<< ");
        }
        return sysAppDeleteResponse;
    }

    @Override
    public SysAppGetResponse getSysApp(SysAppGetRequest sysAppGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysApp >>>>>> ");
            logger.debug(" SysAppGetRequest             : " + JsonConvertUtils.convertToString(sysAppGetRequest));
        }
        SysAppGetResponse sysAppGetResponse = new SysAppGetResponse();
        sysAppGetResponse.setFailureDefault();
        SysAppDo sysAppDo = null;
        if(sysAppGetRequest != null && sysAppGetRequest.getAppId() != null) {
            sysAppDo = sysAppDao.get(sysAppGetRequest.getAppId());
        }
        else if(sysAppGetRequest != null && StringUtils.isNotBlank(sysAppGetRequest.getAppNo())) {
            sysAppDo = sysAppDao.getByAppNo(sysAppGetRequest.getAppNo());
        }
        if(sysAppDo == null) {
            sysAppGetResponse.setFailure("SYS_APP_NOTEXIST", "该系统应用不存在");
        }
        else {
            sysAppGetResponse.setSuccess();
            sysAppGetResponse.setSysApp(sysAppDo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysAppGetResponse            : " + JsonConvertUtils.convertToString(sysAppGetResponse));
            logger.debug(" <<<<<<< end getSysApp <<<<<<< ");
        }
        return sysAppGetResponse;
    }

    @Override
    public SysAppQueryResponse querySysApp(SysAppQueryRequest sysAppQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysApp >>>>>> ");
            logger.debug(" SysAppQueryRequest           : " + JsonConvertUtils.convertToString(sysAppQueryRequest));
        }
        SysAppQueryResponse sysAppQueryResponse = new SysAppQueryResponse();
        sysAppQueryResponse.setFailureDefault();
        if(sysAppQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("appNo", sysAppQueryRequest.getAppNo());
            params.put("appType", sysAppQueryRequest.getAppType());
            params.put("appName", sysAppQueryRequest.getAppName());
            params.put("appDesc", sysAppQueryRequest.getAppDesc());
            params.put("valid", sysAppQueryRequest.getIsValid());
            int sysAppCount = sysAppDao.getCount(params);
            List<SysAppDo> sysAppList = sysAppDao.getList(
                params,
                new Sorter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sysAppQueryRequest.getOrderCol()), StringUtils.lowerCase(sysAppQueryRequest.getOrderDir())),
                new Pager(sysAppQueryRequest.getPageNumber(), sysAppQueryRequest.getPageSize())
            );
            sysAppQueryResponse.setSuccess();
            sysAppQueryResponse.setSysAppCount(sysAppCount);
            sysAppQueryResponse.setSysAppList(sysAppList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysAppQueryResponse              : " + JsonConvertUtils.convertToString(sysAppQueryResponse));
            logger.debug(" <<<<<<< end querySysApp <<<<<<< ");
        }
        return sysAppQueryResponse;
    }
}
