package com.easesource.system.openservices.basemgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.basemgmt.dao.SysCodeDao;
import com.easesource.system.openservices.basemgmt.dao.SysCodeSortDao;
import com.easesource.system.openservices.basemgmt.entity.SysCodeDo;
import com.easesource.system.openservices.basemgmt.entity.SysCodeSortDo;
import com.easesource.system.openservices.basemgmt.entity.SysCodeVo;
import com.easesource.system.openservices.basemgmt.request.*;
import com.easesource.system.openservices.basemgmt.response.*;
import com.easesource.system.openservices.basemgmt.service.SysCodeService;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysCodeServiceImpl extends AbstractBaseService implements SysCodeService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final SysCodeSortDao sysCodeSortDao;
    private final SysCodeDao sysCodeDao;

    @Autowired
    public SysCodeServiceImpl(SysCodeSortDao sysCodeSortDao, SysCodeDao sysCodeDao) {
        this.sysCodeSortDao = sysCodeSortDao;
        this.sysCodeDao = sysCodeDao;
    }

    @Override
    public SysCodeSortCreateResponse createSysCodeSort(SysCodeSortCreateRequest sysCodeSortCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysCodeSort >>>>>> ");
            logger.debug(" SysCodeSortCreateRequest         : " + JsonConvertUtils.convertToString(sysCodeSortCreateRequest));
        }
        SysCodeSortCreateResponse sysCodeSortCreateResponse = new SysCodeSortCreateResponse();
        sysCodeSortCreateResponse.setFailureDefault();
        if(sysCodeSortCreateRequest != null && StringUtils.isNotBlank(sysCodeSortCreateRequest.getCodeSortNo())) {
            SysCodeSortDo sysCodeSort = sysCodeSortDao.getByCodeSortNo(sysCodeSortCreateRequest.getCodeSortNo());
            if(sysCodeSort != null) {
                sysCodeSortCreateResponse.setFailure("CODE_SORT_NO_ISEXIST", "代码分类编号已存在");
            }
            else {
                sysCodeSort = new SysCodeSortDo();
                sysCodeSort.setId(idGenerator.nextId());
                sysCodeSort.setCodeSortNo(sysCodeSortCreateRequest.getCodeSortNo());
                sysCodeSort.setCodeSortName(sysCodeSortCreateRequest.getCodeSortName());
                sysCodeSort.setCodeSortDesc(sysCodeSortCreateRequest.getCodeSortDesc());
                sysCodeSort.setCodeSortLevel(sysCodeSortCreateRequest.getCodeSortLevel());
                sysCodeSort.setParentId(sysCodeSortCreateRequest.getParentId());
                sysCodeSort.setSortSn(sysCodeSortCreateRequest.getSortSn());
                sysCodeSort.setValid(true);
                sysCodeSort.setCreator(sysCodeSortCreateRequest.getCreator());
                sysCodeSort.setGmtCreate(System.currentTimeMillis());
                sysCodeSort.setModifier(sysCodeSortCreateRequest.getCreator());
                sysCodeSort.setGmtModified(System.currentTimeMillis());
                sysCodeSort.setInvalider("");
                sysCodeSort.setGmtInvalid(0L);
                sysCodeSort.setVersion(1);
                int result = sysCodeSortDao.insert(sysCodeSort);
                if(result > 0) {
                    sysCodeSortCreateResponse.setSuccess();
                    sysCodeSortCreateResponse.setSysCodeSort(sysCodeSortDao.get(sysCodeSort.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeSortCreateResponse        : " + JsonConvertUtils.convertToString(sysCodeSortCreateResponse));
            logger.debug(" <<<<<<< end createSysCodeSort <<<<<<< ");
        }
        return sysCodeSortCreateResponse;
    }

    @Override
    public SysCodeSortModifyResponse modifySysCodeSort(SysCodeSortModifyRequest sysCodeSortModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysCodeSort >>>>>> ");
            logger.debug(" SysCodeSortModifyRequest         : " + JsonConvertUtils.convertToString(sysCodeSortModifyRequest));
        }
        SysCodeSortModifyResponse sysCodeSortModifyResponse = new SysCodeSortModifyResponse();
        sysCodeSortModifyResponse.setFailureDefault();
        if(sysCodeSortModifyRequest != null && sysCodeSortModifyRequest.getCodeSortId() != null && StringUtils.isNotBlank(sysCodeSortModifyRequest.getCodeSortNo())) {
            SysCodeSortDo sysCodeSort = sysCodeSortDao.get(sysCodeSortModifyRequest.getCodeSortId());
            if(sysCodeSort == null) {
                sysCodeSortModifyResponse.setFailure("CODE_SORT_NOTEXIST", "该代码分类不存在");
            }
            else {
                sysCodeSort.setCodeSortNo(sysCodeSortModifyRequest.getCodeSortNo());
                sysCodeSort.setCodeSortName(sysCodeSortModifyRequest.getCodeSortName());
                sysCodeSort.setCodeSortDesc(sysCodeSortModifyRequest.getCodeSortDesc());
                sysCodeSort.setCodeSortLevel(sysCodeSortModifyRequest.getCodeSortLevel());
                sysCodeSort.setParentId(sysCodeSortModifyRequest.getParentId());
                sysCodeSort.setSortSn(sysCodeSortModifyRequest.getSortSn());
                sysCodeSort.setModifier(sysCodeSortModifyRequest.getModifier());
                sysCodeSort.setGmtModified(System.currentTimeMillis());
                int result = sysCodeSortDao.update(sysCodeSort);
                if(result > 0) {
                    sysCodeSortModifyResponse.setSuccess();
                    sysCodeSortModifyResponse.setSysCodeSort(sysCodeSortDao.get(sysCodeSort.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeSortModifyResponse        : " + JsonConvertUtils.convertToString(sysCodeSortModifyResponse));
            logger.debug(" <<<<<<< end modifySysCodeSort <<<<<<< ");
        }
        return sysCodeSortModifyResponse;
    }

    @Override
    public SysCodeSortInvalidateResponse invalidateSysCodeSort(SysCodeSortInvalidateRequest sysCodeSortInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysCodeSort >>>>>> ");
            logger.debug(" SysCodeSortInvalidateRequest     : " + JsonConvertUtils.convertToString(sysCodeSortInvalidateRequest));
        }
        SysCodeSortInvalidateResponse sysCodeSortInvalidateResponse = new SysCodeSortInvalidateResponse();
        sysCodeSortInvalidateResponse.setFailureDefault();
        SysCodeSortDo sysCodeSort = null;
        if(sysCodeSortInvalidateRequest != null && sysCodeSortInvalidateRequest.getCodeSortId() != null) {
            sysCodeSort = sysCodeSortDao.get(sysCodeSortInvalidateRequest.getCodeSortId());
        }
        else if(sysCodeSortInvalidateRequest != null && StringUtils.isNotBlank(sysCodeSortInvalidateRequest.getCodeSortNo())) {
            sysCodeSort = sysCodeSortDao.getByCodeSortNo(sysCodeSortInvalidateRequest.getCodeSortNo());
        }
        if(sysCodeSort == null) {
            sysCodeSortInvalidateResponse.setFailure("CODE_SORT_NOTEXIST", "该代码分类不存在");
        }
        else {
            sysCodeSort.setValid(false);
            sysCodeSort.setInvalider(sysCodeSortInvalidateRequest.getInvalider());
            sysCodeSort.setGmtInvalid(System.currentTimeMillis());
            int result = sysCodeSortDao.update(sysCodeSort);
            if(result > 0) {
                sysCodeSortInvalidateResponse.setSuccess();
                sysCodeSortInvalidateResponse.setSysCodeSort(sysCodeSortDao.get(sysCodeSort.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeSortInvalidateResponse    : " + JsonConvertUtils.convertToString(sysCodeSortInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysCodeSort <<<<<<< ");
        }
        return sysCodeSortInvalidateResponse;
    }

    @Override
    public SysCodeSortGetResponse getSysCodeSort(SysCodeSortGetRequest sysCodeSortGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysCodeSort >>>>>> ");
            logger.debug(" SysCodeSortGetRequest            : " + JsonConvertUtils.convertToString(sysCodeSortGetRequest));
        }
        SysCodeSortGetResponse sysCodeSortGetResponse = new SysCodeSortGetResponse();
        sysCodeSortGetResponse.setFailureDefault();
        SysCodeSortDo sysCodeSort = null;
        if(sysCodeSortGetRequest != null && sysCodeSortGetRequest.getCodeSortId() != null) {
            sysCodeSort = sysCodeSortDao.get(sysCodeSortGetRequest.getCodeSortId());
        }
        else if(sysCodeSortGetRequest != null && StringUtils.isNotBlank(sysCodeSortGetRequest.getCodeSortNo())) {
            sysCodeSort = sysCodeSortDao.getByCodeSortNo(sysCodeSortGetRequest.getCodeSortNo());
        }
        if(sysCodeSort == null) {
            sysCodeSortGetResponse.setFailure("CODE_SORT_NOTEXIST", "该代码分类不存在");
        }
        else {
            sysCodeSortGetResponse.setSuccess();
            sysCodeSortGetResponse.setSysCodeSort(sysCodeSort);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeSortGetResponse           : " + JsonConvertUtils.convertToString(sysCodeSortGetResponse));
            logger.debug(" <<<<<<< end getSysCodeSort <<<<<<< ");
        }
        return sysCodeSortGetResponse;
    }

    @Override
    public SysCodeSortQueryResponse querySysCodeSort(SysCodeSortQueryRequest sysCodeSortQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysCodeSort >>>>>> ");
            logger.debug(" SysCodeSortQueryRequest          : " + JsonConvertUtils.convertToString(sysCodeSortQueryRequest));
        }
        SysCodeSortQueryResponse sysCodeSortQueryResponse = new SysCodeSortQueryResponse();
        sysCodeSortQueryResponse.setFailureDefault();
        if(sysCodeSortQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("codeSortNo", sysCodeSortQueryRequest.getCodeSortNo());
            params.put("codeSortName", sysCodeSortQueryRequest.getCodeSortName());
            params.put("codeSortDesc", sysCodeSortQueryRequest.getCodeSortDesc());
            params.put("codeSortLevel", sysCodeSortQueryRequest.getCodeSortLevel());
            params.put("parentId", sysCodeSortQueryRequest.getParentId());
            params.put("valid", sysCodeSortQueryRequest.getIsValid());
            int sysCodeSortCount = sysCodeSortDao.getCount(params);
            List<SysCodeSortDo> sysCodeSortList = sysCodeSortDao.getList(params, new Sorter("sort_sn", ""), new Pager(sysCodeSortQueryRequest.getPageNumber(), sysCodeSortQueryRequest.getPageSize()));
            sysCodeSortQueryResponse.setSuccess();
            sysCodeSortQueryResponse.setSysCodeSortCount(sysCodeSortCount);
            sysCodeSortQueryResponse.setSysCodeSortList(sysCodeSortList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeSortQueryResponse           : " + JsonConvertUtils.convertToString(sysCodeSortQueryResponse));
            logger.debug(" <<<<<<< end querySysCodeSort <<<<<<< ");
        }
        return sysCodeSortQueryResponse;
    }

    @Override
    public SysCodeCreateResponse createSysCode(SysCodeCreateRequest sysCodeCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysCode >>>>>> ");
            logger.debug(" SysCodeCreateRequest             : " + JsonConvertUtils.convertToString(sysCodeCreateRequest));
        }
        SysCodeCreateResponse sysCodeCreateResponse = new SysCodeCreateResponse();
        sysCodeCreateResponse.setFailureDefault();
        if(sysCodeCreateRequest != null && sysCodeCreateRequest.getCodeSortId() != null && StringUtils.isNotBlank(sysCodeCreateRequest.getCodeSortNo()) && StringUtils.isNotBlank(sysCodeCreateRequest.getCodeValue())) {
            SysCodeSortDo sysCodeSort = sysCodeSortDao.get(sysCodeCreateRequest.getCodeSortId());
            if(sysCodeSort == null) {
                sysCodeCreateResponse.setFailure("CODE_SORT_NOTEXIST", "该代码分类不存在");
            }
            else {
                if(!StringUtils.equals(sysCodeSort.getCodeSortNo(), sysCodeCreateRequest.getCodeSortNo())) {
                    sysCodeCreateResponse.setFailure("CODE_SORT_PARAMERR", "代码分类参数错误");
                }
                else {
                    SysCodeDo sysCode = sysCodeDao.getByCodeSortNoAndCodeValue(sysCodeCreateRequest.getCodeSortNo(), sysCodeCreateRequest.getCodeValue());
                    if(sysCode != null) {
                        sysCodeCreateResponse.setFailure("CODE_SORT_CODE_VALUE_ISEXIST", "改代码分类的代码值已存在");
                    }

                    sysCode = new SysCodeDo();
                    sysCode.setId(idGenerator.nextId());
                    sysCode.setCodeSortId(sysCodeCreateRequest.getCodeSortId());
                    sysCode.setCodeSortNo(sysCodeCreateRequest.getCodeSortNo());
                    sysCode.setCodeValue(sysCodeCreateRequest.getCodeValue());
                    sysCode.setCodeName(sysCodeCreateRequest.getCodeName());
                    sysCode.setCodeDesc(sysCodeCreateRequest.getCodeDesc());
                    sysCode.setCodeContent1(sysCodeCreateRequest.getCodeContent1());
                    sysCode.setCodeContent2(sysCodeCreateRequest.getCodeContent2());
                    sysCode.setCodeContent3(sysCodeCreateRequest.getCodeContent3());
                    sysCode.setCodeContent4(sysCodeCreateRequest.getCodeContent4());
                    sysCode.setCodeContent5(sysCodeCreateRequest.getCodeContent5());
                    sysCode.setCodeAlias1(sysCodeCreateRequest.getCodeAlias1());
                    sysCode.setCodeAlias2(sysCodeCreateRequest.getCodeAlias2());
                    sysCode.setCodeAlias3(sysCodeCreateRequest.getCodeAlias3());
                    sysCode.setCodeAlias4(sysCodeCreateRequest.getCodeAlias4());
                    sysCode.setCodeAlias5(sysCodeCreateRequest.getCodeAlias5());
                    sysCode.setRetrievalCode1(sysCodeCreateRequest.getRetrievalCode1());
                    sysCode.setRetrievalCode2(sysCodeCreateRequest.getRetrievalCode2());
                    sysCode.setRetrievalCode3(sysCodeCreateRequest.getRetrievalCode3());
                    sysCode.setRetrievalCode4(sysCodeCreateRequest.getRetrievalCode4());
                    sysCode.setRetrievalCode5(sysCodeCreateRequest.getRetrievalCode5());
                    sysCode.setSortSn(sysCodeCreateRequest.getSortSn());
                    sysCode.setValid(true);
                    sysCode.setCreator(sysCodeCreateRequest.getCreator());
                    sysCode.setGmtCreate(System.currentTimeMillis());
                    sysCode.setModifier(sysCodeCreateRequest.getCreator());
                    sysCode.setGmtModified(System.currentTimeMillis());
                    sysCode.setInvalider("");
                    sysCode.setGmtInvalid(0L);
                    sysCode.setVersion(1);
                    int result = sysCodeDao.insert(sysCode);
                    if(result > 0) {
                        sysCodeCreateResponse.setSuccess();
                        sysCodeCreateResponse.setSysCode(sysCodeDao.get(sysCode.getId()));
                    }
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeCreateResponse            : " + JsonConvertUtils.convertToString(sysCodeCreateResponse));
            logger.debug(" <<<<<<< end createSysCode <<<<<<< ");
        }
        return sysCodeCreateResponse;
    }

    @Override
    public SysCodeModifyResponse modifySysCode(SysCodeModifyRequest sysCodeModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysCode >>>>>> ");
            logger.debug(" SysCodeModifyRequest             : " + JsonConvertUtils.convertToString(sysCodeModifyRequest));
        }
        SysCodeModifyResponse sysCodeModifyResponse = new SysCodeModifyResponse();
        sysCodeModifyResponse.setFailureDefault();
        if(sysCodeModifyRequest != null && sysCodeModifyRequest.getCodeId() != null) {
            SysCodeDo sysCode = sysCodeDao.get(sysCodeModifyRequest.getCodeId());
            if(sysCode == null) {
                sysCodeModifyResponse.setFailure("CODE_NOTEXIST", "该代码不存在");
            }
            else {
                sysCode.setCodeSortId(sysCodeModifyRequest.getCodeSortId());
                sysCode.setCodeSortNo(sysCodeModifyRequest.getCodeSortNo());
                sysCode.setCodeValue(sysCodeModifyRequest.getCodeValue());
                sysCode.setCodeName(sysCodeModifyRequest.getCodeName());
                sysCode.setCodeDesc(sysCodeModifyRequest.getCodeDesc());
                sysCode.setCodeContent1(sysCodeModifyRequest.getCodeContent1());
                sysCode.setCodeContent2(sysCodeModifyRequest.getCodeContent2());
                sysCode.setCodeContent3(sysCodeModifyRequest.getCodeContent3());
                sysCode.setCodeContent4(sysCodeModifyRequest.getCodeContent4());
                sysCode.setCodeContent5(sysCodeModifyRequest.getCodeContent5());
                sysCode.setCodeAlias1(sysCodeModifyRequest.getCodeAlias1());
                sysCode.setCodeAlias2(sysCodeModifyRequest.getCodeAlias2());
                sysCode.setCodeAlias3(sysCodeModifyRequest.getCodeAlias3());
                sysCode.setCodeAlias4(sysCodeModifyRequest.getCodeAlias4());
                sysCode.setCodeAlias5(sysCodeModifyRequest.getCodeAlias5());
                sysCode.setRetrievalCode1(sysCodeModifyRequest.getRetrievalCode1());
                sysCode.setRetrievalCode2(sysCodeModifyRequest.getRetrievalCode2());
                sysCode.setRetrievalCode3(sysCodeModifyRequest.getRetrievalCode3());
                sysCode.setRetrievalCode4(sysCodeModifyRequest.getRetrievalCode4());
                sysCode.setRetrievalCode5(sysCodeModifyRequest.getRetrievalCode5());
                sysCode.setSortSn(sysCodeModifyRequest.getSortSn());
                sysCode.setModifier(sysCodeModifyRequest.getModifier());
                sysCode.setGmtModified(System.currentTimeMillis());
                int result = sysCodeDao.update(sysCode);
                if(result > 0) {
                    sysCodeModifyResponse.setSuccess();
                    sysCodeModifyResponse.setSysCode(sysCodeDao.get(sysCode.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeModifyResponse            : " + JsonConvertUtils.convertToString(sysCodeModifyResponse));
            logger.debug(" <<<<<<< end modifySysCode <<<<<<< ");
        }
        return sysCodeModifyResponse;
    }

    @Override
    public SysCodeInvalidateResponse invalidateSysCode(SysCodeInvalidateRequest sysCodeInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysCode >>>>>> ");
            logger.debug(" SysCodeInvalidateRequest         : " + JsonConvertUtils.convertToString(sysCodeInvalidateRequest));
        }
        SysCodeInvalidateResponse sysCodeInvalidateResponse = new SysCodeInvalidateResponse();
        sysCodeInvalidateResponse.setFailureDefault();
        SysCodeDo sysCode = null;
        if(sysCodeInvalidateRequest != null && sysCodeInvalidateRequest.getCodeId() != null) {
            sysCode = sysCodeDao.get(sysCodeInvalidateRequest.getCodeId());
        }
        if(sysCode == null) {
            sysCodeInvalidateResponse.setFailure("CODE_NOTEXIST", "该代码不存在");
        }
        else {
            sysCode.setValid(false);
            sysCode.setInvalider(sysCodeInvalidateRequest.getInvalider());
            sysCode.setGmtInvalid(System.currentTimeMillis());
            int result = sysCodeDao.update(sysCode);
            if(result > 0) {
                sysCodeInvalidateResponse.setSuccess();
                sysCodeInvalidateResponse.setSysCode(sysCodeDao.get(sysCode.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeInvalidateResponse        : " + JsonConvertUtils.convertToString(sysCodeInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysCode <<<<<<< ");
        }
        return sysCodeInvalidateResponse;
    }

    @Override
    public SysCodeGetResponse getSysCode(SysCodeGetRequest sysCodeGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysCode >>>>>> ");
            logger.debug(" SysCodeGetRequest                : " + JsonConvertUtils.convertToString(sysCodeGetRequest));
        }
        SysCodeGetResponse sysCodeGetResponse = new SysCodeGetResponse();
        sysCodeGetResponse.setFailureDefault();
        SysCodeVo sysCode = null;
        if(sysCodeGetRequest != null && sysCodeGetRequest.getCodeId() != null) {
            sysCode = sysCodeDao.getSysCodeVo(sysCodeGetRequest.getCodeId());
        }
        else if(sysCodeGetRequest != null && StringUtils.isNotBlank(sysCodeGetRequest.getCodeSortNo()) && StringUtils.isNotBlank(sysCodeGetRequest.getCodeValue())) {
            sysCode = sysCodeDao.getSysCodeVoByCodeSortNoAndCodeValue(sysCodeGetRequest.getCodeSortNo(), sysCodeGetRequest.getCodeValue());
        }
        if(sysCode == null) {
            sysCodeGetResponse.setFailure("CODE_NOTEXIST", "该代码不存在");
        }
        else {
            sysCodeGetResponse.setSuccess();
            sysCodeGetResponse.setSysCode(sysCode);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeGetResponse               : " + JsonConvertUtils.convertToString(sysCodeGetResponse));
            logger.debug(" <<<<<<< end getSysCode <<<<<<< ");
        }
        return sysCodeGetResponse;
    }

    @Override
    public SysCodeQueryResponse querySysCode(SysCodeQueryRequest sysCodeQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysCode >>>>>> ");
            logger.debug(" SysCodeQueryRequest              : " + JsonConvertUtils.convertToString(sysCodeQueryRequest));
        }
        SysCodeQueryResponse sysCodeQueryResponse = new SysCodeQueryResponse();
        sysCodeQueryResponse.setFailureDefault();
        if(sysCodeQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("codeSortId", sysCodeQueryRequest.getCodeSortId());
            params.put("codeSortNo", sysCodeQueryRequest.getCodeSortNo());
            params.put("codeValue", sysCodeQueryRequest.getCodeValue());
            params.put("codeName", sysCodeQueryRequest.getCodeName());
            params.put("valid", sysCodeQueryRequest.getIsValid());
            int sysCodeCount = sysCodeDao.getSysCodeVoCount(params);
            List<SysCodeVo> sysCodeList = sysCodeDao.getSysCodeVoList(params, new Sorter("sort_sn", ""), new Pager(sysCodeQueryRequest.getPageNumber(), sysCodeQueryRequest.getPageSize()));
            sysCodeQueryResponse.setSuccess();
            sysCodeQueryResponse.setSysCodeCount(sysCodeCount);
            sysCodeQueryResponse.setSysCodeList(sysCodeList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysCodeQueryResponse             : " + JsonConvertUtils.convertToString(sysCodeQueryResponse));
            logger.debug(" <<<<<<< end querySysCode <<<<<<< ");
        }
        return sysCodeQueryResponse;
    }

}
