package com.easesource.system.openservices.basemgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.basemgmt.dao.SysMenuItemDao;
import com.easesource.system.openservices.basemgmt.dao.SysMenuThemeDao;
import com.easesource.system.openservices.basemgmt.dao.SysMenuTreeDao;
import com.easesource.system.openservices.basemgmt.entity.*;
import com.easesource.system.openservices.basemgmt.request.*;
import com.easesource.system.openservices.basemgmt.response.*;
import com.easesource.system.openservices.basemgmt.service.SysMenuService;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysMenuServiceImpl extends AbstractBaseService implements SysMenuService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final SysMenuThemeDao sysMenuThemeDao;
    private final SysMenuTreeDao sysMenuTreeDao;
    private final SysMenuItemDao sysMenuItemDao;

    @Autowired
    public SysMenuServiceImpl(SysMenuThemeDao sysMenuThemeDao, SysMenuTreeDao sysMenuTreeDao, SysMenuItemDao sysMenuItemDao) {
        this.sysMenuThemeDao = sysMenuThemeDao;
        this.sysMenuTreeDao = sysMenuTreeDao;
        this.sysMenuItemDao = sysMenuItemDao;
    }

    @Override
    public SysMenuThemeCreateResponse createSysMenuTheme(SysMenuThemeCreateRequest sysMenuThemeCreateRequest) {
        return null;
    }

    @Override
    public SysMenuThemeModifyResponse modifySysMenuTheme(SysMenuThemeModifyRequest sysMenuThemeModifyRequest) {
        return null;
    }

    @Override
    public SysMenuThemeInvalidateResponse invalidateSysMenuTheme(SysMenuThemeInvalidateRequest sysMenuThemeInvalidateRequest) {
        return null;
    }

    @Override
    public SysMenuThemeGetResponse getSysMenuTheme(SysMenuThemeGetRequest sysMenuThemeGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysMenuTheme >>>>>> ");
            logger.debug(" SysMenuThemeGetRequest       : " + JsonConvertUtils.convertToString(sysMenuThemeGetRequest));
        }
        SysMenuThemeGetResponse sysMenuThemeGetResponse = new SysMenuThemeGetResponse();
        sysMenuThemeGetResponse.setFailureDefault();
        SysMenuThemeDo sysMenuThemeDo = null;
        if(sysMenuThemeGetRequest != null && sysMenuThemeGetRequest.getMenuThemeId() != null) {
            sysMenuThemeDo = sysMenuThemeDao.get(sysMenuThemeGetRequest.getMenuThemeId());
        }
        else if(sysMenuThemeGetRequest != null && StringUtils.isNotBlank(sysMenuThemeGetRequest.getMenuThemeCode())) {
            sysMenuThemeDo = sysMenuThemeDao.getByMenuThemeCode(sysMenuThemeGetRequest.getMenuThemeCode());
        }
        if(sysMenuThemeDo == null) {
            sysMenuThemeGetResponse.setFailure("SYS_MENU_THEME_NOTEXIST", "该系统菜单主题不存在");
        }
        else {
            sysMenuThemeGetResponse.setSuccess();
            sysMenuThemeGetResponse.setSysMenuTheme(sysMenuThemeDo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuThemeGetResponse      : " + JsonConvertUtils.convertToString(sysMenuThemeGetResponse));
            logger.debug(" <<<<<<< end getSysMenuTheme <<<<<<< ");
        }
        return sysMenuThemeGetResponse;
    }

    @Override
    public SysMenuThemeQueryResponse querySysMenuTheme(SysMenuThemeQueryRequest sysMenuThemeQueryRequest) {
        return null;
    }

    @Override
    public SysMenuTreeCreateResponse createSysMenuTree(SysMenuTreeCreateRequest sysMenuTreeCreateRequest) {
        return null;
    }

    @Override
    public SysMenuTreeModifyResponse modifySysMenuTree(SysMenuTreeModifyRequest sysMenuTreeModifyRequest) {
        return null;
    }

    @Override
    public SysMenuTreeInvalidateResponse invalidateSysMenuTree(SysMenuTreeInvalidateRequest sysMenuTreeInvalidateRequest) {
        return null;
    }

    @Override
    public SysMenuTreeGetResponse getSysMenuTree(SysMenuTreeGetRequest sysMenuTreeGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysMenuTree >>>>>> ");
            logger.debug(" SysMenuTreeGetRequest        : " + JsonConvertUtils.convertToString(sysMenuTreeGetRequest));
        }
        SysMenuTreeGetResponse sysMenuTreeGetResponse = new SysMenuTreeGetResponse();
        sysMenuTreeGetResponse.setFailureDefault();
        SysMenuTreeVo sysMenuTreeVo = null;
        if(sysMenuTreeGetRequest != null && sysMenuTreeGetRequest.getMenuTreeId() != null) {
            sysMenuTreeVo = sysMenuTreeDao.getSysMenuTreeVo(sysMenuTreeGetRequest.getMenuTreeId());
        }
        else if(sysMenuTreeGetRequest != null && StringUtils.isNotBlank(sysMenuTreeGetRequest.getMenuTreeCode())) {
            sysMenuTreeVo = sysMenuTreeDao.getSysMenuTreeVoByMenuTreeCode(sysMenuTreeGetRequest.getMenuTreeCode());
        }
        if(sysMenuTreeVo == null) {
            sysMenuTreeGetResponse.setFailure("SYS_MENU_TREE_NOTEXIST", "该系统菜单树不存在");
        }
        else {
            sysMenuTreeGetResponse.setSuccess();
            sysMenuTreeGetResponse.setSysMenuTree(sysMenuTreeVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuTreeGetResponse       : " + JsonConvertUtils.convertToString(sysMenuTreeGetResponse));
            logger.debug(" <<<<<<< end getSysMenuTree <<<<<<< ");
        }
        return sysMenuTreeGetResponse;
    }

    @Override
    public SysMenuTreeQueryResponse querySysMenuTree(SysMenuTreeQueryRequest sysMenuTreeQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysMenuTree >>>>>> ");
            logger.debug(" SysMenuTreeQueryRequest      : " + JsonConvertUtils.convertToString(sysMenuTreeQueryRequest));
        }
        SysMenuTreeQueryResponse sysMenuTreeQueryResponse = new SysMenuTreeQueryResponse();
        sysMenuTreeQueryResponse.setFailureDefault();
        if(sysMenuTreeQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("menuThemeId", sysMenuTreeQueryRequest.getMenuThemeId());
            params.put("menuTreeCode", sysMenuTreeQueryRequest.getMenuTreeCode());
            params.put("menuTreeName", sysMenuTreeQueryRequest.getMenuTreeName());
            params.put("menuTreeDesc", sysMenuTreeQueryRequest.getMenuTreeDesc());
            params.put("valid", sysMenuTreeQueryRequest.getIsValid());
            int sysMenuTreeVoCount = sysMenuTreeDao.getSysMenuTreeVoCount(params);
            List<SysMenuTreeVo> sysMenuTreeVoList = sysMenuTreeDao.getSysMenuTreeVoList(
                params,
                new Sorter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sysMenuTreeQueryRequest.getOrderCol()), StringUtils.lowerCase(sysMenuTreeQueryRequest.getOrderDir())),
                new Pager(sysMenuTreeQueryRequest.getPageNumber(), sysMenuTreeQueryRequest.getPageSize())
            );
            sysMenuTreeQueryResponse.setSuccess();
            sysMenuTreeQueryResponse.setSysMenuTreeCount(sysMenuTreeVoCount);
            sysMenuTreeQueryResponse.setSysMenuTreeList(sysMenuTreeVoList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuTreeQueryResponse     : " + JsonConvertUtils.convertToString(sysMenuTreeQueryResponse));
            logger.debug(" <<<<<<< end querySysMenuTree <<<<<<< ");
        }
        return sysMenuTreeQueryResponse;
    }

    @Override
    public SysMenuItemCreateResponse createSysMenuItem(SysMenuItemCreateRequest sysMenuItemCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysMenuItem >>>>>> ");
            logger.debug(" SysMenuItemCreateRequest         : " + JsonConvertUtils.convertToString(sysMenuItemCreateRequest));
        }
        SysMenuItemCreateResponse sysMenuItemCreateResponse = new SysMenuItemCreateResponse();
        sysMenuItemCreateResponse.setFailureDefault();
        if(sysMenuItemCreateRequest != null && sysMenuItemCreateRequest.getMenuTreeId() != null) {
            SysMenuTreeDo sysMenuTreeDo = sysMenuTreeDao.get(sysMenuItemCreateRequest.getMenuTreeId());
            SysMenuItemDo sysMenuItemDo = sysMenuItemDao.getByMenuItemCode(sysMenuItemCreateRequest.getMenuItemCode());
            if(sysMenuTreeDo != null && sysMenuItemDo == null) {
                sysMenuItemDo = new SysMenuItemDo();
                sysMenuItemDo.setId(idGenerator.nextId());
                sysMenuItemDo.setMenuTreeId(sysMenuItemCreateRequest.getMenuTreeId());
                sysMenuItemDo.setMenuItemCode(sysMenuItemCreateRequest.getMenuItemCode());
                sysMenuItemDo.setMenuItemType(sysMenuItemCreateRequest.getMenuItemType());
                sysMenuItemDo.setMenuItemName(sysMenuItemCreateRequest.getMenuItemName());
                sysMenuItemDo.setMenuItemDesc(StringUtils.trimToEmpty(sysMenuItemCreateRequest.getMenuItemDesc()));
                sysMenuItemDo.setMenuItemIcon(StringUtils.trimToEmpty(sysMenuItemCreateRequest.getMenuItemIcon()));
                sysMenuItemDo.setMenuItemLevel(sysMenuItemCreateRequest.getMenuItemLevel());
                sysMenuItemDo.setMenuItemPath(StringUtils.trimToEmpty(sysMenuItemCreateRequest.getMenuItemPath()));
                sysMenuItemDo.setParentId(sysMenuItemCreateRequest.getParentId());
                sysMenuItemDo.setModuleId(sysMenuItemCreateRequest.getModuleId());
                sysMenuItemDo.setSortSn(sysMenuItemCreateRequest.getSortSn());
                sysMenuItemDo.setValid(true);
                sysMenuItemDo.setCreator(sysMenuItemCreateRequest.getCreator());
                sysMenuItemDo.setGmtCreate(System.currentTimeMillis());
                sysMenuItemDo.setModifier(sysMenuItemCreateRequest.getCreator());
                sysMenuItemDo.setGmtModified(System.currentTimeMillis());
                sysMenuItemDo.setInvalider("");
                sysMenuItemDo.setGmtInvalid(0L);
                sysMenuItemDo.setVersion(1);
                int result = sysMenuItemDao.insert(sysMenuItemDo);
                if(result > 0) {
                    sysMenuItemCreateResponse.setSuccess();
                    sysMenuItemCreateResponse.setSysMenuItem(sysMenuItemDao.get(sysMenuItemDo.getId()));
                }
            }
            else {
                if(sysMenuTreeDo == null) {
                    sysMenuItemCreateResponse.setFailure("SYS_MENU_TREE_NOTEXIST", "系统菜单树不存在");
                }
                if(sysMenuItemDo != null) {
                    sysMenuItemCreateResponse.setFailure("SYS_MENU_ITEM_CODE_ISEXIST", "菜单项编码已存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuItemCreateResponse    : " + JsonConvertUtils.convertToString(sysMenuItemCreateResponse));
            logger.debug(" <<<<<<< end createSysMenuItem <<<<<<< ");
        }
        return sysMenuItemCreateResponse;
    }

    @Override
    public SysMenuItemModifyResponse modifySysMenuItem(SysMenuItemModifyRequest sysMenuItemModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysMenuItem >>>>>> ");
            logger.debug(" SysMenuItemModifyRequest     : " + JsonConvertUtils.convertToString(sysMenuItemModifyRequest));
        }
        SysMenuItemModifyResponse sysMenuItemModifyResponse = new SysMenuItemModifyResponse();
        sysMenuItemModifyResponse.setFailureDefault();
        if(sysMenuItemModifyRequest != null && sysMenuItemModifyRequest.getMenuItemId() != null && StringUtils.isNotBlank(sysMenuItemModifyRequest.getMenuItemCode())) {
            SysMenuItemDo sysMenuItemDo = sysMenuItemDao.get(sysMenuItemModifyRequest.getMenuItemId());
            if(sysMenuItemDo == null) {
                sysMenuItemModifyResponse.setFailure("SYS_MENU_ITEM_NOTEXIST", "该系统菜单项不存在");
            }
            else {
                SysMenuTreeDo sysMenuTreeDo = sysMenuTreeDao.get(sysMenuItemModifyRequest.getMenuTreeId());
                if(sysMenuTreeDo == null) {
                    sysMenuItemModifyResponse.setFailure("SYS_MENU_TREE_NOTEXIST", "该系统菜单树不存在");
                }
                sysMenuItemDo.setMenuTreeId(sysMenuItemModifyRequest.getMenuTreeId());
                sysMenuItemDo.setMenuItemCode(sysMenuItemModifyRequest.getMenuItemCode());
                sysMenuItemDo.setMenuItemType(sysMenuItemModifyRequest.getMenuItemType());
                sysMenuItemDo.setMenuItemName(sysMenuItemModifyRequest.getMenuItemName());
                sysMenuItemDo.setMenuItemDesc(StringUtils.trimToEmpty(sysMenuItemModifyRequest.getMenuItemDesc()));
                sysMenuItemDo.setMenuItemIcon(StringUtils.trimToEmpty(sysMenuItemModifyRequest.getMenuItemIcon()));
                sysMenuItemDo.setMenuItemLevel(sysMenuItemModifyRequest.getMenuItemLevel());
                sysMenuItemDo.setMenuItemPath(StringUtils.trimToEmpty(sysMenuItemModifyRequest.getMenuItemPath()));
                sysMenuItemDo.setParentId(sysMenuItemModifyRequest.getParentId());
                sysMenuItemDo.setModuleId(sysMenuItemModifyRequest.getModuleId());
                sysMenuItemDo.setSortSn(sysMenuItemModifyRequest.getSortSn());
                sysMenuItemDo.setModifier(sysMenuItemModifyRequest.getModifier());
                sysMenuItemDo.setGmtModified(System.currentTimeMillis());
                int result = sysMenuItemDao.update(sysMenuItemDo);
                if(result > 0) {
                    sysMenuItemModifyResponse.setSuccess();
                    sysMenuItemModifyResponse.setSysMenuItem(sysMenuItemDao.get(sysMenuItemDo.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuItemModifyResponse    : " + JsonConvertUtils.convertToString(sysMenuItemModifyResponse));
            logger.debug(" <<<<<<< end modifySysMenuItem <<<<<<< ");
        }
        return sysMenuItemModifyResponse;
    }

    @Override
    public SysMenuItemInvalidateResponse invalidateSysMenuItem(SysMenuItemInvalidateRequest sysMenuItemInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysMenuItem >>>>>> ");
            logger.debug(" SysMenuItemInvalidateRequest : " + JsonConvertUtils.convertToString(sysMenuItemInvalidateRequest));
        }
        SysMenuItemInvalidateResponse sysMenuItemInvalidateResponse = new SysMenuItemInvalidateResponse();
        sysMenuItemInvalidateResponse.setFailureDefault();
        SysMenuItemDo sysMenuItemDo = null;
        if(sysMenuItemInvalidateRequest != null && sysMenuItemInvalidateRequest.getMenuItemId() != null) {
            sysMenuItemDo = sysMenuItemDao.get(sysMenuItemInvalidateRequest.getMenuItemId());
        }
        if(sysMenuItemDo == null) {
            sysMenuItemInvalidateResponse.setFailure("SYS_MENU_ITEM_NOTEXIST", "该系统菜单项不存在");
        }
        else {
            sysMenuItemDo.setValid(false);
            sysMenuItemDo.setInvalider(sysMenuItemInvalidateRequest.getInvalider());
            sysMenuItemDo.setGmtInvalid(System.currentTimeMillis());
            int result = sysMenuItemDao.update(sysMenuItemDo);
            if(result > 0) {
                sysMenuItemInvalidateResponse.setSuccess();
                sysMenuItemInvalidateResponse.setSysMenuItem(sysMenuItemDao.get(sysMenuItemDo.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuItemInvalidateResponse : " + JsonConvertUtils.convertToString(sysMenuItemInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysMenuItem <<<<<<< ");
        }
        return sysMenuItemInvalidateResponse;
    }

    @Override
    public SysMenuItemDeleteResponse deleteSysMenuItem(SysMenuItemDeleteRequest sysMenuItemDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysMenuItem >>>>>> ");
            logger.debug(" SysMenuItemDeleteRequest     : " + JsonConvertUtils.convertToString(sysMenuItemDeleteRequest));
        }
        SysMenuItemDeleteResponse sysMenuItemDeleteResponse = new SysMenuItemDeleteResponse();
        sysMenuItemDeleteResponse.setFailureDefault();
        SysMenuItemDo sysMenuItemDo = null;
        if(sysMenuItemDeleteRequest != null && sysMenuItemDeleteRequest.getMenuItemId() != null) {
            sysMenuItemDo = sysMenuItemDao.get(sysMenuItemDeleteRequest.getMenuItemId());
        }
        if(sysMenuItemDo == null) {
            sysMenuItemDeleteResponse.setFailure("SYS_MENU_ITEM_NOTEXIST", "该系统菜单项不存在");
        }
        else {
            int result = sysMenuItemDao.delete(sysMenuItemDo);
            if(result > 0) {
                sysMenuItemDeleteResponse.setSuccess();
                sysMenuItemDeleteResponse.setSysMenuItem(sysMenuItemDao.get(sysMenuItemDo.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuItemDeleteResponse        : " + JsonConvertUtils.convertToString(sysMenuItemDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysMenuItem <<<<<<< ");
        }
        return sysMenuItemDeleteResponse;
    }

    @Override
    public SysMenuItemGetResponse getSysMenuItem(SysMenuItemGetRequest sysMenuItemGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysMenuItem >>>>>> ");
            logger.debug(" SysMenuItemGetRequest        : " + JsonConvertUtils.convertToString(sysMenuItemGetRequest));
        }
        SysMenuItemGetResponse sysMenuItemGetResponse = new SysMenuItemGetResponse();
        sysMenuItemGetResponse.setFailureDefault();
        SysMenuItemVo sysMenuItemVo = null;
        if(sysMenuItemGetRequest != null && sysMenuItemGetRequest.getMenuItemId() != null) {
            sysMenuItemVo = sysMenuItemDao.getSysMenuItemVo(sysMenuItemGetRequest.getMenuItemId());
        }
        else if(sysMenuItemGetRequest != null && StringUtils.isNotBlank(sysMenuItemGetRequest.getMenuItemCode())) {
            sysMenuItemVo = sysMenuItemDao.getSysMenuItemVoByMenuItemCode(sysMenuItemGetRequest.getMenuItemCode());
        }
        if(sysMenuItemVo == null) {
            sysMenuItemGetResponse.setFailure("SYS_MENU_ITEM_NOTEXIST", "该系统菜单项不存在");
        }
        else {
            sysMenuItemGetResponse.setSuccess();
            sysMenuItemGetResponse.setSysMenuItem(sysMenuItemVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuItemGetResponse       : " + JsonConvertUtils.convertToString(sysMenuItemGetResponse));
            logger.debug(" <<<<<<< end getSysMenuItem <<<<<<< ");
        }
        return sysMenuItemGetResponse;
    }

    @Override
    public SysMenuItemQueryResponse querySysMenuItem(SysMenuItemQueryRequest sysMenuItemQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysMenuItem >>>>>> ");
            logger.debug(" SysMenuItemQueryRequest      : " + JsonConvertUtils.convertToString(sysMenuItemQueryRequest));
        }
        SysMenuItemQueryResponse sysMenuItemQueryResponse = new SysMenuItemQueryResponse();
        sysMenuItemQueryResponse.setFailureDefault();
        if(sysMenuItemQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("menuTreeId", sysMenuItemQueryRequest.getMenuTreeId());
            params.put("menuItemCode", sysMenuItemQueryRequest.getMenuItemCode());
            params.put("menuItemName", sysMenuItemQueryRequest.getMenuItemName());
            params.put("menuItemDesc", sysMenuItemQueryRequest.getMenuItemDesc());
            params.put("menuItemIcon", sysMenuItemQueryRequest.getMenuItemIcon());
            params.put("menuItemLevel", sysMenuItemQueryRequest.getMenuItemLevel());
            params.put("parentId", sysMenuItemQueryRequest.getParentId());
            params.put("valid", sysMenuItemQueryRequest.getIsValid());
            params.put("userId", sysMenuItemQueryRequest.getUserId());
            int sysMenuItemVoCount = sysMenuItemDao.getSysMenuItemVoCount(params);
            List<SysMenuItemVo> sysMenuItemVoList = sysMenuItemDao.getSysMenuItemVoList(params, new Sorter("sort_sn", ""), new Pager(sysMenuItemQueryRequest.getPageNumber(), sysMenuItemQueryRequest.getPageSize()));
            sysMenuItemQueryResponse.setSuccess();
            sysMenuItemQueryResponse.setSysMenuItemCount(sysMenuItemVoCount);
            sysMenuItemQueryResponse.setSysMenuItemList(sysMenuItemVoList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysMenuItemQueryResponse         : " + JsonConvertUtils.convertToString(sysMenuItemQueryResponse));
            logger.debug(" <<<<<<< end querySysMenuItem <<<<<<< ");
        }
        return sysMenuItemQueryResponse;
    }

}
