package com.easesource.system.openservices.basemgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.basemgmt.dao.SysAppDao;
import com.easesource.system.openservices.basemgmt.dao.SysModuleDao;
import com.easesource.system.openservices.basemgmt.dao.SysPackageDao;
import com.easesource.system.openservices.basemgmt.entity.SysAppDo;
import com.easesource.system.openservices.basemgmt.entity.SysModuleDo;
import com.easesource.system.openservices.basemgmt.entity.SysModuleVo;
import com.easesource.system.openservices.basemgmt.entity.SysPackageDo;
import com.easesource.system.openservices.basemgmt.request.*;
import com.easesource.system.openservices.basemgmt.response.*;
import com.easesource.system.openservices.basemgmt.service.SysModuleService;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysModuleServiceImpl extends AbstractBaseService implements SysModuleService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final SysAppDao sysAppDao;
    private final SysPackageDao sysPackageDao;
    private final SysModuleDao sysModuleDao;

    @Autowired
    public SysModuleServiceImpl(SysAppDao sysAppDao, SysPackageDao sysPackageDao, SysModuleDao sysModuleDao) {
        this.sysAppDao = sysAppDao;
        this.sysPackageDao = sysPackageDao;
        this.sysModuleDao = sysModuleDao;
    }

    @Override
    public SysModuleCreateResponse createSysModule(SysModuleCreateRequest sysModuleCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysModule >>>>>> ");
            logger.debug(" SysModuleCreateRequest           : " + JsonConvertUtils.convertToString(sysModuleCreateRequest));
        }
        SysModuleCreateResponse sysModuleCreateResponse = new SysModuleCreateResponse();
        sysModuleCreateResponse.setFailureDefault();
        if(sysModuleCreateRequest != null && sysModuleCreateRequest.getAppId() != null) {
            SysAppDo sysAppDo = sysAppDao.get(sysModuleCreateRequest.getAppId());
            SysPackageDo sysPackageDo = sysPackageDao.get(sysModuleCreateRequest.getPackageId());
            SysModuleDo sysModuleDo = sysModuleDao.getByModuleCode(sysModuleCreateRequest.getModuleCode());
            if(sysAppDo != null && sysPackageDo != null && sysModuleDo == null) {
                sysModuleDo = new SysModuleDo();
                sysModuleDo.setId(idGenerator.nextId());
                sysModuleDo.setAppId(sysModuleCreateRequest.getAppId());
                sysModuleDo.setPackageId(sysModuleCreateRequest.getPackageId());
                sysModuleDo.setModuleCode(sysModuleCreateRequest.getModuleCode());
                sysModuleDo.setModuleType(sysModuleCreateRequest.getModuleType());
                sysModuleDo.setModuleName(sysModuleCreateRequest.getModuleName());
                sysModuleDo.setModuleDesc(StringUtils.trimToEmpty(sysModuleCreateRequest.getModuleDesc()));
                sysModuleDo.setModuleActionPath(sysModuleCreateRequest.getModuleActionPath());
                sysModuleDo.setModuleActionType(sysModuleCreateRequest.getModuleActionType());
                sysModuleDo.setModuleLevel(sysModuleCreateRequest.getModuleLevel());
                sysModuleDo.setParentId(sysModuleCreateRequest.getParentId());
                sysModuleDo.setSortSn(sysModuleCreateRequest.getSortSn());
                sysModuleDo.setValid(true);
                sysModuleDo.setCreator(sysModuleCreateRequest.getCreator());
                sysModuleDo.setGmtCreate(System.currentTimeMillis());
                sysModuleDo.setModifier(sysModuleCreateRequest.getCreator());
                sysModuleDo.setGmtModified(System.currentTimeMillis());
                sysModuleDo.setInvalider("");
                sysModuleDo.setGmtInvalid(0L);
                sysModuleDo.setVersion(1);
                int result = sysModuleDao.insert(sysModuleDo);
                if(result > 0) {
                    sysModuleCreateResponse.setSuccess();
                    sysModuleCreateResponse.setSysModule(sysModuleDao.get(sysModuleDo.getId()));
                }
            }
            else {
                if(sysAppDo == null) {
                    sysModuleCreateResponse.setFailure("SYS_APP_NOTEXIST", "系统应用不存在");
                }
                if(sysPackageDo != null) {
                    sysModuleCreateResponse.setFailure("SYS_PACKAGE_ISEXIST", "系统业务包已存在");
                }
                if(sysModuleDo != null) {
                    sysModuleCreateResponse.setFailure("SYS_MODULE_CODE_ISEXIST", "功能组件编码已存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysModuleCreateResponse      : " + JsonConvertUtils.convertToString(sysModuleCreateResponse));
            logger.debug(" <<<<<<< end createSysModule <<<<<<< ");
        }
        return sysModuleCreateResponse;
    }

    @Override
    public SysModuleModifyResponse modifySysModule(SysModuleModifyRequest sysModuleModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysModule >>>>>> ");
            logger.debug(" SysModuleModifyRequest       : " + JsonConvertUtils.convertToString(sysModuleModifyRequest));
        }
        SysModuleModifyResponse sysModuleModifyResponse = new SysModuleModifyResponse();
        sysModuleModifyResponse.setFailureDefault();
        if(sysModuleModifyRequest != null && sysModuleModifyRequest.getModuleId() != null && StringUtils.isNotBlank(sysModuleModifyRequest.getModuleCode())) {
            SysModuleDo sysModuleDo = sysModuleDao.get(sysModuleModifyRequest.getModuleId());
            if(sysModuleDo == null) {
                sysModuleModifyResponse.setFailure("SYS_PACKAGE_NOTEXIST", "该业务包不存在");
            }
            else {
                SysAppDo sysAppDo = sysAppDao.get(sysModuleModifyRequest.getAppId());
                if(sysAppDo == null) {
                    sysModuleModifyResponse.setFailure("SYS_APP_NOTEXIST", "该系统应用不存在");
                }
                SysPackageDo sysPackageDo = sysPackageDao.get(sysModuleModifyRequest.getPackageId());
                if(sysPackageDo == null) {
                    sysModuleModifyResponse.setFailure("SYS_PACKAGE_NOTEXIST", "该系统业务包不存在");
                }
                if(sysAppDo != null && sysPackageDo != null && sysAppDo.getId().longValue() != sysPackageDo.getAppId().longValue()) {
                    sysModuleModifyResponse.setFailure("SYS_APPID_NOT_MATCH", "该系统应用不匹配");
                }
                sysModuleDo.setAppId(sysModuleModifyRequest.getAppId());
                sysModuleDo.setPackageId(sysModuleModifyRequest.getPackageId());
                sysModuleDo.setModuleCode(StringUtils.trim(sysModuleModifyRequest.getModuleCode()));
                sysModuleDo.setModuleType(sysModuleModifyRequest.getModuleType());
                sysModuleDo.setModuleName(sysModuleModifyRequest.getModuleName());
                sysModuleDo.setModuleDesc(StringUtils.trimToEmpty(sysModuleModifyRequest.getModuleDesc()));
                sysModuleDo.setModuleActionPath(sysModuleModifyRequest.getModuleActionPath());
                sysModuleDo.setModuleActionType(sysModuleModifyRequest.getModuleActionType());
                sysModuleDo.setModuleLevel(sysModuleModifyRequest.getModuleLevel());
                sysModuleDo.setParentId(sysModuleModifyRequest.getParentId());
                sysModuleDo.setSortSn(sysModuleModifyRequest.getSortSn());
                sysModuleDo.setModifier(sysModuleModifyRequest.getModifier());
                sysModuleDo.setGmtModified(System.currentTimeMillis());
                int result = sysModuleDao.update(sysModuleDo);
                if(result > 0) {
                    sysModuleModifyResponse.setSuccess();
                    sysModuleModifyResponse.setSysModule(sysModuleDao.get(sysModuleDo.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysModuleModifyResponse      : " + JsonConvertUtils.convertToString(sysModuleModifyResponse));
            logger.debug(" <<<<<<< end modifySysModule <<<<<<< ");
        }
        return sysModuleModifyResponse;
    }

    @Override
    public SysModuleInvalidateResponse invalidateSysModule(SysModuleInvalidateRequest sysModuleInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysModule >>>>>> ");
            logger.debug(" SysModuleInvalidateRequest   : " + JsonConvertUtils.convertToString(sysModuleInvalidateRequest));
        }
        SysModuleInvalidateResponse sysModuleInvalidateResponse = new SysModuleInvalidateResponse();
        sysModuleInvalidateResponse.setFailureDefault();
        SysModuleDo sysModuleDo = null;
        if(sysModuleInvalidateRequest != null && sysModuleInvalidateRequest.getModuleId() != null) {
            sysModuleDo = sysModuleDao.get(sysModuleInvalidateRequest.getModuleId());
        }
        if(sysModuleDo == null) {
            sysModuleInvalidateResponse.setFailure("SYS_PACKAGE_NOTEXIST", "该系统业务包不存在");
        }
        else {
            sysModuleDo.setValid(false);
            sysModuleDo.setInvalider(sysModuleInvalidateRequest.getInvalider());
            sysModuleDo.setGmtInvalid(System.currentTimeMillis());
            int result = sysModuleDao.update(sysModuleDo);
            if(result > 0) {
                sysModuleInvalidateResponse.setSuccess();
                sysModuleInvalidateResponse.setSysModule(sysModuleDao.get(sysModuleDo.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysModuleInvalidateResponse  : " + JsonConvertUtils.convertToString(sysModuleInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysModule <<<<<<< ");
        }
        return sysModuleInvalidateResponse;
    }

    @Override
    public SysModuleDeleteResponse deleteSysModule(SysModuleDeleteRequest sysModuleDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysModule >>>>>> ");
            logger.debug(" SysModuleDeleteRequest       : " + JsonConvertUtils.convertToString(sysModuleDeleteRequest));
        }
        SysModuleDeleteResponse sysModuleDeleteResponse = new SysModuleDeleteResponse();
        sysModuleDeleteResponse.setFailureDefault();
        SysModuleDo sysModuleDo = null;
        if(sysModuleDeleteRequest != null && sysModuleDeleteRequest.getModuleId() != null) {
            sysModuleDo = sysModuleDao.get(sysModuleDeleteRequest.getModuleId());
        }
        if(sysModuleDo == null) {
            sysModuleDeleteResponse.setFailure("SYS_MODULE_NOTEXIST", "该系统功能组件不存在");
        }
        else {
            int result = sysModuleDao.delete(sysModuleDo);
            if(result > 0) {
                sysModuleDeleteResponse.setSuccess();
                sysModuleDeleteResponse.setSysModule(sysModuleDao.get(sysModuleDo.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysPackageDeleteResponse         : " + JsonConvertUtils.convertToString(sysModuleDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysModule <<<<<<< ");
        }
        return sysModuleDeleteResponse;
    }

    @Override
    public SysModuleGetResponse getSysModule(SysModuleGetRequest sysModuleGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysModule >>>>>> ");
            logger.debug(" SysModuleGetRequest          : " + JsonConvertUtils.convertToString(sysModuleGetRequest));
        }
        SysModuleGetResponse sysModuleGetResponse = new SysModuleGetResponse();
        sysModuleGetResponse.setFailureDefault();
        SysModuleVo sysModuleVo = null;
        if(sysModuleGetRequest != null && sysModuleGetRequest.getModuleId() != null) {
            sysModuleVo = sysModuleDao.getSysModuleVo(sysModuleGetRequest.getModuleId());
        }
        else if(sysModuleGetRequest != null && StringUtils.isNotBlank(sysModuleGetRequest.getModuleCode())) {
            sysModuleVo = sysModuleDao.getSysModuleVoByModuleCode(sysModuleGetRequest.getModuleCode());
        }
        if(sysModuleVo == null) {
            sysModuleGetResponse.setFailure("SYS_MODULE_NOTEXIST", "该系统功能组件不存在");
        }
        else {
            sysModuleGetResponse.setSuccess();
            sysModuleGetResponse.setSysModule(sysModuleVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysModuleGetResponse        : " + JsonConvertUtils.convertToString(sysModuleGetResponse));
            logger.debug(" <<<<<<< end getSysModule <<<<<<< ");
        }
        return sysModuleGetResponse;
    }

    @Override
    public SysModuleQueryResponse querySysModule(SysModuleQueryRequest sysModuleQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysModule >>>>>> ");
            logger.debug(" SysModuleQueryRequest        : " + JsonConvertUtils.convertToString(sysModuleQueryRequest));
        }
        SysModuleQueryResponse sysModuleQueryResponse = new SysModuleQueryResponse();
        sysModuleQueryResponse.setFailureDefault();
        if(sysModuleQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("appId", sysModuleQueryRequest.getAppId());
            params.put("packageId", sysModuleQueryRequest.getPackageId());
            params.put("moduleCode", sysModuleQueryRequest.getModuleCode());
            params.put("moduleType", sysModuleQueryRequest.getModuleType());
            params.put("moduleName", sysModuleQueryRequest.getModuleName());
            params.put("moduleDesc", sysModuleQueryRequest.getModuleDesc());
            params.put("moduleActionPath", sysModuleQueryRequest.getModuleActionPath());
            params.put("moduleActionType", sysModuleQueryRequest.getModuleActionType());
            params.put("moduleLevel", sysModuleQueryRequest.getModuleLevel());
            params.put("parentId", sysModuleQueryRequest.getParentId());
            params.put("valid", sysModuleQueryRequest.getIsValid());
            params.put("userId", sysModuleQueryRequest.getUserId());
            int sysModuleCount = sysModuleDao.getSysModuleVoCount(params);
            List<SysModuleVo> sysModuleList = sysModuleDao.getSysModuleVoList(params, new Sorter("sort_sn", ""), new Pager(sysModuleQueryRequest.getPageNumber(), sysModuleQueryRequest.getPageSize()));
            sysModuleQueryResponse.setSuccess();
            sysModuleQueryResponse.setSysModuleCount(sysModuleCount);
            sysModuleQueryResponse.setSysModuleList(sysModuleList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysModuleQueryResponse       : " + JsonConvertUtils.convertToString(sysModuleQueryResponse));
            logger.debug(" <<<<<<< end querySysModule <<<<<<< ");
        }
        return sysModuleQueryResponse;
    }
}
