package com.easesource.system.openservices.basemgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.basemgmt.dao.SysAppDao;
import com.easesource.system.openservices.basemgmt.dao.SysPackageDao;
import com.easesource.system.openservices.basemgmt.entity.SysAppDo;
import com.easesource.system.openservices.basemgmt.entity.SysPackageDo;
import com.easesource.system.openservices.basemgmt.request.*;
import com.easesource.system.openservices.basemgmt.response.*;
import com.easesource.system.openservices.basemgmt.service.SysPackageService;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysPackageServiceImpl extends AbstractBaseService implements SysPackageService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final SysAppDao sysAppDao;
    private final SysPackageDao sysPackageDao;

    @Autowired
    public SysPackageServiceImpl(SysAppDao sysAppDao, SysPackageDao sysPackageDao) {
        this.sysAppDao = sysAppDao;
        this.sysPackageDao = sysPackageDao;
    }

    @Override
    public SysPackageCreateResponse createSysPackage(SysPackageCreateRequest sysPackageCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysPackage >>>>>> ");
            logger.debug(" SysPackageCreateRequest          : " + JsonConvertUtils.convertToString(sysPackageCreateRequest));
        }
        SysPackageCreateResponse sysPackageCreateResponse = new SysPackageCreateResponse();
        sysPackageCreateResponse.setFailureDefault();
        if(sysPackageCreateRequest != null && sysPackageCreateRequest.getAppId() != null) {
            SysAppDo sysAppDo = sysAppDao.get(sysPackageCreateRequest.getAppId());
            SysPackageDo sysPackageDo = sysPackageDao.getByPackageCode(sysPackageCreateRequest.getPackageCode());
            if(sysAppDo != null && sysPackageDo == null) {
                sysPackageDo = new SysPackageDo();
                sysPackageDo.setId(idGenerator.nextId());
                sysPackageDo.setAppId(sysPackageCreateRequest.getAppId());
                sysPackageDo.setPackageCode(sysPackageCreateRequest.getPackageCode());
                sysPackageDo.setPackageType(sysPackageCreateRequest.getPackageType());
                sysPackageDo.setPackageName(sysPackageCreateRequest.getPackageName());
                sysPackageDo.setPackageDesc(StringUtils.trimToEmpty(sysPackageCreateRequest.getPackageDesc()));
                sysPackageDo.setPackageLevel(sysPackageCreateRequest.getPackageLevel());
                sysPackageDo.setParentId(sysPackageCreateRequest.getParentId());
                sysPackageDo.setSortSn(sysPackageCreateRequest.getSortSn());
                sysPackageDo.setValid(true);
                sysPackageDo.setCreator(sysPackageCreateRequest.getCreator());
                sysPackageDo.setGmtCreate(System.currentTimeMillis());
                sysPackageDo.setModifier(sysPackageCreateRequest.getCreator());
                sysPackageDo.setGmtModified(System.currentTimeMillis());
                sysPackageDo.setInvalider("");
                sysPackageDo.setGmtInvalid(0L);
                sysPackageDo.setVersion(1);
                int result = sysPackageDao.insert(sysPackageDo);
                if(result > 0) {
                    sysPackageCreateResponse.setSuccess();
                    sysPackageCreateResponse.setSysPackage(sysPackageDao.get(sysPackageDo.getId()));
                }
            }
            else {
                if(sysAppDo == null) {
                    sysPackageCreateResponse.setFailure("SYS_APP_NOTEXIST", "系统应用不存在");
                }
                if(sysPackageDo != null) {
                    sysPackageCreateResponse.setFailure("SYS_PACKAGE_CODE_ISEXIST", "业务包编码已存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysPackageCreateResponse     : " + JsonConvertUtils.convertToString(sysPackageCreateResponse));
            logger.debug(" <<<<<<< end createSysPackage <<<<<<< ");
        }
        return sysPackageCreateResponse;
    }

    @Override
    public SysPackageModifyResponse modifySysPackage(SysPackageModifyRequest sysPackageModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysPackage >>>>>> ");
            logger.debug(" SysPackageModifyRequest      : " + JsonConvertUtils.convertToString(sysPackageModifyRequest));
        }
        SysPackageModifyResponse sysPackageModifyResponse = new SysPackageModifyResponse();
        sysPackageModifyResponse.setFailureDefault();
        if(sysPackageModifyRequest != null && sysPackageModifyRequest.getPackageId() != null && StringUtils.isNotBlank(sysPackageModifyRequest.getPackageCode())) {
            SysPackageDo sysPackageDo = sysPackageDao.get(sysPackageModifyRequest.getPackageId());
            if(sysPackageDo == null) {
                sysPackageModifyResponse.setFailure("SYS_PACKAGE_NOTEXIST", "该业务包不存在");
            }
            else {
                SysAppDo sysAppDo = sysAppDao.get(sysPackageModifyRequest.getAppId());
                if(sysAppDo == null) {
                    sysPackageModifyResponse.setFailure("SYS_APP_NOTEXIST", "该系统应用不存在");
                }
                sysPackageDo.setAppId(sysPackageModifyRequest.getAppId());
                sysPackageDo.setPackageCode(StringUtils.trim(sysPackageModifyRequest.getPackageCode()));
                sysPackageDo.setPackageType(sysPackageModifyRequest.getPackageType());
                sysPackageDo.setPackageName(sysPackageModifyRequest.getPackageName());
                sysPackageDo.setPackageDesc(StringUtils.trimToEmpty(sysPackageModifyRequest.getPackageDesc()));
                sysPackageDo.setPackageLevel(sysPackageModifyRequest.getPackageLevel());
                sysPackageDo.setParentId(sysPackageModifyRequest.getParentId());
                sysPackageDo.setSortSn(sysPackageModifyRequest.getSortSn());
                sysPackageDo.setModifier(sysPackageModifyRequest.getModifier());
                sysPackageDo.setGmtModified(System.currentTimeMillis());
                int result = sysPackageDao.update(sysPackageDo);
                if(result > 0) {
                    sysPackageModifyResponse.setSuccess();
                    sysPackageModifyResponse.setSysPackage(sysPackageDao.get(sysPackageDo.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysPackageModifyResponse     : " + JsonConvertUtils.convertToString(sysPackageModifyResponse));
            logger.debug(" <<<<<<< end modifySysPackage <<<<<<< ");
        }
        return sysPackageModifyResponse;
    }

    @Override
    public SysPackageInvalidateResponse invalidateSysPackage(SysPackageInvalidateRequest sysPackageInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysPackage >>>>>> ");
            logger.debug(" SysPackageInvalidateRequest  : " + JsonConvertUtils.convertToString(sysPackageInvalidateRequest));
        }
        SysPackageInvalidateResponse sysPackageInvalidateResponse = new SysPackageInvalidateResponse();
        sysPackageInvalidateResponse.setFailureDefault();
        SysPackageDo sysPackageDo = null;
        if(sysPackageInvalidateRequest != null && sysPackageInvalidateRequest.getPackageId() != null) {
            sysPackageDo = sysPackageDao.get(sysPackageInvalidateRequest.getPackageId());
        }
        if(sysPackageDo == null) {
            sysPackageInvalidateResponse.setFailure("SYS_PACKAGE_NOTEXIST", "该系统业务包不存在");
        }
        else {
            sysPackageDo.setValid(false);
            sysPackageDo.setInvalider(sysPackageInvalidateRequest.getInvalider());
            sysPackageDo.setGmtInvalid(System.currentTimeMillis());
            int result = sysPackageDao.update(sysPackageDo);
            if(result > 0) {
                sysPackageInvalidateResponse.setSuccess();
                sysPackageInvalidateResponse.setSysPackage(sysPackageDao.get(sysPackageDo.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysPackageInvalidateResponse : " + JsonConvertUtils.convertToString(sysPackageInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysPackage <<<<<<< ");
        }
        return sysPackageInvalidateResponse;
    }

    @Override
    public SysPackageDeleteResponse deleteSysPackage(SysPackageDeleteRequest sysPackageDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysPackage >>>>>> ");
            logger.debug(" SysPackageDeleteRequest      : " + JsonConvertUtils.convertToString(sysPackageDeleteRequest));
        }
        SysPackageDeleteResponse sysPackageDeleteResponse = new SysPackageDeleteResponse();
        sysPackageDeleteResponse.setFailureDefault();
        SysPackageDo sysPackageDo = null;
        if(sysPackageDeleteRequest != null && sysPackageDeleteRequest.getPackageId() != null) {
            sysPackageDo = sysPackageDao.get(sysPackageDeleteRequest.getPackageId());
        }
        if(sysPackageDo == null) {
            sysPackageDeleteResponse.setFailure("SYS_PACKAGE_NOTEXIST", "该系统业务包不存在");
        }
        else {
            int result = sysPackageDao.delete(sysPackageDo);
            if(result > 0) {
                sysPackageDeleteResponse.setSuccess();
                sysPackageDeleteResponse.setSysPackage(sysPackageDo);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysPackageDeleteResponse         : " + JsonConvertUtils.convertToString(sysPackageDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysPackage <<<<<<< ");
        }
        return sysPackageDeleteResponse;
    }

    @Override
    public SysPackageGetResponse getSysPackage(SysPackageGetRequest sysPackageGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysPackage >>>>>> ");
            logger.debug(" SysPackageGetRequest         : " + JsonConvertUtils.convertToString(sysPackageGetRequest));
        }
        SysPackageGetResponse sysPackageGetResponse = new SysPackageGetResponse();
        sysPackageGetResponse.setFailureDefault();
        SysPackageDo sysPackageDo = null;
        if(sysPackageGetRequest != null && sysPackageGetRequest.getPackageId() != null) {
            sysPackageDo = sysPackageDao.get(sysPackageGetRequest.getPackageId());
        }
        else if(sysPackageGetRequest != null && StringUtils.isNotBlank(sysPackageGetRequest.getPackageCode())) {
            sysPackageDo = sysPackageDao.getByPackageCode(sysPackageGetRequest.getPackageCode());
        }
        if(sysPackageDo == null) {
            sysPackageGetResponse.setFailure("SYS_PACKAGE_NOTEXIST", "该系统业务包不存在");
        }
        else {
            sysPackageGetResponse.setSuccess();
            sysPackageGetResponse.setSysPackage(sysPackageDo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysPackageGetResponse        : " + JsonConvertUtils.convertToString(sysPackageGetResponse));
            logger.debug(" <<<<<<< end getSysPackage <<<<<<< ");
        }
        return sysPackageGetResponse;
    }

    @Override
    public SysPackageQueryResponse querySysPackage(SysPackageQueryRequest sysPackageQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysPackage >>>>>> ");
            logger.debug(" SysPackageQueryRequest       : " + JsonConvertUtils.convertToString(sysPackageQueryRequest));
        }
        SysPackageQueryResponse sysPackageQueryResponse = new SysPackageQueryResponse();
        sysPackageQueryResponse.setFailureDefault();
        if(sysPackageQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("appId", sysPackageQueryRequest.getAppId());
            params.put("packageCode", sysPackageQueryRequest.getPackageCode());
            params.put("packageType", sysPackageQueryRequest.getPackageType());
            params.put("packageName", sysPackageQueryRequest.getPackageName());
            params.put("packageDesc", sysPackageQueryRequest.getPackageDesc());
            params.put("packageLevel", sysPackageQueryRequest.getPackageLevel());
            params.put("parentId", sysPackageQueryRequest.getParentId());
            params.put("valid", sysPackageQueryRequest.getIsValid());
            params.put("userId", sysPackageQueryRequest.getUserId());
            int sysPackageDoCount = sysPackageDao.getCount(params);
            List<SysPackageDo> sysPackageDoList = sysPackageDao.getList(params, new Sorter("sort_sn", ""), new Pager(sysPackageQueryRequest.getPageNumber(), sysPackageQueryRequest.getPageSize()));
            sysPackageQueryResponse.setSuccess();
            sysPackageQueryResponse.setSysPackageCount(sysPackageDoCount);
            sysPackageQueryResponse.setSysPackageList(sysPackageDoList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysPackageQueryResponse          : " + JsonConvertUtils.convertToString(sysPackageQueryResponse));
            logger.debug(" <<<<<<< end querySysPackage <<<<<<< ");
        }
        return sysPackageQueryResponse;
    }

}
