package com.easesource.system.openservices.orgmgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.orgmgmt.entity.SysDeptDo;
import com.easesource.system.openservices.orgmgmt.entity.SysDeptVo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
public interface SysDeptDao extends CrudMapper<SysDeptDo, String> {

    Map<String, Object> getMaxChildDeptMap(@Param("orgNo") String orgNo, @Param("deptNo") String deptNo);

    /**
     * 通过系统部门编号获取系统部门视图
     *
     * @param deptNo
     *          系统部门编号
     * @return  系统部门视图
     */
    SysDeptVo getSysDeptVo(@Param("deptNo") String deptNo);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysDeptVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysDeptVo> getSysDeptVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
