package com.easesource.system.openservices.orgmgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgExtDo;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgExtVo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-18
 */
public interface SysOrgExtDao extends CrudMapper<SysOrgExtDo, Long> {

    /**
     * 通过单位编号和扩展属性键获取系统单位扩展
     *
     * @param orgNo
     *          单位编号
     * @param extAttrKey
     *          扩展属性键
     * @return
     *          系统单位扩展
     */
    SysOrgExtDo getByOrgNoAndAttrKey(@Param("orgNo") String orgNo, @Param("extAttrKey") String extAttrKey);

    /**
     * 获取实体
     *
     * @param id
     *          实体主键
     * @return
     *          实体
     */
    SysOrgExtVo getSysOrgExtVo(Long id);

    /**
     * 通过单位编号和扩展属性键获取系统单位扩展
     *
     * @param orgNo
     *          单位编号
     * @param extAttrKey
     *         扩展属性键
     * @return
     *          系统单位扩展
     */
    SysOrgExtVo getSysOrgExtVoByOrgNoAndAttrKey(@Param("orgNo") String orgNo, @Param("extAttrKey") String extAttrKey);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysOrgExtVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysOrgExtVo> getSysOrgExtVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
