package com.easesource.system.openservices.orgmgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.orgmgmt.entity.SysUserDo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
public interface SysUserDao extends CrudMapper<SysUserDo, Long> {

    /**
     * 通过用户编号获取系统用户
     * @param userNo
     *          用户编号
     * @return
     *          系统用户
     */
    SysUserDo getByUserNo(@Param("userNo") String userNo);

    /**
     * 通过用户标识获取系统用户视图
     *
     * @param userId
     *          用户标识
     * @return  系统用户视图
     */
    SysUserVo getSysUserVo(Long userId);

    /**
     * 通过用户编号获取系统用户视图
     *
     * @param userNo
     *          用户编号
     * @return  系统用户视图
     */
    SysUserVo getSysUserVoByUserNo(@Param("userNo") String userNo);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysUserVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysUserVo> getSysUserVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
