package com.easesource.system.openservices.orgmgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgExtVo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserExtDo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserExtVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
public interface SysUserExtDao extends CrudMapper<SysUserExtDo, Long> {

    /**
     * 通过用户标识和扩展属性键获取系统用户扩展
     *
     * @param userId
     *          用户标识
     * @param extAttrKey
     *          扩展属性键
     * @return
     *          系统用户扩展
     */
    SysUserExtDo getByUserIdAndAttrKey(@Param("userId") Long userId, @Param("extAttrKey") String extAttrKey);

    /**
     * 通过用户标识和扩展属性键获取系统用户扩展
     *
     * @param userId
     *          用户标识
     * @param extAttrKey
     *          扩展属性键
     * @return
     *          系统用户扩展视图
     */
    SysUserExtVo getSysUserExtVoByUserIdAndAttrKey(@Param("userId") Long userId, @Param("extAttrKey") String extAttrKey);

    /**
     * 查询结果个数
     *
     * @param params
     *          查询参数
     * @return
     *          查询结果个数
     */
    int getSysUserExtVoCount(@Param("params") Map<String, Object> params);

    /**
     * 查询结果列表
     *
     * @param params
     *          查询参数
     * @param sorter
     *          排序
     * @param pager
     *          分页
     * @return
     *          查询结果列表
     */
    List<SysUserExtVo> getSysUserExtVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

}
