package com.easesource.system.openservices.orgmgmt.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.orgmgmt.entity.SysUserExtbizDo;
import org.apache.ibatis.annotations.Param;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
public interface SysUserExtbizDao extends CrudMapper<SysUserExtbizDo, Long> {

    /**
     * 通过用户标识和业务扩展属性键获取系统用户（业务扩展）
     *
     * @param userId
     *          用户标识
     * @param extbizAttrKey
     *          业务扩展属性键
     * @return
     *          系统用户（业务扩展）
     */
    SysUserExtbizDo getByUserIdAndAttrKey(@Param("userId") Long userId, @Param("extbizAttrKey") String extbizAttrKey);

}
