package com.easesource.system.openservices.orgmgmt.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.system.openservices.authmgmt.entity.SysRoleDo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserRoleDo;
import com.easesource.system.openservices.orgmgmt.request.SysUserRoleGetRequest;
import com.easesource.system.openservices.orgmgmt.response.SysUserRoleGetResponse;
import org.apache.ibatis.annotations.Param;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
public interface SysUserRoleDao extends CrudMapper<SysUserRoleDo, Long> {

    /**
     * 通过用户标识或角色标识删除系统用户角色关系
     *
     * @param userId
     *          用户标识
     * @param roleId
     *          角色标识
     * @return
     *          删除结果
     */
    int deleteByUserIdOrRoleId(@Param("userId") Long userId, @Param("roleId") Long roleId);

    /**
     * 通过用户标识和角色标识获取系统用户角色关系
     *
     * @param userId
     *          用户标识
     * @param roleId
     *          角色标识
     * @return
     *          系统用户角色关系
     */
    SysUserRoleDo getByUserIdAndRoleId(@Param("userId") Long userId, @Param("roleId") String roleId);

    SysRoleDo getSysUserRole(@Param("param") SysUserRoleGetRequest request);

}
