package com.easesource.system.openservices.orgmgmt.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.easesource.system.openservices.orgmgmt.dao.SysDeptDao;
import com.easesource.system.openservices.orgmgmt.dao.SysDeptExtDao;
import com.easesource.system.openservices.orgmgmt.dao.SysDeptExtbizDao;
import com.easesource.system.openservices.orgmgmt.dao.SysOrgDao;
import com.easesource.system.openservices.orgmgmt.entity.SysDeptDo;
import com.easesource.system.openservices.orgmgmt.entity.SysDeptVo;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgDo;
import com.easesource.system.openservices.orgmgmt.request.*;
import com.easesource.system.openservices.orgmgmt.response.*;
import com.easesource.system.openservices.orgmgmt.service.SysDeptService;
import com.easesource.system.openservices.util.EaseSystemOrgmgmtUtils;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysDeptServiceImpl extends AbstractBaseService implements SysDeptService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final SysOrgDao sysOrgDao;
    private final SysDeptDao sysDeptDao;
    private final SysDeptExtDao sysDeptExtDao;
    private final SysDeptExtbizDao sysDeptExtbizDao;

    @Autowired
    public SysDeptServiceImpl(SysOrgDao sysOrgDao, SysDeptDao sysDeptDao, SysDeptExtDao sysDeptExtDao, SysDeptExtbizDao sysDeptExtbizDao) {
        this.sysOrgDao = sysOrgDao;
        this.sysDeptDao = sysDeptDao;
        this.sysDeptExtDao = sysDeptExtDao;
        this.sysDeptExtbizDao = sysDeptExtbizDao;
    }

    @Override
    public Map<String, Object> getMaxChildDeptMap(String orgNo, String deptNo) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getMaxChildDeptMap >>>>>> ");
            logger.debug(" orgNo    : " + orgNo);
            logger.debug(" deptNo   : " + deptNo);
        }
        return sysDeptDao.getMaxChildDeptMap(orgNo, deptNo);
    }

    @Override
    public SysDeptCreateResponse createSysDept(SysDeptCreateRequest sysDeptCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysDept >>>>>> ");
            logger.debug(" SysDeptCreateRequest             : " + JsonConvertUtils.convertToString(sysDeptCreateRequest));
        }
        SysDeptCreateResponse sysDeptCreateResponse = new SysDeptCreateResponse();
        sysDeptCreateResponse.setFailureDefault();
        if(sysDeptCreateRequest != null && StringUtils.isNotBlank(sysDeptCreateRequest.getOrgNo())) {
            SysOrgDo sysOrg = sysOrgDao.get(sysDeptCreateRequest.getOrgNo());
            String newDeptNo = EaseSystemOrgmgmtUtils.generateNextChildDeptNo(sysDeptCreateRequest.getOrgNo(), sysDeptCreateRequest.getParentDeptNo());
            SysDeptDo sysDept = sysDeptDao.get(newDeptNo);
            if(sysOrg != null && sysDept == null) {
                sysDept = new SysDeptDo();
                sysDept.setDeptNo(newDeptNo);
                sysDept.setOrgNo(sysDeptCreateRequest.getOrgNo());
                sysDept.setDeptType(sysDeptCreateRequest.getDeptType());
                sysDept.setDeptName(sysDeptCreateRequest.getDeptName());
                sysDept.setDeptAbbr(sysDeptCreateRequest.getDeptAbbr());
                sysDept.setDeptDesc(sysDeptCreateRequest.getDeptDesc());
                sysDept.setDeptLevel(sysDeptCreateRequest.getDeptLevel());
                sysDept.setParentDeptNo(sysDeptCreateRequest.getParentDeptNo());
                sysDept.setSortSn(sysDeptCreateRequest.getSortSn());
                sysDept.setValid(true);
                sysDept.setCreator(sysDeptCreateRequest.getCreator());
                sysDept.setGmtCreate(System.currentTimeMillis());
                sysDept.setModifier(sysDeptCreateRequest.getCreator());
                sysDept.setGmtModified(System.currentTimeMillis());
                sysDept.setInvalider("");
                sysDept.setGmtInvalid(0L);
                sysDept.setVersion(1);
                int result = sysDeptDao.insert(sysDept);
                if(result > 0) {
                    sysDeptCreateResponse.setSuccess();
                    sysDeptCreateResponse.setSysDept(sysDeptDao.get(sysDept.getDeptNo()));
                }
            }
            else {
                if(sysOrg == null) {
                    sysDeptCreateResponse.setFailure("SYS_ORG_NOTEXIST", "系统单位不存在");
                }
                if(sysDept != null) {
                    sysDeptCreateResponse.setFailure("SYS_DEPT_NO_ISEXIST", "系统部门编号已存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysDeptCreateResponse            : " + JsonConvertUtils.convertToString(sysDeptCreateResponse));
            logger.debug(" <<<<<<< end createSysDept <<<<<<< ");
        }
        return sysDeptCreateResponse;
    }

    @Override
    public SysDeptModifyResponse modifySysDept(SysDeptModifyRequest sysDeptModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysDept >>>>>> ");
            logger.debug(" SysDeptModifyRequest             : " + JsonConvertUtils.convertToString(sysDeptModifyRequest));
        }
        SysDeptModifyResponse sysDeptModifyResponse = new SysDeptModifyResponse();
        sysDeptModifyResponse.setFailureDefault();
        if(sysDeptModifyRequest != null && sysDeptModifyRequest.getDeptNo() != null) {
            SysDeptDo sysDept = sysDeptDao.get(sysDeptModifyRequest.getDeptNo());
            if(sysDept == null) {
                sysDeptModifyResponse.setFailure("SYS_DEPT_NOTEXIST", "系统部门不存在");
            }
            else {
                if(sysDeptModifyRequest.getDeptType() != null) {
                    sysDept.setDeptType(sysDeptModifyRequest.getDeptType());
                }
                if(sysDeptModifyRequest.getDeptName() != null) {
                    sysDept.setDeptName(sysDeptModifyRequest.getDeptName());
                }
                if(sysDeptModifyRequest.getDeptAbbr() != null) {
                    sysDept.setDeptAbbr(sysDeptModifyRequest.getDeptAbbr());
                }
                if(sysDeptModifyRequest.getDeptDesc() != null) {
                    sysDept.setDeptDesc(sysDeptModifyRequest.getDeptDesc());
                }
                if(sysDeptModifyRequest.getDeptLevel() != null) {
                    sysDept.setDeptLevel(sysDeptModifyRequest.getDeptLevel());
                }
                if(sysDeptModifyRequest.getParentDeptNo() != null) {
                    sysDept.setParentDeptNo(sysDeptModifyRequest.getParentDeptNo());
                }
                if(sysDeptModifyRequest.getSortSn() != null) {
                    sysDept.setSortSn(sysDeptModifyRequest.getSortSn());
                }
                sysDept.setModifier(sysDeptModifyRequest.getModifier());
                sysDept.setGmtModified(System.currentTimeMillis());
                int result = sysDeptDao.update(sysDept);
                if(result > 0) {
                    sysDeptModifyResponse.setSuccess();
                    sysDeptModifyResponse.setSysDept(sysDeptDao.get(sysDept.getDeptNo()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysDeptModifyResponse            : " + JsonConvertUtils.convertToString(sysDeptModifyResponse));
            logger.debug(" <<<<<<< end modifySysDept <<<<<<< ");
        }
        return sysDeptModifyResponse;
    }

    @Override
    public SysDeptInvalidateResponse invalidateSysDept(SysDeptInvalidateRequest sysDeptInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysDept >>>>>> ");
            logger.debug(" SysDeptInvalidateRequest         : " + JsonConvertUtils.convertToString(sysDeptInvalidateRequest));
        }
        SysDeptInvalidateResponse sysDeptInvalidateResponse = new SysDeptInvalidateResponse();
        sysDeptInvalidateResponse.setFailureDefault();
        SysDeptDo sysDept = null;
        if(sysDeptInvalidateRequest != null && sysDeptInvalidateRequest.getDeptNo() != null) {
            sysDept = sysDeptDao.get(sysDeptInvalidateRequest.getDeptNo());
        }
        if(sysDept == null) {
            sysDeptInvalidateResponse.setFailure("SYS_DEPT_NOTEXIST", "该系统部门不存在");
        }
        else {
            sysDept.setValid(false);
            sysDept.setInvalider(sysDeptInvalidateRequest.getInvalider());
            sysDept.setGmtInvalid(System.currentTimeMillis());
            int result = sysDeptDao.update(sysDept);
            if(result > 0) {
                sysDeptInvalidateResponse.setSuccess();
                sysDeptInvalidateResponse.setSysDept(sysDeptDao.get(sysDept.getDeptNo()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysDeptInvalidateResponse        : " + JsonConvertUtils.convertToString(sysDeptInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysDept <<<<<<< ");
        }
        return sysDeptInvalidateResponse;
    }

    @Override
    public SysDeptDeleteResponse deleteSysDept(SysDeptDeleteRequest sysDeptDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysDept >>>>>> ");
            logger.debug(" SysDeptDeleteRequest         : " + JsonConvertUtils.convertToString(sysDeptDeleteRequest));
        }
        SysDeptDeleteResponse sysDeptDeleteResponse = new SysDeptDeleteResponse();
        sysDeptDeleteResponse.setFailureDefault();
        SysDeptDo sysDeptDo = null;
        if(sysDeptDeleteRequest != null && sysDeptDeleteRequest.getDeptNo() != null) {
            sysDeptDo = sysDeptDao.get(sysDeptDeleteRequest.getDeptNo());
        }
        if(sysDeptDo == null) {
            sysDeptDeleteResponse.setFailure("SYS_DEPT_NOTEXIST", "该系统部门不存在");
        }
        else {
            int result = sysDeptDao.delete(sysDeptDo);
            if(result > 0) {
                sysDeptDeleteResponse.setSuccess();
                sysDeptDeleteResponse.setSysDept(sysDeptDo);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysDeptDeleteResponse        : " + JsonConvertUtils.convertToString(sysDeptDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysDept <<<<<<< ");
        }
        return sysDeptDeleteResponse;
    }

    @Override
    public SysDeptGetResponse getSysDept(SysDeptGetRequest sysDeptGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysDept >>>>>> ");
            logger.debug(" SysDeptGetRequest                : " + JsonConvertUtils.convertToString(sysDeptGetRequest));
        }
        SysDeptGetResponse sysDeptGetResponse = new SysDeptGetResponse();
        sysDeptGetResponse.setFailureDefault();
        SysDeptVo sysDept = null;
        if(sysDeptGetRequest != null && sysDeptGetRequest.getDeptNo() != null) {
            sysDept = sysDeptDao.getSysDeptVo(sysDeptGetRequest.getDeptNo());
        }

        if(sysDept == null) {
            sysDeptGetResponse.setFailure("SYS_DEPT_NOTEXIST", "该系统部门不存在");
        }
        else {
            sysDeptGetResponse.setSuccess();
            sysDeptGetResponse.setSysDept(sysDept);
            Map<String, Object> params = Maps.newHashMap();
            params.put("deptNo", sysDept.getDeptNo());
            sysDeptGetResponse.setSysDeptExtList(sysDeptExtDao.getList(params, null, null));
            sysDeptGetResponse.setSysDeptExtbizList(sysDeptExtbizDao.getList(params, null, null));
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysDeptGetResponse               : " + JsonConvertUtils.convertToString(sysDeptGetResponse));
            logger.debug(" <<<<<<< end getSysDept <<<<<<< ");
        }
        return sysDeptGetResponse;
    }

    @Override
    public SysDeptQueryResponse querySysDept(SysDeptQueryRequest sysDeptQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysDept >>>>>> ");
            logger.debug(" SysDeptQueryRequest              : " + JsonConvertUtils.convertToString(sysDeptQueryRequest));
        }
        SysDeptQueryResponse sysDeptQueryResponse = new SysDeptQueryResponse();
        sysDeptQueryResponse.setFailureDefault();
        if(sysDeptQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("orgNo", sysDeptQueryRequest.getOrgNo());
            params.put("deptNo", sysDeptQueryRequest.getDeptNo());
            params.put("deptType", sysDeptQueryRequest.getDeptType());
            params.put("deptName", sysDeptQueryRequest.getDeptName());
            params.put("deptAbbr", sysDeptQueryRequest.getDeptAbbr());
            params.put("deptDesc", sysDeptQueryRequest.getDeptDesc());
            params.put("deptLevel", sysDeptQueryRequest.getDeptLevel());
            params.put("parentDeptNo", sysDeptQueryRequest.getParentDeptNo());
            params.put("valid", sysDeptQueryRequest.getIsValid());
            int sysDeptCount = sysDeptDao.getSysDeptVoCount(params);
            List<SysDeptVo> sysDeptList = sysDeptDao.getSysDeptVoList(
                params,
                new Sorter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sysDeptQueryRequest.getOrderCol()), StringUtils.lowerCase(sysDeptQueryRequest.getOrderDir())),
                new Pager(sysDeptQueryRequest.getPageNumber(), sysDeptQueryRequest.getPageSize()));
            sysDeptQueryResponse.setSuccess();
            sysDeptQueryResponse.setSysDeptCount(sysDeptCount);
            sysDeptQueryResponse.setSysDeptList(sysDeptList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysDeptQueryResponse             : " + JsonConvertUtils.convertToString(sysDeptQueryResponse));
            logger.debug(" <<<<<<< end querySysDept <<<<<<< ");
        }
        return sysDeptQueryResponse;
    }

    @Override
    public SysDeptExtCreateResponse createSysDeptExt(SysDeptExtCreateRequest sysDeptExtCreateRequest) {
        return null;
    }

    @Override
    public SysDeptExtModifyResponse modifySysDeptExt(SysDeptExtModifyRequest sysDeptExtModifyRequest) {
        return null;
    }

    @Override
    public SysDeptExtInvalidateResponse invalidateSysDeptExt(SysDeptExtInvalidateRequest sysDeptExtInvalidateRequest) {
        return null;
    }

    @Override
    public SysDeptExtDeleteResponse deleteSysDeptExt(SysDeptExtDeleteRequest sysDeptExtDeleteRequest) {
        return null;
    }

    @Override
    public SysDeptExtGetResponse getSysDeptExt(SysDeptExtGetRequest sysDeptExtGetRequest) {
        return null;
    }

    @Override
    public SysDeptExtQueryResponse querySysDeptExt(SysDeptExtQueryRequest sysDeptExtQueryRequest) {
        return null;
    }

    @Override
    public SysDeptExtbizCreateResponse createSysDeptExtbiz(SysDeptExtbizCreateRequest sysDeptExtbizCreateRequest) {
        return null;
    }

    @Override
    public SysDeptExtbizModifyResponse modifySysDeptExtbiz(SysDeptExtbizModifyRequest sysDeptExtbizModifyRequest) {
        return null;
    }

    @Override
    public SysDeptExtbizInvalidateResponse invalidateSysDeptExtbiz(SysDeptExtbizInvalidateRequest sysDeptExtbizInvalidateRequest) {
        return null;
    }

    @Override
    public SysDeptExtbizDeleteResponse deleteSysDeptExtbiz(SysDeptExtbizDeleteRequest sysDeptExtbizDeleteRequest) {
        return null;
    }

    @Override
    public SysDeptExtbizGetResponse getSysDeptExtbiz(SysDeptExtbizGetRequest sysDeptExtbizGetRequest) {
        return null;
    }

    @Override
    public SysDeptExtbizQueryResponse querySysDeptExtbiz(SysDeptExtbizQueryRequest sysDeptExtbizQueryRequest) {
        return null;
    }

}
