package com.easesource.system.openservices.orgmgmt.service.impl;

import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.easesource.system.openservices.orgmgmt.dao.SysOrgDao;
import com.easesource.system.openservices.orgmgmt.dao.SysOrgExtDao;
import com.easesource.system.openservices.orgmgmt.dao.SysOrgExtbizDao;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgDo;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgExtDo;
import com.easesource.system.openservices.orgmgmt.entity.SysOrgExtVo;
import com.easesource.system.openservices.orgmgmt.request.*;
import com.easesource.system.openservices.orgmgmt.response.*;
import com.easesource.system.openservices.orgmgmt.service.SysOrgService;
import com.easesource.system.openservices.util.EaseSystemOrgmgmtUtils;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysOrgServiceImpl extends AbstractBaseService implements SysOrgService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final SysOrgDao sysOrgDao;
    private final SysOrgExtDao sysOrgExtDao;
    private final SysOrgExtbizDao sysOrgExtbizDao;

    @Autowired
    public SysOrgServiceImpl(SysOrgDao sysOrgDao, SysOrgExtDao sysOrgExtDao, SysOrgExtbizDao sysOrgExtbizDao) {
        this.sysOrgDao = sysOrgDao;
        this.sysOrgExtDao = sysOrgExtDao;
        this.sysOrgExtbizDao = sysOrgExtbizDao;
    }

    @Override
    public String getMaxChildOrgNo(String orgNo) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getMaxChildOrgNo >>>>>> ");
            logger.debug(" orgNo    : " + orgNo);
        }
        return sysOrgDao.getMaxChildOrgNo(orgNo);
    }

    @Override
    public SysOrgCreateResponse createSysOrg(SysOrgCreateRequest sysOrgCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysOrg >>>>>> ");
            logger.debug(" SysOrgCreateRequest              : " + JsonConvertUtils.convertToString(sysOrgCreateRequest));
        }
        SysOrgCreateResponse sysOrgCreateResponse = new SysOrgCreateResponse();
        sysOrgCreateResponse.setFailureDefault();
        if(sysOrgCreateRequest != null && StringUtils.isNotBlank(sysOrgCreateRequest.getParentOrgNo())) {
            String newOrgNo = EaseSystemOrgmgmtUtils.generateNextChildOrgNo(sysOrgCreateRequest.getParentOrgNo());
            SysOrgDo sysOrg = sysOrgDao.get(newOrgNo);
            if(sysOrg == null) {
                sysOrg = new SysOrgDo();
                sysOrg.setOrgNo(newOrgNo);
                sysOrg.setOrgType(sysOrgCreateRequest.getOrgType());
                sysOrg.setOrgName(sysOrgCreateRequest.getOrgName());
                sysOrg.setOrgAbbr(sysOrgCreateRequest.getOrgAbbr());
                sysOrg.setOrgDesc(sysOrgCreateRequest.getOrgDesc());
                sysOrg.setOrgLevel(sysOrgCreateRequest.getOrgLevel());
                sysOrg.setOrgMaxLevel(sysOrgCreateRequest.getOrgMaxLevel());
                sysOrg.setParentOrgNo(sysOrgCreateRequest.getParentOrgNo());
                sysOrg.setSortSn(sysOrgCreateRequest.getSortSn());
                sysOrg.setValid(true);
                sysOrg.setCreator(sysOrgCreateRequest.getCreator());
                sysOrg.setGmtCreate(System.currentTimeMillis());
                sysOrg.setModifier(sysOrgCreateRequest.getCreator());
                sysOrg.setGmtModified(System.currentTimeMillis());
                sysOrg.setInvalider("");
                sysOrg.setGmtInvalid(0L);
                sysOrg.setVersion(1);
                int result = sysOrgDao.insert(sysOrg);
                if(result > 0) {
                    sysOrgCreateResponse.setSuccess();
                    sysOrgCreateResponse.setSysOrg(sysOrgDao.get(sysOrg.getOrgNo()));
                }
            }
            else {
                sysOrgCreateResponse.setFailure("SYS_ORG_NO_ISEXIST", "系统单位编号已存在");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgCreateResponse            : " + JsonConvertUtils.convertToString(sysOrgCreateResponse));
            logger.debug(" <<<<<<< end createSysOrg <<<<<<< ");
        }
        return sysOrgCreateResponse;
    }

    @Override
    public SysOrgModifyResponse modifySysOrg(SysOrgModifyRequest sysOrgModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysOrg >>>>>> ");
            logger.debug(" SysOrgModifyRequest              : " + JsonConvertUtils.convertToString(sysOrgModifyRequest));
        }
        SysOrgModifyResponse sysOrgModifyResponse = new SysOrgModifyResponse();
        sysOrgModifyResponse.setFailureDefault();
        if(sysOrgModifyRequest != null && sysOrgModifyRequest.getOrgNo() != null) {
            SysOrgDo sysOrg = sysOrgDao.get(sysOrgModifyRequest.getOrgNo());
            if(sysOrg == null) {
                sysOrgModifyResponse.setFailure("SYS_ORG_NOTEXIST", "系统单位不存在");
            }
            else {
                if(sysOrgModifyRequest.getOrgType() != null) {
                    sysOrg.setOrgType(sysOrgModifyRequest.getOrgType());
                }
                if(sysOrgModifyRequest.getOrgName() != null) {
                    sysOrg.setOrgName(sysOrgModifyRequest.getOrgName());
                }
                if(sysOrgModifyRequest.getOrgAbbr() != null) {
                    sysOrg.setOrgAbbr(sysOrgModifyRequest.getOrgAbbr());
                }
                if(sysOrgModifyRequest.getOrgDesc() != null) {
                    sysOrg.setOrgDesc(sysOrgModifyRequest.getOrgDesc());
                }
                if(sysOrgModifyRequest.getOrgLevel() != null) {
                    sysOrg.setOrgLevel(sysOrgModifyRequest.getOrgLevel());
                }
                if(sysOrgModifyRequest.getOrgMaxLevel() != null) {
                    sysOrg.setOrgMaxLevel(sysOrgModifyRequest.getOrgMaxLevel());
                }
                if(sysOrgModifyRequest.getParentOrgNo() != null) {
                    sysOrg.setParentOrgNo(sysOrgModifyRequest.getParentOrgNo());
                }
                if(sysOrgModifyRequest.getSortSn() != null) {
                    sysOrg.setSortSn(sysOrgModifyRequest.getSortSn());
                }
                sysOrg.setModifier(sysOrgModifyRequest.getModifier());
                sysOrg.setGmtModified(System.currentTimeMillis());
                int result = sysOrgDao.update(sysOrg);
                if(result > 0) {
                    sysOrgModifyResponse.setSuccess();
                    sysOrgModifyResponse.setSysOrg(sysOrgDao.get(sysOrg.getOrgNo()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgModifyResponse             : " + JsonConvertUtils.convertToString(sysOrgModifyResponse));
            logger.debug(" <<<<<<< end modifySysOrg <<<<<<< ");
        }
        return sysOrgModifyResponse;
    }

    @Override
    public SysOrgInvalidateResponse invalidateSysOrg(SysOrgInvalidateRequest sysOrgInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysOrg >>>>>> ");
            logger.debug(" SysOrgInvalidateRequest          : " + JsonConvertUtils.convertToString(sysOrgInvalidateRequest));
        }
        SysOrgInvalidateResponse sysOrgInvalidateResponse = new SysOrgInvalidateResponse();
        sysOrgInvalidateResponse.setFailureDefault();
        SysOrgDo sysOrg = null;
        if(sysOrgInvalidateRequest != null && sysOrgInvalidateRequest.getOrgNo() != null) {
            sysOrg = sysOrgDao.get(sysOrgInvalidateRequest.getOrgNo());
        }
        if(sysOrg == null) {
            sysOrgInvalidateResponse.setFailure("SYS_ORG_NOTEXIST", "该系统单位不存在");
        }
        else {
            sysOrg.setValid(false);
            sysOrg.setInvalider(sysOrgInvalidateRequest.getInvalider());
            sysOrg.setGmtInvalid(System.currentTimeMillis());
            int result = sysOrgDao.update(sysOrg);
            if(result > 0) {
                sysOrgInvalidateResponse.setSuccess();
                sysOrgInvalidateResponse.setSysOrg(sysOrgDao.get(sysOrg.getOrgNo()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgInvalidateResponse        : " + JsonConvertUtils.convertToString(sysOrgInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysOrg <<<<<<< ");
        }
        return sysOrgInvalidateResponse;
    }

    @Override
    public SysOrgDeleteResponse deleteSysOrg(SysOrgDeleteRequest sysOrgDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysOrg >>>>>> ");
            logger.debug(" SysOrgDeleteRequest          : " + JsonConvertUtils.convertToString(sysOrgDeleteRequest));
        }
        SysOrgDeleteResponse sysOrgDeleteResponse = new SysOrgDeleteResponse();
        sysOrgDeleteResponse.setFailureDefault();
        SysOrgDo sysOrgDo = null;
        if(sysOrgDeleteRequest != null && sysOrgDeleteRequest.getOrgNo() != null) {
            sysOrgDo = sysOrgDao.get(sysOrgDeleteRequest.getOrgNo());
        }
        if(sysOrgDo == null) {
            sysOrgDeleteResponse.setFailure("SYS_ORG_NOTEXIST", "该系统单位不存在");
        }
        else {
            int result = sysOrgDao.delete(sysOrgDo);
            if(result > 0) {
                sysOrgDeleteResponse.setSuccess();
                sysOrgDeleteResponse.setSysOrg(sysOrgDo);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgDeleteResponse         : " + JsonConvertUtils.convertToString(sysOrgDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysOrg <<<<<<< ");
        }
        return sysOrgDeleteResponse;
    }

    @Override
    public SysOrgGetResponse getSysOrg(SysOrgGetRequest sysOrgGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysOrg >>>>>> ");
            logger.debug(" SysOrgGetRequest                 : " + JsonConvertUtils.convertToString(sysOrgGetRequest));
        }
        SysOrgGetResponse sysOrgGetResponse = new SysOrgGetResponse();
        sysOrgGetResponse.setFailureDefault();
        SysOrgDo sysOrg = null;
        if(sysOrgGetRequest != null && sysOrgGetRequest.getOrgNo() != null) {
            sysOrg = sysOrgDao.get(sysOrgGetRequest.getOrgNo());
        }

        if(sysOrg == null) {
            sysOrgGetResponse.setFailure("SYS_ORG_NOTEXIST", "该系统单位不存在");
        }
        else {
            sysOrgGetResponse.setSuccess();
            sysOrgGetResponse.setSysOrg(sysOrg);
            Map<String, Object> params = Maps.newHashMap();
            params.put("orgNo", sysOrg.getOrgNo());
            sysOrgGetResponse.setSysOrgExtList(sysOrgExtDao.getList(params, null, null));
            sysOrgGetResponse.setSysOrgExtbizList(sysOrgExtbizDao.getList(params, null, null));
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgGetResponse                : " + JsonConvertUtils.convertToString(sysOrgGetResponse));
            logger.debug(" <<<<<<< end getSysOrg <<<<<<< ");
        }
        return sysOrgGetResponse;
    }

    @Override
    public SysOrgQueryResponse querySysOrg(SysOrgQueryRequest sysOrgQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysOrg >>>>>> ");
            logger.debug(" SysOrgQueryRequest               : " + JsonConvertUtils.convertToString(sysOrgQueryRequest));
        }
        SysOrgQueryResponse sysOrgQueryResponse = new SysOrgQueryResponse();
        sysOrgQueryResponse.setFailureDefault();
        if(sysOrgQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("orgNo", sysOrgQueryRequest.getOrgNo());
            params.put("orgType", NumberUtils.isDigits(sysOrgQueryRequest.getStrOrgType()) ? NumberUtils.toInt(sysOrgQueryRequest.getStrOrgType()): null);
            params.put("orgName", sysOrgQueryRequest.getOrgName());
            params.put("orgAbbr", sysOrgQueryRequest.getOrgAbbr());
            params.put("orgDesc", sysOrgQueryRequest.getOrgDesc());
            params.put("orgLevel", NumberUtils.isDigits(sysOrgQueryRequest.getStrOrgLevel()) ? NumberUtils.toInt(sysOrgQueryRequest.getStrOrgLevel()): null);
            params.put("parentOrgNo", sysOrgQueryRequest.getParentOrgNo());
            params.put("valid", sysOrgQueryRequest.getIsValid());
            int sysOrgCount = sysOrgDao.getCount(params);
            List<SysOrgDo> sysOrgList = sysOrgDao.getList(
                params,
                new Sorter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sysOrgQueryRequest.getOrderCol()), StringUtils.lowerCase(sysOrgQueryRequest.getOrderDir())),
                new Pager(sysOrgQueryRequest.getPageNumber(), sysOrgQueryRequest.getPageSize()));
            sysOrgQueryResponse.setSuccess();
            sysOrgQueryResponse.setSysOrgCount(sysOrgCount);
            sysOrgQueryResponse.setSysOrgList(sysOrgList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgQueryResponse              : " + JsonConvertUtils.convertToString(sysOrgQueryResponse));
            logger.debug(" <<<<<<< end querySysOrg <<<<<<< ");
        }
        return sysOrgQueryResponse;
    }

    @Override
    public SysOrgExtCreateResponse createSysOrgExt(SysOrgExtCreateRequest sysOrgExtCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysOrgExt >>>>>> ");
            logger.debug(" SysOrgExtCreateRequest           : " + JsonConvertUtils.convertToString(sysOrgExtCreateRequest));
        }
        SysOrgExtCreateResponse sysOrgExtCreateResponse = new SysOrgExtCreateResponse();
        sysOrgExtCreateResponse.setFailureDefault();
        if(sysOrgExtCreateRequest != null && StringUtils.isNotBlank(sysOrgExtCreateRequest.getOrgNo()) && StringUtils.isNotBlank(sysOrgExtCreateRequest.getExtAttrKey())) {
            String orgNo = StringUtils.trim(sysOrgExtCreateRequest.getOrgNo());
            String extAttrKey = StringUtils.trim(sysOrgExtCreateRequest.getExtAttrKey());
            SysOrgExtDo sysOrgExt = sysOrgExtDao.getByOrgNoAndAttrKey(orgNo, extAttrKey);
            if(sysOrgExt == null) {
                Long id = idGenerator.nextId();
                sysOrgExt = new SysOrgExtDo();
                sysOrgExt.setId(id);
                sysOrgExt.setOrgNo(orgNo);
                sysOrgExt.setExtAttrKey(extAttrKey);
                sysOrgExt.setExtAttrValue(StringUtils.trimToEmpty(sysOrgExtCreateRequest.getExtAttrValue()));
                sysOrgExt.setExtAttrDesc(StringUtils.trimToEmpty(sysOrgExtCreateRequest.getExtAttrDesc()));
                sysOrgExt.setSortSn(sysOrgExtCreateRequest.getSortSn());
                sysOrgExt.setValid(true);
                sysOrgExt.setCreator(sysOrgExtCreateRequest.getCreator());
                sysOrgExt.setGmtCreate(System.currentTimeMillis());
                sysOrgExt.setModifier(sysOrgExtCreateRequest.getCreator());
                sysOrgExt.setGmtModified(System.currentTimeMillis());
                sysOrgExt.setInvalider("");
                sysOrgExt.setGmtInvalid(0L);
                sysOrgExt.setVersion(1);
                int result = sysOrgExtDao.insert(sysOrgExt);
                if(result > 0) {
                    sysOrgExtCreateResponse.setSuccess();
                    sysOrgExtCreateResponse.setSysOrgExt(sysOrgExtDao.get(id));
                }
            }
            else {
                sysOrgExtCreateResponse.setFailure("SYS_ORG_EXT_ATTR_KEY_ISEXIST", "系统单位扩展属性键已存在");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgExtCreateResponse          : " + JsonConvertUtils.convertToString(sysOrgExtCreateResponse));
            logger.debug(" <<<<<<< end createSysOrgExt <<<<<<< ");
        }
        return sysOrgExtCreateResponse;
    }

    @Override
    public SysOrgExtModifyResponse modifySysOrgExt(SysOrgExtModifyRequest sysOrgExtModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysOrgExt >>>>>> ");
            logger.debug(" SysOrgExtModifyRequest           : " + JsonConvertUtils.convertToString(sysOrgExtModifyRequest));
        }
        SysOrgExtModifyResponse sysOrgExtModifyResponse = new SysOrgExtModifyResponse();
        sysOrgExtModifyResponse.setFailureDefault();
        if(sysOrgExtModifyRequest != null && StringUtils.isNotBlank(sysOrgExtModifyRequest.getOrgNo()) && StringUtils.isNotBlank(sysOrgExtModifyRequest.getExtAttrKey())) {
            SysOrgExtDo sysOrgExt = sysOrgExtDao.getByOrgNoAndAttrKey(sysOrgExtModifyRequest.getOrgNo(), sysOrgExtModifyRequest.getExtAttrKey());
            if(sysOrgExt == null) {
                sysOrgExtModifyResponse.setFailure("SYS_ORG_EXT_NOTEXIST", "系统单位扩展不存在");
            }
            else {
                if(sysOrgExtModifyRequest.getExtAttrValue() != null) {
                    sysOrgExt.setExtAttrValue(sysOrgExtModifyRequest.getExtAttrValue());
                }
                if(sysOrgExtModifyRequest.getExtAttrDesc() != null) {
                    sysOrgExt.setExtAttrDesc(sysOrgExtModifyRequest.getExtAttrDesc());
                }
                if(sysOrgExtModifyRequest.getSortSn() != null) {
                    sysOrgExt.setSortSn(sysOrgExtModifyRequest.getSortSn());
                }
                sysOrgExt.setModifier(sysOrgExtModifyRequest.getModifier());
                sysOrgExt.setGmtModified(System.currentTimeMillis());
                int result = sysOrgExtDao.update(sysOrgExt);
                if(result > 0) {
                    sysOrgExtModifyResponse.setSuccess();
                    sysOrgExtModifyResponse.setSysOrgExt(sysOrgExtDao.get(sysOrgExt.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgExtModifyResponse          : " + JsonConvertUtils.convertToString(sysOrgExtModifyResponse));
            logger.debug(" <<<<<<< end modifySysOrgExt <<<<<<< ");
        }
        return sysOrgExtModifyResponse;
    }

    @Override
    public SysOrgExtInvalidateResponse invalidateSysOrgExt(SysOrgExtInvalidateRequest sysOrgExtInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysOrgExt >>>>>> ");
            logger.debug(" SysOrgExtInvalidateRequest       : " + JsonConvertUtils.convertToString(sysOrgExtInvalidateRequest));
        }
        SysOrgExtInvalidateResponse sysOrgExtInvalidateResponse = new SysOrgExtInvalidateResponse();
        sysOrgExtInvalidateResponse.setFailureDefault();
        SysOrgExtDo sysOrgExt = null;
        if(sysOrgExtInvalidateRequest != null && StringUtils.isNotBlank(sysOrgExtInvalidateRequest.getOrgNo()) && StringUtils.isNotBlank(sysOrgExtInvalidateRequest.getExtAttrKey())) {
            sysOrgExt = sysOrgExtDao.getByOrgNoAndAttrKey(sysOrgExtInvalidateRequest.getOrgNo(), sysOrgExtInvalidateRequest.getExtAttrKey());
        }
        if(sysOrgExt == null) {
            sysOrgExtInvalidateResponse.setFailure("SYS_ORG_EXT_NOTEXIST", "该系统单位扩展不存在");
        }
        else {
            sysOrgExt.setValid(false);
            sysOrgExt.setInvalider(sysOrgExtInvalidateRequest.getInvalider());
            sysOrgExt.setGmtInvalid(System.currentTimeMillis());
            int result = sysOrgExtDao.update(sysOrgExt);
            if(result > 0) {
                sysOrgExtInvalidateResponse.setSuccess();
                sysOrgExtInvalidateResponse.setSysOrgExt(sysOrgExtDao.get(sysOrgExt.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgExtInvalidateResponse      : " + JsonConvertUtils.convertToString(sysOrgExtInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysOrgExt <<<<<<< ");
        }
        return sysOrgExtInvalidateResponse;
    }

    @Override
    public SysOrgExtDeleteResponse deleteSysOrgExt(SysOrgExtDeleteRequest sysOrgExtDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysOrgExt >>>>>> ");
            logger.debug(" SysOrgExtDeleteRequest           : " + JsonConvertUtils.convertToString(sysOrgExtDeleteRequest));
        }
        SysOrgExtDeleteResponse sysOrgExtDeleteResponse = new SysOrgExtDeleteResponse();
        sysOrgExtDeleteResponse.setFailureDefault();
        SysOrgExtDo sysOrgExt = null;
        if(sysOrgExtDeleteRequest != null && StringUtils.isNotBlank(sysOrgExtDeleteRequest.getOrgNo()) && StringUtils.isNotBlank(sysOrgExtDeleteRequest.getExtAttrKey())) {
            sysOrgExt = sysOrgExtDao.getByOrgNoAndAttrKey(sysOrgExtDeleteRequest.getOrgNo(), sysOrgExtDeleteRequest.getExtAttrKey());
        }
        if(sysOrgExt == null) {
            sysOrgExtDeleteResponse.setFailure("SYS_ORG_EXT_NOTEXIST", "该系统单位扩展不存在");
        }
        else {
            int result = sysOrgExtDao.delete(sysOrgExt);
            if(result > 0) {
                sysOrgExtDeleteResponse.setSuccess();
                sysOrgExtDeleteResponse.setSysOrgExt(sysOrgExt);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgExtDeleteResponse      : " + JsonConvertUtils.convertToString(sysOrgExtDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysOrgExt <<<<<<< ");
        }
        return sysOrgExtDeleteResponse;
    }

    @Override
    public SysOrgExtGetResponse getSysOrgExt(SysOrgExtGetRequest sysOrgExtGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysOrgExt >>>>>> ");
            logger.debug(" SysOrgExtGetRequest              : " + JsonConvertUtils.convertToString(sysOrgExtGetRequest));
        }
        SysOrgExtGetResponse sysOrgExtGetResponse = new SysOrgExtGetResponse();
        sysOrgExtGetResponse.setFailureDefault();
        SysOrgExtVo sysOrgExt = null;
        if(sysOrgExtGetRequest != null && StringUtils.isNotBlank(sysOrgExtGetRequest.getOrgNo()) && StringUtils.isNotBlank(sysOrgExtGetRequest.getExtAttrKey())) {
            sysOrgExt = sysOrgExtDao.getSysOrgExtVoByOrgNoAndAttrKey(sysOrgExtGetRequest.getOrgNo(), sysOrgExtGetRequest.getExtAttrKey());
        }

        if(sysOrgExt == null) {
            sysOrgExtGetResponse.setFailure("SYS_ORG_EXT_NOTEXIST", "该系统单位扩展不存在");
        }
        else {
            sysOrgExtGetResponse.setSuccess();
            sysOrgExtGetResponse.setSysOrgExt(sysOrgExt);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgExtGetResponse             : " + JsonConvertUtils.convertToString(sysOrgExtGetResponse));
            logger.debug(" <<<<<<< end getSysOrgExt <<<<<<< ");
        }
        return sysOrgExtGetResponse;
    }

    @Override
    public SysOrgExtQueryResponse querySysOrgExt(SysOrgExtQueryRequest sysOrgExtQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysOrgExt >>>>>> ");
            logger.debug(" SysOrgExtQueryRequest            : " + JsonConvertUtils.convertToString(sysOrgExtQueryRequest));
        }
        SysOrgExtQueryResponse sysOrgExtQueryResponse = new SysOrgExtQueryResponse();
        sysOrgExtQueryResponse.setFailureDefault();
        if(sysOrgExtQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("orgNo", sysOrgExtQueryRequest.getOrgNo());
            params.put("extAttrKey", sysOrgExtQueryRequest.getExtAttrKey());
            params.put("extAttrValue", sysOrgExtQueryRequest.getExtAttrValue());
            params.put("extAttrDesc", sysOrgExtQueryRequest.getExtAttrDesc());
            params.put("valid", sysOrgExtQueryRequest.getIsValid());
            int sysOrgCount = sysOrgExtDao.getSysOrgExtVoCount(params);
            List<SysOrgExtVo> sysOrgExtList = sysOrgExtDao.getSysOrgExtVoList(
                params,
                new Sorter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sysOrgExtQueryRequest.getOrderCol()), StringUtils.lowerCase(sysOrgExtQueryRequest.getOrderDir())),
                new Pager(sysOrgExtQueryRequest.getPageNumber(), sysOrgExtQueryRequest.getPageSize()));
            sysOrgExtQueryResponse.setSuccess();
            sysOrgExtQueryResponse.setSysOrgExtCount(sysOrgCount);
            sysOrgExtQueryResponse.setSysOrgExtList(sysOrgExtList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysOrgExtQueryResponse           : " + JsonConvertUtils.convertToString(sysOrgExtQueryResponse));
            logger.debug(" <<<<<<< end querySysOrgExt <<<<<<< ");
        }
        return sysOrgExtQueryResponse;
    }

    @Override
    public SysOrgExtbizCreateResponse createSysOrgExtbiz(SysOrgExtbizCreateRequest sysOrgExtbizCreateRequest) {
        return null;
    }

    @Override
    public SysOrgExtbizModifyResponse modifySysOrgExtbiz(SysOrgExtbizModifyRequest sysOrgExtbizModifyRequest) {
        return null;
    }

    @Override
    public SysOrgExtbizInvalidateResponse invalidateSysOrgExtbiz(SysOrgExtbizInvalidateRequest sysOrgExtbizInvalidateRequest) {
        return null;
    }

    @Override
    public SysOrgExtbizDeleteResponse deleteSysOrgExtbiz(SysOrgExtbizDeleteRequest sysOrgExtbizDeleteRequest) {
        return null;
    }

    @Override
    public SysOrgExtbizGetResponse getSysOrgExtbiz(SysOrgExtbizGetRequest sysOrgExtbizGetRequest) {
        return null;
    }

    @Override
    public SysOrgExtbizQueryResponse querySysOrgExtbiz(SysOrgExtbizQueryRequest sysOrgExtbizQueryRequest) {
        return null;
    }

}
