package com.easesource.system.openservices.orgmgmt.service.impl;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.system.openservices.authmgmt.dao.SysRoleDao;
import com.easesource.system.openservices.authmgmt.dao.SysRoleModuleDao;
import com.easesource.system.openservices.authmgmt.entity.SysRoleDo;
import com.easesource.system.openservices.common.service.AbstractBaseService;
import com.easesource.system.openservices.orgmgmt.dao.*;
import com.easesource.system.openservices.orgmgmt.entity.*;
import com.easesource.system.openservices.orgmgmt.request.*;
import com.easesource.system.openservices.orgmgmt.response.*;
import com.easesource.system.openservices.orgmgmt.service.SysUserService;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-22
 */
@Service
public class SysUserServiceImpl extends AbstractBaseService implements SysUserService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final SysOrgDao sysOrgDao;
    private final SysDeptDao sysDeptDao;
    private final SysUserDao sysUserDao;
    private final SysUserExtDao sysUserExtDao;
    private final SysUserExtbizDao sysUserExtbizDao;
    private final SysUserRoleDao sysUserRoleDao;
    private final SysRoleModuleDao sysRoleModuleDao;
    private final SysRoleDao sysRoleDao;

    @Autowired
    public SysUserServiceImpl(SysOrgDao sysOrgDao, SysDeptDao sysDeptDao, SysUserDao sysUserDao, SysUserExtDao sysUserExtDao, SysUserExtbizDao sysUserExtbizDao, SysUserRoleDao sysUserRoleDao, SysRoleModuleDao sysRoleModuleDao, SysRoleDao sysRoleDao) {
        this.sysOrgDao = sysOrgDao;
        this.sysDeptDao = sysDeptDao;
        this.sysUserDao = sysUserDao;
        this.sysUserExtDao = sysUserExtDao;
        this.sysUserExtbizDao = sysUserExtbizDao;
        this.sysUserRoleDao = sysUserRoleDao;
        this.sysRoleModuleDao = sysRoleModuleDao;
        this.sysRoleDao = sysRoleDao;
    }

    @Override
    public SysUserCreateResponse createSysUser(SysUserCreateRequest sysUserCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysUser >>>>>> ");
            logger.debug(" SysUserCreateRequest             : " + JsonConvertUtils.convertToString(sysUserCreateRequest));
        }
        SysUserCreateResponse sysUserCreateResponse = new SysUserCreateResponse();
        sysUserCreateResponse.setFailureDefault();
        if(sysUserCreateRequest != null && StringUtils.isNotBlank(sysUserCreateRequest.getUserNo())) {
            SysOrgDo sysOrg = sysOrgDao.get(sysUserCreateRequest.getOrgNo());
            SysUserDo sysUser = sysUserDao.getByUserNo(sysUserCreateRequest.getUserNo());
            if(sysOrg != null && sysUser == null) {
                if(StringUtils.isNotBlank(sysUserCreateRequest.getDeptNo())) {
                    SysDeptDo sysDept = sysDeptDao.get(sysUserCreateRequest.getDeptNo());
                    if(sysDept == null) {
                        sysUserCreateResponse.setFailure("SYS_DEPT_NOTEXIST", "系统部门不存在");
                    }
                    else if(!StringUtils.equals(sysDept.getOrgNo(), sysOrg.getOrgNo())) {
                        sysUserCreateResponse.setFailure("SYS_USER_CREATE_PARAMERR", "系统用户创建参数非法");
                    }
                }
                sysUser = new SysUserDo();
                sysUser.setId(idGenerator.nextId());
                sysUser.setOrgNo(sysUserCreateRequest.getOrgNo());
                sysUser.setDeptNo(sysUserCreateRequest.getDeptNo());
                sysUser.setUserNo(sysUserCreateRequest.getUserNo());
                sysUser.setUserType(sysOrg.getOrgType());
                sysUser.setUserFullname(sysUserCreateRequest.getUserFullname());
                sysUser.setUserNickname(sysUserCreateRequest.getUserNickname());
                sysUser.setUserPasswd(sysUserCreateRequest.getUserPasswd());
                sysUser.setUserPasswdEatype(sysUserCreateRequest.getUserPasswdEatype());
                sysUser.setUserHeadPhoto(sysUserCreateRequest.getUserHeadPhoto());
                sysUser.setUserMobile(sysUserCreateRequest.getUserMobile());
                sysUser.setUserEmail(sysUserCreateRequest.getUserEmail());
                sysUser.setUserState(sysUserCreateRequest.getUserState());
                sysUser.setRsnUserLocked(sysUserCreateRequest.getRsnUserLocked());
                sysUser.setGmtUserLocked(sysUserCreateRequest.getGmtUserLocked());
                sysUser.setSortSn(sysUserCreateRequest.getSortSn());
                sysUser.setValid(true);
                sysUser.setCreator(sysUserCreateRequest.getCreator());
                sysUser.setGmtCreate(System.currentTimeMillis());
                sysUser.setModifier(sysUserCreateRequest.getCreator());
                sysUser.setGmtModified(System.currentTimeMillis());
                sysUser.setInvalider("");
                sysUser.setGmtInvalid(0L);
                sysUser.setVersion(1);
                int result = sysUserDao.insert(sysUser);
                if(result > 0) {
                    sysUserCreateResponse.setSuccess();
                    sysUserCreateResponse.setSysUser(sysUserDao.get(sysUser.getId()));
                }
            }
            else {
                if(sysOrg == null) {
                    sysUserCreateResponse.setFailure("SYS_ORG_NOTEXIST", "系统单位不存在");
                }
                else {
                    sysUserCreateResponse.setFailure("SYS_USER_NO_ISEXIST", "系统用户编号已存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserCreateResponse            : " + JsonConvertUtils.convertToString(sysUserCreateResponse));
            logger.debug(" <<<<<<< end createSysUser <<<<<<< ");
        }
        return sysUserCreateResponse;
    }

    @Override
    public SysUserModifyResponse modifySysUser(SysUserModifyRequest sysUserModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysUser >>>>>> ");
            logger.debug(" SysUserModifyRequest             : " + JsonConvertUtils.convertToString(sysUserModifyRequest));
        }
        SysUserModifyResponse sysUserModifyResponse = new SysUserModifyResponse();
        sysUserModifyResponse.setFailureDefault();
        if(sysUserModifyRequest != null && sysUserModifyRequest.getUserId() != null) {
            SysUserDo sysUser = sysUserDao.get(sysUserModifyRequest.getUserId());
            if(sysUser == null) {
                sysUserModifyResponse.setFailure("SYS_USER_NOTEXIST", "系统用户不存在");
            }
            else {
                if(sysUserModifyRequest.getUserFullname() != null) {
                    sysUser.setUserFullname(sysUserModifyRequest.getUserFullname());
                }
                if(sysUserModifyRequest.getUserNickname() != null) {
                    sysUser.setUserNickname(sysUserModifyRequest.getUserNickname());
                }
                if(sysUserModifyRequest.getUserHeadPhoto() != null) {
                    sysUser.setUserHeadPhoto(sysUserModifyRequest.getUserHeadPhoto());
                }
                if(sysUserModifyRequest.getUserMobile() != null) {
                    sysUser.setUserMobile(sysUserModifyRequest.getUserMobile());
                }
                if(sysUserModifyRequest.getUserEmail() != null) {
                    sysUser.setUserEmail(sysUserModifyRequest.getUserEmail());
                }
                if(sysUserModifyRequest.getUserState() != null) {
                    sysUser.setUserState(sysUserModifyRequest.getUserState());
                }
                if(sysUserModifyRequest.getRsnUserLocked() != null) {
                    sysUser.setRsnUserLocked(sysUserModifyRequest.getRsnUserLocked());
                }
                if(sysUserModifyRequest.getGmtUserLocked() != null) {
                    sysUser.setGmtUserLocked(sysUserModifyRequest.getGmtUserLocked());
                }
                if(sysUserModifyRequest.getSortSn() != null) {
                    sysUser.setSortSn(sysUserModifyRequest.getSortSn());
                }
                sysUser.setModifier(sysUserModifyRequest.getModifier());
                sysUser.setGmtModified(System.currentTimeMillis());
                int result = sysUserDao.update(sysUser);
                if(result > 0) {
                    sysUserModifyResponse.setSuccess();
                    sysUserModifyResponse.setSysUser(sysUserDao.get(sysUser.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserModifyResponse            : " + JsonConvertUtils.convertToString(sysUserModifyResponse));
            logger.debug(" <<<<<<< end modifySysUser <<<<<<< ");
        }
        return sysUserModifyResponse;
    }

    @Override
    public SysUserPasswordModifyResponse modifySysUserPassword(SysUserPasswordModifyRequest sysUserPasswordModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysUserPassword >>>>>> ");
            logger.debug(" SysUserPasswordModifyRequest     : " + JsonConvertUtils.convertToString(sysUserPasswordModifyRequest));
        }
        SysUserPasswordModifyResponse sysUserPasswordModifyResponse = new SysUserPasswordModifyResponse();
        sysUserPasswordModifyResponse.setFailureDefault();
        if(sysUserPasswordModifyRequest != null && sysUserPasswordModifyRequest.getUserId() != null) {
            SysUserDo sysUser = sysUserDao.get(sysUserPasswordModifyRequest.getUserId());
            if(sysUser == null) {
                sysUserPasswordModifyResponse.setFailure("SYS_USER_NOTEXIST", "系统用户不存在");
            }
            else {
                String oldUserPasswd = sysUserPasswordModifyRequest.getOldUserPasswd();
                String oldUserPasswdEatype = sysUserPasswordModifyRequest.getOldUserPasswdEatype();
                String newUserPasswd = sysUserPasswordModifyRequest.getNewUserPasswd();
                String newUserPasswdEatype = sysUserPasswordModifyRequest.getNewUserPasswdEatype();
                if(StringUtils.isBlank(oldUserPasswd) || (StringUtils.equals(oldUserPasswd, sysUser.getUserPasswd()) && StringUtils.equals(oldUserPasswdEatype, sysUser.getUserPasswdEatype()))) {
                    sysUser.setUserPasswd(sysUserPasswordModifyRequest.getNewUserPasswd());
                    sysUser.setUserPasswdEatype(sysUserPasswordModifyRequest.getNewUserPasswdEatype());
                    sysUser.setModifier(sysUserPasswordModifyRequest.getModifier());
                    sysUser.setGmtModified(System.currentTimeMillis());
                    int result = sysUserDao.update(sysUser);
                    if(result > 0) {
                        sysUserPasswordModifyResponse.setSuccess();
                        sysUserPasswordModifyResponse.setSysUser(sysUserDao.get(sysUser.getId()));
                    }
                }
                else {
                    sysUserPasswordModifyResponse.setFailure("SYS_USER_PASSWORD_NOTMATCHE", "系统用户密码不正确");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserPasswordModifyResponse    : " + JsonConvertUtils.convertToString(sysUserPasswordModifyResponse));
            logger.debug(" <<<<<<< end modifySysUser <<<<<<< ");
        }
        return sysUserPasswordModifyResponse;
    }

    @Override
    public SysUserInvalidateResponse invalidateSysUser(SysUserInvalidateRequest sysUserInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysUser >>>>>> ");
            logger.debug(" SysUserInvalidateRequest         : " + JsonConvertUtils.convertToString(sysUserInvalidateRequest));
        }
        SysUserInvalidateResponse sysUserInvalidateResponse = new SysUserInvalidateResponse();
        sysUserInvalidateResponse.setFailureDefault();
        SysUserDo sysUser = null;
        if(sysUserInvalidateRequest != null && sysUserInvalidateRequest.getUserId() != null) {
            sysUser = sysUserDao.get(sysUserInvalidateRequest.getUserId());
        }
        if(sysUser == null) {
            sysUserInvalidateResponse.setFailure("SYS_USER_NOTEXIST", "该系统用户不存在");
        }
        else {
            sysUser.setValid(false);
            sysUser.setInvalider(sysUserInvalidateRequest.getInvalider());
            sysUser.setGmtInvalid(System.currentTimeMillis());
            int result = sysUserDao.update(sysUser);
            if(result > 0) {
                sysUserInvalidateResponse.setSuccess();
                sysUserInvalidateResponse.setSysUser(sysUserDao.get(sysUser.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserInvalidateResponse        : " + JsonConvertUtils.convertToString(sysUserInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysUser <<<<<<< ");
        }
        return sysUserInvalidateResponse;
    }

    @Override
    public SysUserDeleteResponse deleteSysUser(SysUserDeleteRequest sysUserDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysUser >>>>>> ");
            logger.debug(" SysUserDeleteRequest         : " + JsonConvertUtils.convertToString(sysUserDeleteRequest));
        }
        SysUserDeleteResponse sysUserDeleteResponse = new SysUserDeleteResponse();
        sysUserDeleteResponse.setFailureDefault();
        SysUserDo sysUserDo = null;
        if(sysUserDeleteRequest != null && sysUserDeleteRequest.getUserId() != null) {
            sysUserDo = sysUserDao.get(sysUserDeleteRequest.getUserId());
        }
        if(sysUserDo == null) {
            sysUserDeleteResponse.setFailure("SYS_USER_NOTEXIST", "该系统用户不存在");
        }
        else {
            int result = sysUserDao.delete(sysUserDo);
            if(result > 0) {
                sysUserDeleteResponse.setSuccess();
                sysUserDeleteResponse.setSysUser(sysUserDo);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserDeleteResponse        : " + JsonConvertUtils.convertToString(sysUserDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysUser <<<<<<< ");
        }
        return sysUserDeleteResponse;
    }

    @Override
    public SysUserGetResponse getSysUser(SysUserGetRequest sysUserGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysUser >>>>>> ");
            logger.debug(" SysUserGetRequest                : " + JsonConvertUtils.convertToString(sysUserGetRequest));
        }
        SysUserGetResponse sysUserGetResponse = new SysUserGetResponse();
        sysUserGetResponse.setFailureDefault();
        SysUserVo sysUser = null;
        if(sysUserGetRequest != null && sysUserGetRequest.getUserId() != null) {
            sysUser = sysUserDao.getSysUserVo(sysUserGetRequest.getUserId());
        }
        else if(sysUserGetRequest != null && StringUtils.isNotBlank(sysUserGetRequest.getUserNo())) {
            sysUser = sysUserDao.getSysUserVoByUserNo(sysUserGetRequest.getUserNo());
        }
        if(sysUser == null) {
            sysUserGetResponse.setFailure("SYS_USER_NOTEXIST", "该系统用户不存在");
        }
        else {
            sysUserGetResponse.setSuccess();
            sysUserGetResponse.setSysUser(sysUser);
            Map<String, Object> params = Maps.newHashMap();
            params.put("userId", sysUser.getId());
            sysUserGetResponse.setSysUserExtList(sysUserExtDao.getList(params, null, null));
            sysUserGetResponse.setSysUserExtbizList(sysUserExtbizDao.getList(params, null, null));
            sysUserGetResponse.setSysRoleList(sysRoleDao.getListByUserId(sysUser.getId()));
            sysUserGetResponse.setSysRoleModuleList(sysRoleModuleDao.getListByUserId(sysUser.getId()));
            sysUserGetResponse.setRoleIdList(sysRoleDao.getRoleIdListByUserId(sysUser.getId()));
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserGetResponse               : " + JsonConvertUtils.convertToString(sysUserGetResponse));
            logger.debug(" <<<<<<< end getSysUser <<<<<<< ");
        }
        return sysUserGetResponse;
    }

    @Override
    public SysUserQueryResponse querySysUser(SysUserQueryRequest sysUserQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysUser >>>>>> ");
            logger.debug(" SysUserQueryRequest              : " + JsonConvertUtils.convertToString(sysUserQueryRequest));
        }
        SysUserQueryResponse sysUserQueryResponse = new SysUserQueryResponse();
        sysUserQueryResponse.setFailureDefault();
        if(sysUserQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("orgNo", sysUserQueryRequest.getOrgNo());
            params.put("deptNo", sysUserQueryRequest.getDeptNo());
            params.put("containLower", sysUserQueryRequest.getContainLower());
            params.put("userNoLike", sysUserQueryRequest.getUserNo());
            params.put("userFullnameLike", sysUserQueryRequest.getUserFullname());
            params.put("userNicknameLike", sysUserQueryRequest.getUserNickname());
            params.put("userMobileLike", sysUserQueryRequest.getUserMobile());
            params.put("userEmailLike", sysUserQueryRequest.getUserEmail());
            params.put("userState", sysUserQueryRequest.getUserState());
            params.put("rsnUserLocked", sysUserQueryRequest.getRsnUserLocked());
            params.put("gmtUserLocked", sysUserQueryRequest.getGmtUserLocked());
            params.put("valid", sysUserQueryRequest.getIsValid());
            int sysUserCount = sysUserDao.getSysUserVoCount(params);
            List<SysUserVo> sysUserList = sysUserDao.getSysUserVoList(
                params,
                new Sorter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sysUserQueryRequest.getOrderCol()), StringUtils.lowerCase(sysUserQueryRequest.getOrderDir())),
                new Pager(sysUserQueryRequest.getPageNumber(), sysUserQueryRequest.getPageSize()));
            sysUserQueryResponse.setSuccess();
            sysUserQueryResponse.setSysUserCount(sysUserCount);
            sysUserQueryResponse.setSysUserList(sysUserList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserQueryResponse             : " + JsonConvertUtils.convertToString(sysUserQueryResponse));
            logger.debug(" <<<<<<< end querySysUser <<<<<<< ");
        }
        return sysUserQueryResponse;
    }

    @Override
    public SysUserExtCreateResponse createSysUserExt(SysUserExtCreateRequest sysUserExtCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysUserExt >>>>>> ");
            logger.debug(" SysUserExtCreateRequest          : " + JsonConvertUtils.convertToString(sysUserExtCreateRequest));
        }
        SysUserExtCreateResponse sysUserExtCreateResponse = new SysUserExtCreateResponse();
        sysUserExtCreateResponse.setFailureDefault();
        if(sysUserExtCreateRequest != null && ObjectUtils.isNotNull(sysUserExtCreateRequest.getUserId()) && StringUtils.isNotBlank(sysUserExtCreateRequest.getExtAttrKey())) {
            Long userId = sysUserExtCreateRequest.getUserId();
            if(userId > 0L) {
                String extAttrKey = StringUtils.trim(sysUserExtCreateRequest.getExtAttrKey());
                SysUserExtDo sysUserExt = sysUserExtDao.getByUserIdAndAttrKey(userId, extAttrKey);
                if(sysUserExt == null) {
                    Long id = idGenerator.nextId();
                    sysUserExt = new SysUserExtDo();
                    sysUserExt.setId(id);
                    sysUserExt.setUserId(userId);
                    sysUserExt.setExtAttrKey(extAttrKey);
                    sysUserExt.setExtAttrValue(StringUtils.trimToEmpty(sysUserExtCreateRequest.getExtAttrValue()));
                    sysUserExt.setExtAttrDesc(StringUtils.trimToEmpty(sysUserExtCreateRequest.getExtAttrDesc()));
                    sysUserExt.setSortSn(sysUserExtCreateRequest.getSortSn());
                    sysUserExt.setValid(true);
                    sysUserExt.setCreator(sysUserExtCreateRequest.getCreator());
                    sysUserExt.setGmtCreate(System.currentTimeMillis());
                    sysUserExt.setModifier(sysUserExtCreateRequest.getCreator());
                    sysUserExt.setGmtModified(System.currentTimeMillis());
                    sysUserExt.setInvalider("");
                    sysUserExt.setGmtInvalid(0L);
                    sysUserExt.setVersion(1);
                    int result = sysUserExtDao.insert(sysUserExt);
                    if(result > 0) {
                        sysUserExtCreateResponse.setSuccess();
                        sysUserExtCreateResponse.setSysUserExt(sysUserExtDao.get(id));
                    }
                }
                else {
                    sysUserExtCreateResponse.setFailure("SYS_USER_EXT_ATTR_KEY_ISEXIST", "系统用户扩展属性键已存在");
                }
            }
            else {
                sysUserExtCreateResponse.setFailure("SYS_USER_ID_ERROR", "系统用户标识非法");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserExtCreateResponse          : " + JsonConvertUtils.convertToString(sysUserExtCreateResponse));
            logger.debug(" <<<<<<< end createSysUserExt <<<<<<< ");
        }
        return sysUserExtCreateResponse;
    }

    @Override
    public SysUserExtModifyResponse modifySysUserExt(SysUserExtModifyRequest sysUserExtModifyRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start modifySysUserExt >>>>>> ");
            logger.debug(" SysUserExtModifyRequest          : " + JsonConvertUtils.convertToString(sysUserExtModifyRequest));
        }
        SysUserExtModifyResponse sysUserExtModifyResponse = new SysUserExtModifyResponse();
        sysUserExtModifyResponse.setFailureDefault();
        if(sysUserExtModifyRequest != null && ObjectUtils.isNotNull(sysUserExtModifyRequest.getUserId()) && StringUtils.isNotBlank(sysUserExtModifyRequest.getExtAttrKey())) {
            SysUserExtDo sysUserExt = sysUserExtDao.getByUserIdAndAttrKey(sysUserExtModifyRequest.getUserId(), sysUserExtModifyRequest.getExtAttrKey());
            if(sysUserExt == null) {
                sysUserExtModifyResponse.setFailure("SYS_USER_EXT_NOTEXIST", "系统用户扩展不存在");
            }
            else {
                if(sysUserExtModifyRequest.getExtAttrValue() != null) {
                    sysUserExt.setExtAttrValue(sysUserExtModifyRequest.getExtAttrValue());
                }
                if(sysUserExtModifyRequest.getExtAttrDesc() != null) {
                    sysUserExt.setExtAttrDesc(sysUserExtModifyRequest.getExtAttrDesc());
                }
                if(sysUserExtModifyRequest.getSortSn() != null) {
                    sysUserExt.setSortSn(sysUserExtModifyRequest.getSortSn());
                }
                sysUserExt.setModifier(sysUserExtModifyRequest.getModifier());
                sysUserExt.setGmtModified(System.currentTimeMillis());
                int result = sysUserExtDao.update(sysUserExt);
                if(result > 0) {
                    sysUserExtModifyResponse.setSuccess();
                    sysUserExtModifyResponse.setSysUserExt(sysUserExtDao.get(sysUserExt.getId()));
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserExtModifyResponse          : " + JsonConvertUtils.convertToString(sysUserExtModifyResponse));
            logger.debug(" <<<<<<< end modifySysUserExt <<<<<<< ");
        }
        return sysUserExtModifyResponse;
    }

    @Override
    public SysUserExtInvalidateResponse invalidateSysUserExt(SysUserExtInvalidateRequest sysUserExtInvalidateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start invalidateSysUserExt >>>>>> ");
            logger.debug(" SysUserExtInvalidateRequest      : " + JsonConvertUtils.convertToString(sysUserExtInvalidateRequest));
        }
        SysUserExtInvalidateResponse sysUserExtInvalidateResponse = new SysUserExtInvalidateResponse();
        sysUserExtInvalidateResponse.setFailureDefault();
        SysUserExtDo sysUserExt = null;
        if(sysUserExtInvalidateRequest != null && ObjectUtils.isNotNull(sysUserExtInvalidateRequest.getUserId()) && StringUtils.isNotBlank(sysUserExtInvalidateRequest.getExtAttrKey())) {
            sysUserExt = sysUserExtDao.getByUserIdAndAttrKey(sysUserExtInvalidateRequest.getUserId(), sysUserExtInvalidateRequest.getExtAttrKey());
        }
        if(sysUserExt == null) {
            sysUserExtInvalidateResponse.setFailure("SYS_USER_EXT_NOTEXIST", "该系统用户扩展不存在");
        }
        else {
            sysUserExt.setValid(false);
            sysUserExt.setInvalider(sysUserExtInvalidateRequest.getInvalider());
            sysUserExt.setGmtInvalid(System.currentTimeMillis());
            int result = sysUserExtDao.update(sysUserExt);
            if(result > 0) {
                sysUserExtInvalidateResponse.setSuccess();
                sysUserExtInvalidateResponse.setSysUserExt(sysUserExtDao.get(sysUserExt.getId()));
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserExtInvalidateResponse     : " + JsonConvertUtils.convertToString(sysUserExtInvalidateResponse));
            logger.debug(" <<<<<<< end invalidateSysUserExt <<<<<<< ");
        }
        return sysUserExtInvalidateResponse;
    }

    @Override
    public SysUserExtDeleteResponse deleteSysUserExt(SysUserExtDeleteRequest sysUserExtDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysUserExt >>>>>> ");
            logger.debug(" SysUserExtDeleteRequest          : " + JsonConvertUtils.convertToString(sysUserExtDeleteRequest));
        }
        SysUserExtDeleteResponse sysUserExtDeleteResponse = new SysUserExtDeleteResponse();
        sysUserExtDeleteResponse.setFailureDefault();
        SysUserExtDo sysUserExt = null;
        if(sysUserExtDeleteRequest != null && ObjectUtils.isNotNull(sysUserExtDeleteRequest.getUserId()) && StringUtils.isNotBlank(sysUserExtDeleteRequest.getExtAttrKey())) {
            sysUserExt = sysUserExtDao.getByUserIdAndAttrKey(sysUserExtDeleteRequest.getUserId(), sysUserExtDeleteRequest.getExtAttrKey());
        }
        if(sysUserExt == null) {
            sysUserExtDeleteResponse.setFailure("SYS_USER_EXT_NOTEXIST", "该系统用户扩展不存在");
        }
        else {
            int result = sysUserExtDao.delete(sysUserExt);
            if(result > 0) {
                sysUserExtDeleteResponse.setSuccess();
                sysUserExtDeleteResponse.setSysUserExt(sysUserExt);
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserExtDeleteResponse     : " + JsonConvertUtils.convertToString(sysUserExtDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysUserExt <<<<<<< ");
        }
        return sysUserExtDeleteResponse;
    }

    @Override
    public SysUserExtGetResponse getSysUserExt(SysUserExtGetRequest sysUserExtGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getSysUserExt >>>>>> ");
            logger.debug(" SysUserExtGetRequest             : " + JsonConvertUtils.convertToString(sysUserExtGetRequest));
        }
        SysUserExtGetResponse sysUserExtGetResponse = new SysUserExtGetResponse();
        sysUserExtGetResponse.setFailureDefault();
        SysUserExtVo sysUserExt = null;
        if(sysUserExtGetRequest != null && ObjectUtils.isNotNull(sysUserExtGetRequest.getUserId()) && StringUtils.isNotBlank(sysUserExtGetRequest.getExtAttrKey())) {
            sysUserExt = sysUserExtDao.getSysUserExtVoByUserIdAndAttrKey(sysUserExtGetRequest.getUserId(), sysUserExtGetRequest.getExtAttrKey());
        }

        if(sysUserExt == null) {
            sysUserExtGetResponse.setFailure("SYS_USER_EXT_NOTEXIST", "该系统用户扩展不存在");
        }
        else {
            sysUserExtGetResponse.setSuccess();
            sysUserExtGetResponse.setSysUserExt(sysUserExt);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserExtGetResponse            : " + JsonConvertUtils.convertToString(sysUserExtGetResponse));
            logger.debug(" <<<<<<< end getSysUserExt <<<<<<< ");
        }
        return sysUserExtGetResponse;
    }

    @Override
    public SysUserExtQueryResponse querySysUserExt(SysUserExtQueryRequest sysUserExtQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start querySysUserExt >>>>>> ");
            logger.debug(" SysUserExtQueryRequest           : " + JsonConvertUtils.convertToString(sysUserExtQueryRequest));
        }
        SysUserExtQueryResponse sysUserExtQueryResponse = new SysUserExtQueryResponse();
        sysUserExtQueryResponse.setFailureDefault();
        if(sysUserExtQueryRequest != null) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("userId", sysUserExtQueryRequest.getUserId());
            params.put("userNo", sysUserExtQueryRequest.getUserNo());
            params.put("extAttrKey", sysUserExtQueryRequest.getExtAttrKey());
            params.put("extAttrValue", sysUserExtQueryRequest.getExtAttrValue());
            params.put("extAttrDesc", sysUserExtQueryRequest.getExtAttrDesc());
            params.put("valid", sysUserExtQueryRequest.getIsValid());
            int sysUserCount = sysUserExtDao.getSysUserExtVoCount(params);
            List<SysUserExtVo> sysUserExtList = sysUserExtDao.getSysUserExtVoList(
                params,
                new Sorter(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, sysUserExtQueryRequest.getOrderCol()), StringUtils.lowerCase(sysUserExtQueryRequest.getOrderDir())),
                new Pager(sysUserExtQueryRequest.getPageNumber(), sysUserExtQueryRequest.getPageSize()));
            sysUserExtQueryResponse.setSuccess();
            sysUserExtQueryResponse.setSysUserExtCount(sysUserCount);
            sysUserExtQueryResponse.setSysUserExtList(sysUserExtList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserExtQueryResponse          : " + JsonConvertUtils.convertToString(sysUserExtQueryResponse));
            logger.debug(" <<<<<<< end querySysUserExt <<<<<<< ");
        }
        return sysUserExtQueryResponse;
    }

    @Override
    public SysUserExtbizCreateResponse createSysUserExtbiz(SysUserExtbizCreateRequest sysUserExtbizCreateRequest) {
        return null;
    }

    @Override
    public SysUserExtbizModifyResponse modifySysUserExtbiz(SysUserExtbizModifyRequest sysUserExtbizModifyRequest) {
        return null;
    }

    @Override
    public SysUserExtbizInvalidateResponse invalidateSysUserExtbiz(SysUserExtbizInvalidateRequest sysUserExtbizInvalidateRequest) {
        return null;
    }

    @Override
    public SysUserExtbizDeleteResponse deleteSysUserExtbiz(SysUserExtbizDeleteRequest sysUserExtbizDeleteRequest) {
        return null;
    }

    @Override
    public SysUserExtbizGetResponse getSysUserExtbiz(SysUserExtbizGetRequest sysUserExtbizGetRequest) {
        return null;
    }

    @Override
    public SysUserExtbizQueryResponse querySysUserExtbiz(SysUserExtbizQueryRequest sysUserExtbizQueryRequest) {
        return null;
    }

    @Override
    public SysUserRoleCreateResponse createSysUserRole(SysUserRoleCreateRequest sysUserRoleCreateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start createSysUserRole >>>>>> ");
            logger.debug(" SysUserRoleCreateRequest         : " + JsonConvertUtils.convertToString(sysUserRoleCreateRequest));
        }
        SysUserRoleCreateResponse sysUserRoleCreateResponse = new SysUserRoleCreateResponse();
        sysUserRoleCreateResponse.setFailureDefault();
        if(sysUserRoleCreateRequest != null && sysUserRoleCreateRequest.getUserId() != null && sysUserRoleCreateRequest.getUserId() > 0L
            && sysUserRoleCreateRequest.getRoleId() != null && sysUserRoleCreateRequest.getRoleId() > 0L) {
            SysUserDo sysUserDo = sysUserDao.get(sysUserRoleCreateRequest.getUserId());
            SysRoleDo sysRoleDo = sysRoleDao.get(sysUserRoleCreateRequest.getRoleId());
            if(sysUserDo != null && sysRoleDo != null) {
                SysUserRoleDo sysUserRoleDo = new SysUserRoleDo();
                sysUserRoleDo.setId(idGenerator.nextId());
                sysUserRoleDo.setUserId(sysUserDo.getId());
                sysUserRoleDo.setRoleId(sysRoleDo.getId());
                sysUserRoleDo.setSortSn(sysUserRoleCreateRequest.getSortSn());
                sysUserRoleDo.setValid(true);
                sysUserRoleDo.setCreator(sysUserRoleCreateRequest.getCreator());
                sysUserRoleDo.setGmtCreate(System.currentTimeMillis());
                sysUserRoleDo.setModifier(sysUserRoleCreateRequest.getCreator());
                sysUserRoleDo.setGmtModified(System.currentTimeMillis());
                sysUserRoleDo.setInvalider("");
                sysUserRoleDo.setGmtInvalid(0L);
                sysUserRoleDo.setVersion(1);
                int result = sysUserRoleDao.insert(sysUserRoleDo);
                if(result > 0) {
                    sysUserRoleCreateResponse.setSuccess();
                    sysUserRoleCreateResponse.setSysUserRole(sysUserRoleDao.get(sysUserRoleDo.getId()));
                    sysUserRoleCreateResponse.setSysUser(sysUserDo);
                    sysUserRoleCreateResponse.setSysRole(sysRoleDo);
                }
            }
            else {
                if(sysUserDo == null) {
                    sysUserRoleCreateResponse.setFailure("SYS_USER_NOTEXIST", "该系统用户不存在");
                }
                else {
                    sysUserRoleCreateResponse.setFailure("SYS_ROLE_NOTEXIST", "该系统角色不存在");
                }
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserRoleCreateResponse        : " + JsonConvertUtils.convertToString(sysUserRoleCreateResponse));
            logger.debug(" <<<<<<< end createSysUserRole <<<<<<< ");
        }
        return sysUserRoleCreateResponse;
    }

    @Override
    public SysUserRoleModifyResponse modifySysUserRole(SysUserRoleModifyRequest sysUserRoleModifyRequest) {
        return null;
    }

    @Override
    public SysUserRoleInvalidateResponse invalidateSysUserRole(SysUserRoleInvalidateRequest sysUserRoleInvalidateRequest) {
        return null;
    }

    @Override
    public SysUserRoleDeleteResponse deleteSysUserRole(SysUserRoleDeleteRequest sysUserRoleDeleteRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start deleteSysUserRole >>>>>> ");
            logger.debug(" SysUserRoleDeleteRequest     : " + JsonConvertUtils.convertToString(sysUserRoleDeleteRequest));
        }
        SysUserRoleDeleteResponse sysUserRoleDeleteResponse = new SysUserRoleDeleteResponse();
        sysUserRoleDeleteResponse.setFailureDefault();
        if(sysUserRoleDeleteRequest != null) {
            sysUserRoleDao.deleteByUserIdOrRoleId(sysUserRoleDeleteRequest.getUserId(), sysUserRoleDeleteRequest.getRoleId());
            sysUserRoleDeleteResponse.setSuccess();
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" SysUserRoleDeleteResponse    : " + JsonConvertUtils.convertToString(sysUserRoleDeleteResponse));
            logger.debug(" <<<<<<< end deleteSysUserRole <<<<<<< ");
        }
        return sysUserRoleDeleteResponse;
    }

    @Override
    public SysUserRoleGetResponse getSysUserRole(SysUserRoleGetRequest sysUserRoleGetRequest) {
        SysRoleDo sysUserRole = sysUserRoleDao.getSysUserRole(sysUserRoleGetRequest);
        SysUserRoleGetResponse response = new SysUserRoleGetResponse();
        response.setSysRole(sysUserRole);
        return response;
    }

    @Override
    public SysUserRoleQueryResponse querySysUserRole(SysUserRoleQueryRequest sysUserRoleQueryRequest) {
        return null;
    }
}
