package com.easesource.system.openservices.security.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.system.openservices.orgmgmt.constant.SysUserStateEnum;
import com.easesource.system.openservices.orgmgmt.dao.SysUserDao;
import com.easesource.system.openservices.orgmgmt.dao.SysUserExtDao;
import com.easesource.system.openservices.orgmgmt.dao.SysUserExtbizDao;
import com.easesource.system.openservices.orgmgmt.entity.SysUserDo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserExtDo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserExtbizDo;
import com.easesource.system.openservices.orgmgmt.entity.SysUserVo;
import com.easesource.system.openservices.security.entity.EaseSystemUser;
import com.easesource.system.openservices.security.entity.EaseSystemUserGrantedAuthority;
import com.easesource.system.openservices.security.service.EaseSystemUserDetailsService;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-11
 */
@Service
public class EaseSystemUserDetailsServiceImpl implements EaseSystemUserDetailsService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final SysUserDao sysUserDao;
    private final SysUserExtDao sysUserExtDao;
    private final SysUserExtbizDao sysUserExtbizDao;

    @Autowired
    public EaseSystemUserDetailsServiceImpl(SysUserDao sysUserDao, SysUserExtDao sysUserExtDao, SysUserExtbizDao sysUserExtbizDao) {
        this.sysUserDao = sysUserDao;
        this.sysUserExtDao = sysUserExtDao;
        this.sysUserExtbizDao = sysUserExtbizDao;
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start loadUserByUsername >>>>>> ");
            logger.debug(" username : " + username);
        }
        SysUserVo sysUser = sysUserDao.getSysUserVoByUserNo(username);
        if(logger.isDebugEnabled()) {
            logger.debug(" sysUser  : " + JsonConvertUtils.convertToString(sysUser));
        }
        if(sysUser == null) {
            return null;
        }
        if (sysUser.getUserState() == SysUserStateEnum.CANCLE.getValue()) {
            if ((System.currentTimeMillis() - sysUser.getGmtModified()) / 1000 < 60 * 60 * 24 * 15) {
                SysUserDo sysUserDo = new SysUserDo();
                sysUserDo.setId(sysUser.getId());
                sysUserDo.setOrgNo(sysUser.getOrgNo());
                sysUserDo.setDeptNo(sysUser.getDeptNo());
                sysUserDo.setUserNo(sysUser.getUserNo());
                sysUserDo.setUserType(sysUser.getUserType());
                sysUserDo.setUserFullname(sysUser.getUserFullname());
                sysUserDo.setUserNickname(sysUser.getUserNickname());
                sysUserDo.setUserPasswdEatype(sysUser.getUserPasswdEatype());
                sysUserDo.setUserPasswd(sysUser.getUserPasswd());
                sysUserDo.setUserHeadPhoto(sysUser.getUserHeadPhoto());
                sysUserDo.setUserMobile(sysUser.getUserMobile());
                sysUserDo.setUserEmail(sysUser.getUserEmail());
                sysUserDo.setRsnUserLocked(sysUser.getRsnUserLocked());
                sysUserDo.setGmtUserLocked(sysUser.getGmtUserLocked());
                sysUserDo.setSortSn(sysUser.getSortSn());
                sysUserDo.setValid(sysUser.isValid());
                sysUserDo.setModifier(sysUser.getModifier());
                sysUserDo.setGmtModified(System.currentTimeMillis());
                sysUserDo.setInvalider(sysUser.getInvalider());
                sysUserDo.setGmtInvalid(System.currentTimeMillis());
                sysUserDo.setUserState(SysUserStateEnum.NORMAL.getValue());
                sysUserDo.setVersion(sysUser.getVersion());
                sysUserDao.update(sysUserDo);
            }
        }

        String password = sysUser.getUserPasswd();
        if(StringUtils.isNotBlank(sysUser.getUserPasswdEatype()) && StringUtils.isNotBlank(password)) {
            password = "{" + sysUser.getUserPasswdEatype() + "}" + password;
        }
        List<EaseSystemUserGrantedAuthority> authorities = Lists.newArrayList();
        List<SysUserExtDo> sysUserExtList = Lists.newArrayList();
        List<SysUserExtbizDo> sysUserExtbizList = Lists.newArrayList();
        if(logger.isDebugEnabled()) {
            logger.debug(" password  : " + password);
        }
        return new EaseSystemUser(username, password, authorities, sysUser, sysUserExtList, sysUserExtbizList);
    }

}
