package com.easesource.system.openservices.util;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.system.openservices.basemgmt.entity.SysCodeVo;
import com.easesource.system.openservices.basemgmt.request.SysCodeGetRequest;
import com.easesource.system.openservices.basemgmt.request.SysCodeQueryRequest;
import com.easesource.system.openservices.basemgmt.response.SysCodeGetResponse;
import com.easesource.system.openservices.basemgmt.response.SysCodeQueryResponse;
import com.easesource.system.openservices.basemgmt.service.SysCodeService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-01
 */
@Component
public class EaseSystemCodeUtils {

    private static final Logger logger = LoggerFactory.getLogger(EaseSystemCodeUtils.class);

    public static EaseSystemCodeUtils easeSystemCodeUtils;

    @Resource
    private SysCodeService sysCodeService;

    @PostConstruct
    public void init() {
        easeSystemCodeUtils = this;
    }

    /**
     * 获取代码列表
     *
     * @param params
     *          条件参数
     * @return  代码列表
     */
    public static List<SysCodeVo> getSysCodeList(Map<String, Object> params) {
        if(params != null) {
            SysCodeQueryRequest sysCodeQueryRequest = JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(params), SysCodeQueryRequest.class);
            SysCodeQueryResponse sysCodeQueryResponse = easeSystemCodeUtils.sysCodeService.querySysCode(sysCodeQueryRequest);
            if(sysCodeQueryResponse.isSuccess()) {
                return sysCodeQueryResponse.getSysCodeList();
            }
        }
        return Lists.newArrayList();
    }

    /**
     * 根据代码分类编号获取代码列表
     *
     * @param codeSortNo
     *          代码分类编号
     * @return  代码列表
     */
    public static List<SysCodeVo> getSysCodeListByCodeSortNo(String codeSortNo) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("codeSortNo", codeSortNo);
        return getSysCodeList(params);
    }

    /**
     * 根据代码分类编号和代码值获取代码名称
     *
     * @param codeSortNo
     *          代码分类编号
     * @param codeValue
     *          代码值
     * @return  代码名称
     */
    public static String getCodeNameByCodeSortNoAndCodeValue(String codeSortNo, String codeValue) {
        SysCodeGetRequest sysCodeGetRequest = new SysCodeGetRequest();
        sysCodeGetRequest.setCodeSortNo(codeSortNo);
        sysCodeGetRequest.setCodeValue(codeValue);
        SysCodeGetResponse sysCodeGetResponse = easeSystemCodeUtils.sysCodeService.getSysCode(sysCodeGetRequest);
        if(sysCodeGetResponse.isSuccess()) {
            return sysCodeGetResponse.getSysCode().getCodeName();
        }
        return null;
    }

}
