package com.easesource.system.openservices.util;

import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.system.openservices.orgmgmt.request.*;
import com.easesource.system.openservices.orgmgmt.response.*;
import com.easesource.system.openservices.orgmgmt.service.SysDeptService;
import com.easesource.system.openservices.orgmgmt.service.SysOrgService;
import com.easesource.system.openservices.orgmgmt.service.SysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 */
@Component
public class EaseSystemOrgmgmtUtils {

    private static final Logger logger = LoggerFactory.getLogger(EaseSystemOrgmgmtUtils.class);

    private static EaseSystemOrgmgmtUtils easeSystemOrgmgmtUtils;

    @Resource
    private SysOrgService sysOrgService;

    @Resource
    private SysDeptService sysDeptService;

    @Resource
    private SysUserService sysUserService;

    @PostConstruct
    public void init() {
        easeSystemOrgmgmtUtils = this;
    }

    public static String generateNextChildOrgNo(String orgNo) {
        String nextChildOrgNo = easeSystemOrgmgmtUtils.sysOrgService.getMaxChildOrgNo(orgNo);
        if(nextChildOrgNo == null) {
            nextChildOrgNo = orgNo + "01";
        }
        else {
            nextChildOrgNo = String.valueOf(Long.parseLong(nextChildOrgNo) + 1);
        }
        return nextChildOrgNo;
    }

    public static String generateNextChildDeptNo(String orgNo, String deptNo) {
        Map<String, Object> maxChildDeptMap = easeSystemOrgmgmtUtils.sysDeptService.getMaxChildDeptMap(orgNo, deptNo);
        String nextChildDeptNo = null;
        if(maxChildDeptMap == null) {
            nextChildDeptNo = StringUtils.isNotBlank(deptNo) ? StringUtils.trim(deptNo) + "00" : orgNo + "_" + "00";
        }
        else {
            Object rightDeptNo = maxChildDeptMap.get("right_dept_no");
            Object lengthRightDeptNo = maxChildDeptMap.get("length_right_dept_no");
            if(rightDeptNo != null && lengthRightDeptNo != null) {
                nextChildDeptNo = orgNo + "_" + StringUtils.leftPad(String.valueOf(NumberUtils.toLong(rightDeptNo.toString()) + 1), NumberUtils.toInt(lengthRightDeptNo.toString()), '0');
            }
            else {
                nextChildDeptNo = StringUtils.isNotBlank(deptNo) ? StringUtils.trim(deptNo) + "00" : orgNo + "_" + "00";
            }
        }
        return nextChildDeptNo;
    }

    public static SysOrgCreateResponse createSysOrg(SysOrgCreateRequest sysOrgCreateRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.createSysOrg(sysOrgCreateRequest);
    }

    public static SysOrgModifyResponse modifySysOrg(SysOrgModifyRequest sysOrgModifyRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.modifySysOrg(sysOrgModifyRequest);
    }

    public static SysOrgGetResponse getSysOrg(SysOrgGetRequest sysOrgGetRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.getSysOrg(sysOrgGetRequest);
    }

    public static SysOrgExtCreateResponse createSysOrgExt(SysOrgExtCreateRequest sysOrgExtCreateRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.createSysOrgExt(sysOrgExtCreateRequest);
    }

    public static SysOrgExtModifyResponse modifySysOrgExt(SysOrgExtModifyRequest sysOrgExtModifyRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.modifySysOrgExt(sysOrgExtModifyRequest);
    }

    public static SysOrgExtInvalidateResponse invalidateSysOrgExt(SysOrgExtInvalidateRequest sysOrgExtInvalidateRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.invalidateSysOrgExt(sysOrgExtInvalidateRequest);
    }

    public static SysOrgExtDeleteResponse deleteSysOrgExt(SysOrgExtDeleteRequest sysOrgExtDeleteRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.deleteSysOrgExt(sysOrgExtDeleteRequest);
    }

    public static SysOrgExtGetResponse getSysOrgExt(SysOrgExtGetRequest sysOrgExtGetRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.getSysOrgExt(sysOrgExtGetRequest);
    }

    public static SysOrgExtQueryResponse querySysOrgExt(SysOrgExtQueryRequest sysOrgExtQueryRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.querySysOrgExt(sysOrgExtQueryRequest);
    }

    public static SysOrgExtbizCreateResponse createSysOrgExtbiz(SysOrgExtbizCreateRequest sysOrgExtbizCreateRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.createSysOrgExtbiz(sysOrgExtbizCreateRequest);
    }

    public static SysOrgExtbizModifyResponse modifySysOrgExtbiz(SysOrgExtbizModifyRequest sysOrgExtbizModifyRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.modifySysOrgExtbiz(sysOrgExtbizModifyRequest);
    }

    public static SysOrgExtbizInvalidateResponse invalidateSysOrgExtbiz(SysOrgExtbizInvalidateRequest sysOrgExtbizInvalidateRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.invalidateSysOrgExtbiz(sysOrgExtbizInvalidateRequest);
    }

    public static SysOrgExtbizDeleteResponse deleteSysOrgExtbiz(SysOrgExtbizDeleteRequest sysOrgExtbizDeleteRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.deleteSysOrgExtbiz(sysOrgExtbizDeleteRequest);
    }

    public static SysOrgExtbizGetResponse getSysOrgExtbiz(SysOrgExtbizGetRequest sysOrgExtbizGetRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.getSysOrgExtbiz(sysOrgExtbizGetRequest);
    }

    public static SysOrgExtbizQueryResponse querySysOrgExtbiz(SysOrgExtbizQueryRequest sysOrgExtbizQueryRequest) {
        return easeSystemOrgmgmtUtils.sysOrgService.querySysOrgExtbiz(sysOrgExtbizQueryRequest);
    }
    public static SysDeptCreateResponse createSysDept(SysDeptCreateRequest sysDeptCreateRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.createSysDept(sysDeptCreateRequest);
    }

    public static SysDeptModifyResponse modifySysDept(SysDeptModifyRequest sysDeptModifyRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.modifySysDept(sysDeptModifyRequest);
    }

    public static SysDeptGetResponse getSysDept(SysDeptGetRequest sysDeptGetRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.getSysDept(sysDeptGetRequest);
    }

    public static SysDeptExtCreateResponse createSysDeptExt(SysDeptExtCreateRequest sysDeptExtCreateRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.createSysDeptExt(sysDeptExtCreateRequest);
    }

    public static SysDeptExtModifyResponse modifySysDeptExt(SysDeptExtModifyRequest sysDeptExtModifyRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.modifySysDeptExt(sysDeptExtModifyRequest);
    }

    public static SysDeptExtInvalidateResponse invalidateSysDeptExt(SysDeptExtInvalidateRequest sysDeptExtInvalidateRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.invalidateSysDeptExt(sysDeptExtInvalidateRequest);
    }

    public static SysDeptExtDeleteResponse deleteSysDeptExt(SysDeptExtDeleteRequest sysDeptExtDeleteRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.deleteSysDeptExt(sysDeptExtDeleteRequest);
    }

    public static SysDeptExtGetResponse getSysDeptExt(SysDeptExtGetRequest sysDeptExtGetRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.getSysDeptExt(sysDeptExtGetRequest);
    }

    public static SysDeptExtQueryResponse querySysDeptExt(SysDeptExtQueryRequest sysDeptExtQueryRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.querySysDeptExt(sysDeptExtQueryRequest);
    }

    public static SysDeptExtbizCreateResponse createSysDeptExtbiz(SysDeptExtbizCreateRequest sysDeptExtbizCreateRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.createSysDeptExtbiz(sysDeptExtbizCreateRequest);
    }

    public static SysDeptExtbizModifyResponse modifySysDeptExtbiz(SysDeptExtbizModifyRequest sysDeptExtbizModifyRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.modifySysDeptExtbiz(sysDeptExtbizModifyRequest);
    }

    public static SysDeptExtbizInvalidateResponse invalidateSysDeptExtbiz(SysDeptExtbizInvalidateRequest sysDeptExtbizInvalidateRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.invalidateSysDeptExtbiz(sysDeptExtbizInvalidateRequest);
    }

    public static SysDeptExtbizDeleteResponse deleteSysDeptExtbiz(SysDeptExtbizDeleteRequest sysDeptExtbizDeleteRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.deleteSysDeptExtbiz(sysDeptExtbizDeleteRequest);
    }

    public static SysDeptExtbizGetResponse getSysDeptExtbiz(SysDeptExtbizGetRequest sysDeptExtbizGetRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.getSysDeptExtbiz(sysDeptExtbizGetRequest);
    }

    public static SysDeptExtbizQueryResponse querySysDeptExtbiz(SysDeptExtbizQueryRequest sysDeptExtbizQueryRequest) {
        return easeSystemOrgmgmtUtils.sysDeptService.querySysDeptExtbiz(sysDeptExtbizQueryRequest);
    }

    public static SysUserCreateResponse createSysUser(SysUserCreateRequest sysUserCreateRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.createSysUser(sysUserCreateRequest);
    }

    public static SysUserModifyResponse modifySysUser(SysUserModifyRequest sysUserModifyRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.modifySysUser(sysUserModifyRequest);
    }

    public static SysUserGetResponse getSysUser(SysUserGetRequest sysUserGetRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.getSysUser(sysUserGetRequest);
    }

    public static SysUserExtCreateResponse createSysUserExt(SysUserExtCreateRequest sysUserExtCreateRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.createSysUserExt(sysUserExtCreateRequest);
    }

    public static SysUserExtModifyResponse modifySysUserExt(SysUserExtModifyRequest sysUserExtModifyRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.modifySysUserExt(sysUserExtModifyRequest);
    }

    public static SysUserExtInvalidateResponse invalidateSysUserExt(SysUserExtInvalidateRequest sysUserExtInvalidateRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.invalidateSysUserExt(sysUserExtInvalidateRequest);
    }

    public static SysUserExtDeleteResponse deleteSysUserExt(SysUserExtDeleteRequest sysUserExtDeleteRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.deleteSysUserExt(sysUserExtDeleteRequest);
    }

    public static SysUserExtGetResponse getSysUserExt(SysUserExtGetRequest sysUserExtGetRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.getSysUserExt(sysUserExtGetRequest);
    }

    public static SysUserExtQueryResponse querySysUserExt(SysUserExtQueryRequest sysUserExtQueryRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.querySysUserExt(sysUserExtQueryRequest);
    }

    public static SysUserExtbizCreateResponse createSysUserExtbiz(SysUserExtbizCreateRequest sysUserExtbizCreateRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.createSysUserExtbiz(sysUserExtbizCreateRequest);
    }

    public static SysUserExtbizModifyResponse modifySysUserExtbiz(SysUserExtbizModifyRequest sysUserExtbizModifyRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.modifySysUserExtbiz(sysUserExtbizModifyRequest);
    }

    public static SysUserExtbizInvalidateResponse invalidateSysUserExtbiz(SysUserExtbizInvalidateRequest sysUserExtbizInvalidateRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.invalidateSysUserExtbiz(sysUserExtbizInvalidateRequest);
    }

    public static SysUserExtbizDeleteResponse deleteSysUserExtbiz(SysUserExtbizDeleteRequest sysUserExtbizDeleteRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.deleteSysUserExtbiz(sysUserExtbizDeleteRequest);
    }

    public static SysUserExtbizGetResponse getSysUserExtbiz(SysUserExtbizGetRequest sysUserExtbizGetRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.getSysUserExtbiz(sysUserExtbizGetRequest);
    }

    public static SysUserExtbizQueryResponse querySysUserExtbiz(SysUserExtbizQueryRequest sysUserExtbizQueryRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.querySysUserExtbiz(sysUserExtbizQueryRequest);
    }

    public static SysUserRoleCreateResponse createSysUserRole(SysUserRoleCreateRequest sysUserRoleCreateRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.createSysUserRole(sysUserRoleCreateRequest);
    }

    public static SysUserRoleModifyResponse modifySysUserRole(SysUserRoleModifyRequest sysUserRoleModifyRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.modifySysUserRole(sysUserRoleModifyRequest);
    }

    public static SysUserRoleInvalidateResponse invalidateSysUserRole(SysUserRoleInvalidateRequest sysUserRoleInvalidateRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.invalidateSysUserRole(sysUserRoleInvalidateRequest);
    }

    public static SysUserRoleGetResponse getSysUserRole(SysUserRoleGetRequest sysUserRoleGetRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.getSysUserRole(sysUserRoleGetRequest);
    }

    public static SysUserRoleQueryResponse querySysUserRole(SysUserRoleQueryRequest sysUserRoleQueryRequest) {
        return easeSystemOrgmgmtUtils.sysUserService.querySysUserRole(sysUserRoleQueryRequest);
    }

}
