package com.easesource.system.openservices.util;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.system.openservices.orgmgmt.service.SysDeptService;
import com.easesource.system.openservices.orgmgmt.service.SysOrgService;
import com.easesource.system.openservices.orgmgmt.service.SysUserService;
import com.easesource.system.openservices.security.entity.EaseSystemUser;
import com.easesource.system.openservices.security.service.EaseSystemUserDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-01
 */
@Component
public class EaseSystemSecurityUtils {

    private static final Logger logger = LoggerFactory.getLogger(EaseSystemSecurityUtils.class);

    private static EaseSystemSecurityUtils easeSystemSecurityUtils;

    @Resource
    private EaseSystemUserDetailsService easeSystemUserDetailsService;

    @Resource
    private SysOrgService sysOrgService;

    @Resource
    private SysDeptService sysDeptService;

    @Resource
    private SysUserService sysUserService;

    @PostConstruct
    public void init() {
        easeSystemSecurityUtils = this;
    }

    public static EaseSystemUser getAuthUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if(auth != null) {
            Object authUser = auth.getPrincipal();
            if(logger.isDebugEnabled()) {
                logger.debug("authUser  : " + JsonConvertUtils.convertToString(authUser));
            }
            if(authUser instanceof EaseSystemUser) {
                return (EaseSystemUser) authUser;
            }
            else if(authUser instanceof String) {
                return (EaseSystemUser) easeSystemSecurityUtils.easeSystemUserDetailsService.loadUserByUsername(authUser.toString());
            }
        }
        return (EaseSystemUser) easeSystemSecurityUtils.easeSystemUserDetailsService.loadUserByUsername("IESMSDEMO");
    }

    public static EaseSystemUser refreshAuthUser() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        EaseSystemUser easeSystemUser = getAuthUser();
        if(StringUtils.isNotBlank(easeSystemUser.getUsername())) {
            String username = easeSystemUser.getUsername();
            easeSystemUser = (EaseSystemUser) easeSystemSecurityUtils.easeSystemUserDetailsService.loadUserByUsername(username);
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(easeSystemUser, authentication.getCredentials());
            auth.setDetails(easeSystemUser);
            securityContext.setAuthentication(auth);
            if(logger.isDebugEnabled()) {
                logger.debug(" EaseSystemUser   : " + JsonConvertUtils.convertToString(getAuthUser()));
            }
        }
        return easeSystemUser;
    }

}
