package cn.yunrui.bizservices.ebikemgmt.dao;

import cn.yunrui.bizservices.ebikemgmt.entity.BillingSchemeInfo;

/**
 *
 */
public interface BillingSchemeDao {

    /**
     * 通过计费方案标识获取计费方案信息
     * @param schemeId
     *              计费方案标识
     * @return 计费方案信息
     */
    BillingSchemeInfo getBillingSchemeInfoById(String schemeId);

    /**
     * 通过计费方案编号获取计费方案信息
     * @param orgNo
     *              单位编号
     * @param schemeNo
     *              计费方案编号
     * @return 计费方案信息
     */
    BillingSchemeInfo getBillingSchemeInfoByNo(String orgNo, String schemeNo);

    /**
     * 通过充电设备标识获取计费方案信息
     * @param chargedeviceId
     *              充电设备标识
     * @return 计费方案信息
     */
    BillingSchemeInfo getBillingSchemeInfoByChargedeviceId(Long chargedeviceId);

    /**
     * 通过充电设备编号获取计费方案信息
     * @param orgNo
     *              单位编号
     * @param chargedeviceNo
     *              充电设备编号
     * @return 计费方案信息
     */
    BillingSchemeInfo getBillingSchemeInfoByChargedeviceNo(String orgNo, String chargedeviceNo);

    /**
     * 通过充电设备编号获取计费方案信息
     * @param orgNo
     *              单位编号
     * @param chargedeviceNo
     *              充电设备编号
     * @param chargeUserNo
     *              充电用户编号
     * @param chargeUserType
     *              充电用户类型
     * @return 计费方案信息
     */
    BillingSchemeInfo getBillingSchemeInfoByChargedeviceNo(String orgNo, String chargedeviceNo, String chargeUserNo, String chargeUserType);

}
